/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.properties.internal;

import com.shaft.cli.FileActions;
import com.shaft.driver.DriverFactory;
import com.shaft.driver.SHAFT;
import com.shaft.enums.internal.Screenshots;
import com.shaft.properties.internal.BrowserStack;
import com.shaft.properties.internal.Cucumber;
import com.shaft.properties.internal.Flags;
import com.shaft.properties.internal.Healenium;
import com.shaft.properties.internal.Internal;
import com.shaft.properties.internal.Jira;
import com.shaft.properties.internal.LambdaTest;
import com.shaft.properties.internal.Log4j;
import com.shaft.properties.internal.Mobile;
import com.shaft.properties.internal.Paths;
import com.shaft.properties.internal.Pattern;
import com.shaft.properties.internal.Performance;
import com.shaft.properties.internal.Platform;
import com.shaft.properties.internal.Properties;
import com.shaft.properties.internal.PropertyFileManager;
import com.shaft.properties.internal.Reporting;
import com.shaft.properties.internal.TestNG;
import com.shaft.properties.internal.Timeouts;
import com.shaft.properties.internal.Tinkey;
import com.shaft.properties.internal.Visuals;
import com.shaft.properties.internal.Web;
import com.shaft.tools.io.ReportManager;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import org.aeonbits.owner.ConfigFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.openqa.selenium.remote.Browser;

public class PropertiesHelper {
    private static final String DEFAULT_PROPERTIES_FOLDER_PATH = "src/main/resources/properties/default";
    private static final String TARGET_PROPERTIES_FOLDER_PATH = "src/main/resources/properties/default".replace("/default", "");

    public static void initialize() {
        PropertiesHelper.initializeDefaultProperties();
        PropertiesHelper.attachPropertyFiles();
        PropertiesHelper.loadProperties();
        PropertiesHelper.overrideScreenShotTypeForMobileAndMacPlatforms();
        PropertiesHelper.overrideForcedFlagsForMobilePlatforms();
    }

    public static void loadProperties() {
        Properties.paths = (Paths)ConfigFactory.create(Paths.class, (Map[])new Map[0]);
        PropertyFileManager.readCustomPropertyFiles();
        Properties.paths = (Paths)ConfigFactory.create(Paths.class, (Map[])new Map[0]);
        Properties.platform = (Platform)ConfigFactory.create(Platform.class, (Map[])new Map[0]);
        Properties.web = (Web)ConfigFactory.create(Web.class, (Map[])new Map[0]);
        Properties.mobile = (Mobile)ConfigFactory.create(Mobile.class, (Map[])new Map[0]);
        Properties.browserStack = (BrowserStack)ConfigFactory.create(BrowserStack.class, (Map[])new Map[0]);
        Properties.internal = (Internal)ConfigFactory.create(Internal.class, (Map[])new Map[0]);
        Properties.flags = (Flags)ConfigFactory.create(Flags.class, (Map[])new Map[0]);
        Properties.cucumber = (Cucumber)ConfigFactory.create(Cucumber.class, (Map[])new Map[0]);
        Properties.healenium = (Healenium)ConfigFactory.create(Healenium.class, (Map[])new Map[0]);
        Properties.jira = (Jira)ConfigFactory.create(Jira.class, (Map[])new Map[0]);
        Properties.pattern = (Pattern)ConfigFactory.create(Pattern.class, (Map[])new Map[0]);
        Properties.reporting = (Reporting)ConfigFactory.create(Reporting.class, (Map[])new Map[0]);
        Properties.tinkey = (Tinkey)ConfigFactory.create(Tinkey.class, (Map[])new Map[0]);
        Properties.testNG = (TestNG)ConfigFactory.create(TestNG.class, (Map[])new Map[0]);
        Properties.log4j = (Log4j)ConfigFactory.create(Log4j.class, (Map[])new Map[0]);
        Properties.visuals = (Visuals)ConfigFactory.create(Visuals.class, (Map[])new Map[0]);
        Properties.timeouts = (Timeouts)ConfigFactory.create(Timeouts.class, (Map[])new Map[0]);
        Properties.performance = (Performance)ConfigFactory.create(Performance.class, (Map[])new Map[0]);
        Properties.lambdaTest = (LambdaTest)ConfigFactory.create(LambdaTest.class, (Map[])new Map[0]);
    }

    public static void postProcessing() {
        PropertiesHelper.overrideTargetOperatingSystemForLocalExecution();
        PropertiesHelper.overrideScreenMaximizationForRemoteExecution();
        PropertiesHelper.overridePropertiesForMaximumPerformanceMode();
        PropertiesHelper.setMobilePlatform();
        PropertiesHelper.overrideScreenShotTypeForAnimatedGIF();
        PropertiesHelper.overrideScreenshotTypeForSafariBrowser();
        PropertiesHelper.setExtraAllureProperties();
    }

    private static void overrideForcedFlagsForMobilePlatforms() {
        if (Arrays.asList(org.openqa.selenium.Platform.ANDROID.toString().toLowerCase(), org.openqa.selenium.Platform.IOS.toString().toLowerCase()).contains(Properties.platform.targetPlatform().toLowerCase())) {
            SHAFT.Properties.flags.set().attemptClearBeforeTypingUsingBackspace(false);
            SHAFT.Properties.flags.set().attemptClearBeforeTyping(false);
            SHAFT.Properties.flags.set().clickUsingJavascriptWhenWebDriverClickFails(false);
            SHAFT.Properties.flags.set().enableTrueNativeMode(true);
            SHAFT.Properties.flags.set().forceCheckTextWasTypedCorrectly(false);
            SHAFT.Properties.flags.set().respectBuiltInWaitsInNativeMode(false);
            SHAFT.Properties.flags.set().handleNonSelectDropDown(false);
            SHAFT.Properties.flags.set().validateSwipeToElement(false);
        }
    }

    private static void setExtraAllureProperties() {
        System.setProperty("allure.testng.hide.configuration.failures", "true");
        System.setProperty("allure.testng.hide.disabled.tests", "true");
    }

    private static void overrideScreenShotTypeForMobileAndMacPlatforms() {
        if (Arrays.asList(org.openqa.selenium.Platform.ANDROID.toString().toLowerCase(), org.openqa.selenium.Platform.MAC.toString().toLowerCase(), org.openqa.selenium.Platform.IOS.toString().toLowerCase()).contains(Properties.platform.targetPlatform().toLowerCase())) {
            SHAFT.Properties.visuals.set().screenshotParamsScreenshotType(String.valueOf((Object)Screenshots.VIEWPORT));
        }
    }

    private static void overrideScreenMaximizationForRemoteExecution() {
        if (!SHAFT.Properties.platform.executionAddress().equalsIgnoreCase("local")) {
            SHAFT.Properties.flags.set().autoMaximizeBrowserWindow(false);
        }
    }

    private static void overrideScreenShotTypeForAnimatedGIF() {
        if (SHAFT.Properties.visuals.createAnimatedGif()) {
            SHAFT.Properties.visuals.set().screenshotParamsScreenshotType(String.valueOf((Object)Screenshots.VIEWPORT));
        }
    }

    private static void overrideTargetOperatingSystemForLocalExecution() {
        String executionAddress = Properties.platform.executionAddress();
        if (executionAddress.equals("local")) {
            if (SystemUtils.IS_OS_WINDOWS) {
                Properties.platform.set().targetPlatform(org.openqa.selenium.Platform.WINDOWS.toString());
            } else if (SystemUtils.IS_OS_LINUX) {
                Properties.platform.set().targetPlatform(org.openqa.selenium.Platform.LINUX.toString());
            } else if (SystemUtils.IS_OS_MAC) {
                Properties.platform.set().targetPlatform(org.openqa.selenium.Platform.MAC.toString());
            }
        }
    }

    private static void overrideScreenshotTypeForSafariBrowser() {
        if (SHAFT.Properties.web.targetBrowserName().equalsIgnoreCase(Browser.SAFARI.browserName())) {
            SHAFT.Properties.visuals.set().screenshotParamsScreenshotType(String.valueOf((Object)Screenshots.VIEWPORT));
        }
    }

    public static void setMobilePlatform() {
        String targetOperatingSystem = Properties.platform.targetPlatform();
        if (Arrays.asList("Android", "iOS").contains(targetOperatingSystem)) {
            Properties.mobile.set().platformName(Properties.platform.targetPlatform().toLowerCase());
        }
    }

    private static void initializeDefaultProperties() {
        System.setProperty("webdriver.http.factory", "jdk-http-client");
        URL propertiesFolder = PropertyFileManager.class.getResource(DEFAULT_PROPERTIES_FOLDER_PATH.replace("src/main", "") + "/");
        String propertiesFolderPath = "";
        propertiesFolderPath = propertiesFolder != null ? propertiesFolder.getFile() : DEFAULT_PROPERTIES_FOLDER_PATH;
        boolean isExternalRun = propertiesFolderPath.contains("file:");
        if (isExternalRun) {
            FileActions.getInstance(true).copyFolderFromJar(propertiesFolderPath, DEFAULT_PROPERTIES_FOLDER_PATH);
        } else {
            FileActions.getInstance(true).copyFolder(propertiesFolderPath, DEFAULT_PROPERTIES_FOLDER_PATH);
        }
        String finalPropertiesFolderPath = propertiesFolderPath;
        Arrays.asList("/cucumber.properties", "/customWebdriverCapabilities.properties", "/log4j2.properties", "/TestNG.properties").forEach(file -> {
            if (!FileActions.getInstance(true).doesFileExist(TARGET_PROPERTIES_FOLDER_PATH + file)) {
                if (isExternalRun) {
                    FileActions.getInstance(true).copyFileFromJar(finalPropertiesFolderPath, TARGET_PROPERTIES_FOLDER_PATH, file.replace("/", ""));
                } else {
                    FileActions.getInstance(true).copyFile(finalPropertiesFolderPath + file, TARGET_PROPERTIES_FOLDER_PATH + file);
                }
            }
        });
    }

    private static void attachPropertyFiles() {
        ReportManager.logDiscrete("Reading properties directory: " + TARGET_PROPERTIES_FOLDER_PATH);
        FileUtils.listFiles((File)new File(TARGET_PROPERTIES_FOLDER_PATH), (String[])new String[]{"properties"}, (boolean)false).forEach(propertyFile -> ReportManager.logDiscrete("Loading properties file: " + String.valueOf(propertyFile)));
    }

    private static void overridePropertiesForMaximumPerformanceMode() {
        int maximumPerformanceMode = SHAFT.Properties.flags.maximumPerformanceMode();
        switch (maximumPerformanceMode) {
            case 1: 
            case 2: {
                SHAFT.Properties.healenium.set().healEnabled(false);
                SHAFT.Properties.flags.set().autoMaximizeBrowserWindow(false);
                SHAFT.Properties.visuals.set().screenshotParamsWhenToTakeAScreenshot("ValidationPointsOnly");
                SHAFT.Properties.visuals.set().screenshotParamsHighlightElements(true);
                SHAFT.Properties.visuals.set().screenshotParamsHighlightMethod("AI");
                SHAFT.Properties.visuals.set().screenshotParamsScreenshotType(String.valueOf((Object)Screenshots.VIEWPORT));
                SHAFT.Properties.visuals.set().screenshotParamsWatermark(true);
                SHAFT.Properties.visuals.set().createAnimatedGif(false);
                SHAFT.Properties.visuals.set().videoParamsRecordVideo(false);
                SHAFT.Properties.reporting.set().debugMode(false);
                SHAFT.Properties.reporting.set().captureElementName(false);
                SHAFT.Properties.web.set().headlessExecution(false);
                if (maximumPerformanceMode != 2 || DriverFactory.DriverType.SAFARI.getValue().equals(SHAFT.Properties.web.targetBrowserName())) break;
                SHAFT.Properties.web.set().headlessExecution(true);
                break;
            }
        }
    }
}

