/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.properties.internal;

import com.shaft.properties.internal.EngineProperties;
import com.shaft.properties.internal.Properties;
import com.shaft.tools.io.ReportManager;
import java.util.Map;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigFactory;

@Config.Sources(value={"system:properties", "file:src/main/resources/properties/Reporting.properties", "file:src/main/resources/properties/default/Reporting.properties", "classpath:Reporting.properties"})
public interface Reporting
extends EngineProperties {
    private static void setProperty(String key, String value) {
        java.util.Properties updatedProps = new java.util.Properties();
        updatedProps.setProperty(key, value);
        Properties.reporting = (Reporting)ConfigFactory.create(Reporting.class, (Map[])new Map[]{updatedProps});
        System.setProperty(key, value);
        if (!key.equals("disableLogging")) {
            ReportManager.logDiscrete("Setting \"" + key + "\" property with \"" + value + "\".");
        }
    }

    @Config.Key(value="captureElementName")
    @Config.DefaultValue(value="true")
    public boolean captureElementName();

    @Config.Key(value="captureWebDriverLogs")
    @Config.DefaultValue(value="false")
    public boolean captureWebDriverLogs();

    @Config.Key(value="alwaysLogDiscreetly")
    @Config.DefaultValue(value="false")
    public boolean alwaysLogDiscreetly();

    @Config.Key(value="debugMode")
    @Config.DefaultValue(value="false")
    public boolean debugMode();

    @Config.Key(value="cleanAllureResultsDirectoryBeforeExecution")
    @Config.DefaultValue(value="true")
    public boolean cleanAllureResultsDirectoryBeforeExecution();

    @Config.Key(value="generateAllureReportArchive")
    @Config.DefaultValue(value="false")
    public boolean generateAllureReportArchive();

    @Config.Key(value="openAllureReportAfterExecution")
    @Config.DefaultValue(value="true")
    public boolean openAllureReportAfterExecution();

    @Config.Key(value="openLighthouseReportWhileExecution")
    @Config.DefaultValue(value="false")
    public boolean openLighthouseReportWhileExecution();

    @Config.Key(value="cleanSummaryReportsDirectoryBeforeExecution")
    @Config.DefaultValue(value="true")
    public boolean cleanSummaryReportsDirectoryBeforeExecution();

    @Config.Key(value="openExecutionSummaryReportAfterExecution")
    @Config.DefaultValue(value="false")
    public boolean openExecutionSummaryReportAfterExecution();

    @Config.Key(value="disableLogging")
    @Config.DefaultValue(value="true")
    public boolean disableLogging();

    @Override
    default public SetProperty set() {
        return new SetProperty();
    }

    public static class SetProperty
    implements EngineProperties.SetProperty {
        public SetProperty captureElementName(boolean value) {
            Reporting.setProperty("captureElementName", String.valueOf(value));
            return this;
        }

        public SetProperty forceCheckForElementVisibility(boolean value) {
            Reporting.setProperty("forceCheckForElementVisibility", String.valueOf(value));
            return this;
        }

        public SetProperty captureWebDriverLogs(boolean value) {
            Reporting.setProperty("captureWebDriverLogs", String.valueOf(value));
            return this;
        }

        public SetProperty alwaysLogDiscreetly(boolean value) {
            Reporting.setProperty("alwaysLogDiscreetly", String.valueOf(value));
            return this;
        }

        public SetProperty debugMode(boolean value) {
            Reporting.setProperty("debugMode", String.valueOf(value));
            return this;
        }

        public SetProperty generateAllureReportArchive(boolean value) {
            Reporting.setProperty("generateAllureReportArchive", String.valueOf(value));
            return this;
        }

        public SetProperty openAllureReportAfterExecution(boolean value) {
            Reporting.setProperty("openAllureReportAfterExecution", String.valueOf(value));
            return this;
        }

        public SetProperty openLighthouseReportWhileExecution(boolean value) {
            Reporting.setProperty("openLighthouseReportWhileExecution", String.valueOf(value));
            return this;
        }

        public SetProperty openExecutionSummaryReportAfterExecution(boolean value) {
            Reporting.setProperty("openExecutionSummaryReportAfterExecution", String.valueOf(value));
            return this;
        }

        public SetProperty disableLogging(boolean value) {
            Reporting.setProperty("disableLogging", String.valueOf(value));
            return this;
        }
    }
}

