/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.properties.internal;

import com.shaft.properties.internal.EngineProperties;
import com.shaft.properties.internal.Properties;
import com.shaft.tools.io.ReportManager;
import java.util.Map;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigFactory;

@Config.Sources(value={"system:properties", "file:src/main/resources/properties/Timeouts.properties", "file:src/main/resources/properties/default/Timeouts.properties", "classpath:Timeouts.properties"})
public interface Timeouts
extends EngineProperties {
    private static void setProperty(String key, String value) {
        java.util.Properties updatedProps = new java.util.Properties();
        updatedProps.setProperty(key, value);
        Properties.timeouts = (Timeouts)ConfigFactory.create(Timeouts.class, (Map[])new Map[]{updatedProps});
        System.setProperty(key, value);
        ReportManager.logDiscrete("Setting \"" + key + "\" property with \"" + value + "\".");
    }

    @Config.Key(value="waitForLazyLoading")
    @Config.DefaultValue(value="true")
    public Boolean waitForLazyLoading();

    @Config.Key(value="lazyLoadingTimeout")
    @Config.DefaultValue(value="30")
    public int lazyLoadingTimeout();

    @Config.Key(value="browserNavigationTimeout")
    @Config.DefaultValue(value="60")
    public int browserNavigationTimeout();

    @Config.Key(value="pageLoadTimeout")
    @Config.DefaultValue(value="60")
    public int pageLoadTimeout();

    @Config.Key(value="scriptExecutionTimeout")
    @Config.DefaultValue(value="60")
    public int scriptExecutionTimeout();

    @Config.Key(value="defaultElementIdentificationTimeout")
    @Config.DefaultValue(value="60")
    public double defaultElementIdentificationTimeout();

    @Config.Key(value="apiSocketTimeout")
    @Config.DefaultValue(value="30")
    public int apiSocketTimeout();

    @Config.Key(value="apiConnectionTimeout")
    @Config.DefaultValue(value="30")
    public int apiConnectionTimeout();

    @Config.Key(value="apiConnectionManagerTimeout")
    @Config.DefaultValue(value="30")
    public int apiConnectionManagerTimeout();

    @Config.Key(value="shellSessionTimeout")
    @Config.DefaultValue(value="30")
    public long shellSessionTimeout();

    @Config.Key(value="dockerCommandTimeout")
    @Config.DefaultValue(value="30")
    public int dockerCommandTimeout();

    @Config.Key(value="databaseLoginTimeout")
    @Config.DefaultValue(value="30")
    public int databaseLoginTimeout();

    @Config.Key(value="databaseNetworkTimeout")
    @Config.DefaultValue(value="30")
    public int databaseNetworkTimeout();

    @Config.Key(value="databaseQueryTimeout")
    @Config.DefaultValue(value="30")
    public int databaseQueryTimeout();

    @Config.Key(value="waitForRemoteServerToBeUp")
    @Config.DefaultValue(value="false")
    public Boolean waitForRemoteServerToBeUp();

    @Config.Key(value="timeoutForRemoteServerToBeUp")
    @Config.DefaultValue(value="10")
    public int timeoutForRemoteServerToBeUp();

    @Config.Key(value="remoteServerInstanceCreationTimeout")
    @Config.DefaultValue(value="10")
    public int remoteServerInstanceCreationTimeout();

    @Config.Key(value="waitUntilTimeout")
    @Config.DefaultValue(value="60")
    public int waitUntilTimeout();

    @Override
    default public SetProperty set() {
        return new SetProperty();
    }

    public static class SetProperty
    implements EngineProperties.SetProperty {
        public SetProperty waitForLazyLoading(boolean value) {
            Timeouts.setProperty("waitForLazyLoading", String.valueOf(value));
            return this;
        }

        public SetProperty lazyLoadingTimeout(int value) {
            Timeouts.setProperty("lazyLoadingTimeout", String.valueOf(value));
            return this;
        }

        public SetProperty browserNavigationTimeout(int value) {
            Timeouts.setProperty("browserNavigationTimeout", String.valueOf(value));
            return this;
        }

        public SetProperty pageLoadTimeout(int value) {
            Timeouts.setProperty("pageLoadTimeout", String.valueOf(value));
            return this;
        }

        public SetProperty scriptExecutionTimeout(int value) {
            Timeouts.setProperty("scriptExecutionTimeout", String.valueOf(value));
            return this;
        }

        public SetProperty defaultElementIdentificationTimeout(double value) {
            Timeouts.setProperty("defaultElementIdentificationTimeout", String.valueOf(value));
            return this;
        }

        public SetProperty apiSocketTimeout(int value) {
            Timeouts.setProperty("apiSocketTimeout", String.valueOf(value));
            return this;
        }

        public SetProperty apiConnectionTimeout(int value) {
            Timeouts.setProperty("apiConnectionTimeout", String.valueOf(value));
            return this;
        }

        public SetProperty apiConnectionManagerTimeout(int value) {
            Timeouts.setProperty("apiConnectionManagerTimeout", String.valueOf(value));
            return this;
        }

        public SetProperty shellSessionTimeout(long value) {
            Timeouts.setProperty("shellSessionTimeout", String.valueOf(value));
            return this;
        }

        public SetProperty dockerCommandTimeout(int value) {
            Timeouts.setProperty("dockerCommandTimeout", String.valueOf(value));
            return this;
        }

        public SetProperty databaseLoginTimeout(int value) {
            Timeouts.setProperty("databaseLoginTimeout", String.valueOf(value));
            return this;
        }

        public SetProperty databaseNetworkTimeout(int value) {
            Timeouts.setProperty("databaseNetworkTimeout", String.valueOf(value));
            return this;
        }

        public SetProperty databaseQueryTimeout(int value) {
            Timeouts.setProperty("databaseQueryTimeout", String.valueOf(value));
            return this;
        }

        public SetProperty waitForRemoteServerToBeUp(boolean value) {
            Timeouts.setProperty("waitForRemoteServerToBeUp", String.valueOf(value));
            return this;
        }

        public SetProperty timeoutForRemoteServerToBeUp(int value) {
            Timeouts.setProperty("timeoutForRemoteServerToBeUp", String.valueOf(value));
            return this;
        }

        public SetProperty remoteServerInstanceCreationTimeout(int value) {
            Timeouts.setProperty("remoteServerInstanceCreationTimeout", String.valueOf(value));
            return this;
        }

        public SetProperty waitUntilTimeout(int value) {
            Timeouts.setProperty("waitUntilTimeout", String.valueOf(value));
            return this;
        }
    }
}

