/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.properties.internal;

import com.shaft.properties.internal.EngineProperties;
import com.shaft.properties.internal.Properties;
import com.shaft.tools.io.ReportManager;
import java.util.Map;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigFactory;

@Config.Sources(value={"system:properties", "file:src/main/resources/properties/VisualValidations.properties", "file:src/main/resources/properties/default/VisualValidations.properties", "classpath:VisualValidations.properties"})
public interface Visuals
extends EngineProperties {
    private static void setProperty(String key, String value) {
        java.util.Properties updatedProps = new java.util.Properties();
        updatedProps.setProperty(key, value);
        Properties.visuals = (Visuals)ConfigFactory.create(Visuals.class, (Map[])new Map[]{updatedProps});
        System.setProperty(key, value);
        ReportManager.logDiscrete("Setting \"" + key + "\" property with \"" + value + "\".");
    }

    @Config.Key(value="visualMatchingThreshold")
    @Config.DefaultValue(value="0.90")
    public double visualMatchingThreshold();

    @Config.Key(value="screenshotParams_scalingFactor")
    @Config.DefaultValue(value="1.0")
    public double screenshotParamsScalingFactor();

    @Config.Key(value="screenshotParams_whenToTakeAScreenshot")
    @Config.DefaultValue(value="ValidationPointsOnly")
    public String screenshotParamsWhenToTakeAScreenshot();

    @Config.Key(value="screenshotParams_screenshotType")
    @Config.DefaultValue(value="fullPage")
    public String screenshotParamsScreenshotType();

    @Config.Key(value="screenshotParams_highlightElements")
    @Config.DefaultValue(value="true")
    public boolean screenshotParamsHighlightElements();

    @Config.Key(value="screenshotParams_highlightMethod")
    @Config.DefaultValue(value="AI")
    public String screenshotParamsHighlightMethod();

    @Config.Key(value="screenshotParams_skippedElementsFromScreenshot")
    @Config.DefaultValue(value="")
    public String screenshotParamsSkippedElementsFromScreenshot();

    @Config.Key(value="screenshotParams_watermark")
    @Config.DefaultValue(value="true")
    public boolean screenshotParamsWatermark();

    @Config.Key(value="screenshotParams_watermarkOpacity")
    @Config.DefaultValue(value="0.2")
    public float screenshotParamsWatermarkOpacity();

    @Config.Key(value="createAnimatedGif")
    @Config.DefaultValue(value="false")
    public boolean createAnimatedGif();

    @Config.Key(value="animatedGif_frameDelay")
    @Config.DefaultValue(value="500")
    public int animatedGifFrameDelay();

    @Config.Key(value="videoParams_recordVideo")
    @Config.DefaultValue(value="false")
    public boolean videoParamsRecordVideo();

    @Config.Key(value="videoParams_scope")
    @Config.DefaultValue(value="DriverSession")
    public String videoParamsScope();

    @Config.Key(value="whenToTakePageSourceSnapshot")
    @Config.DefaultValue(value="Never")
    public String whenToTakePageSourceSnapshot();

    @Override
    default public SetProperty set() {
        return new SetProperty();
    }

    public static class SetProperty
    implements EngineProperties.SetProperty {
        public SetProperty visualMatchingThreshold(double value) {
            Visuals.setProperty("visualMatchingThreshold", String.valueOf(value));
            return this;
        }

        public SetProperty screenshotParamsScalingFactor(double value) {
            Visuals.setProperty("screenshotParams_scalingFactor", String.valueOf(value));
            return this;
        }

        public SetProperty screenshotParamsWhenToTakeAScreenshot(String value) {
            Visuals.setProperty("screenshotParams_whenToTakeAScreenshot", value);
            return this;
        }

        public SetProperty screenshotParamsScreenshotType(String value) {
            Visuals.setProperty("screenshotParams_screenshotType", value);
            return this;
        }

        public SetProperty screenshotParamsHighlightElements(boolean value) {
            Visuals.setProperty("screenshotParams_highlightElements", String.valueOf(value));
            return this;
        }

        public SetProperty screenshotParamsHighlightMethod(String value) {
            Visuals.setProperty("screenshotParams_highlightMethod", value);
            return this;
        }

        public SetProperty screenshotParamsSkippedElementsFromScreenshot(String value) {
            Visuals.setProperty("screenshotParams_skippedElementsFromScreenshot", value);
            return this;
        }

        public SetProperty screenshotParamsWatermark(boolean value) {
            Visuals.setProperty("screenshotParams_watermark", String.valueOf(value));
            return this;
        }

        public SetProperty screenshotParamsWatermarkOpacity(float value) {
            Visuals.setProperty("screenshotParams_watermarkOpacity", String.valueOf(value));
            return this;
        }

        public SetProperty createAnimatedGif(boolean value) {
            Visuals.setProperty("createAnimatedGif", String.valueOf(value));
            return this;
        }

        public SetProperty animatedGifFrameDelay(int value) {
            Visuals.setProperty("animatedGif_frameDelay", String.valueOf(value));
            return this;
        }

        public SetProperty videoParamsRecordVideo(boolean value) {
            Visuals.setProperty("videoParams_recordVideo", String.valueOf(value));
            return this;
        }

        public SetProperty videoParamsScope(String value) {
            Visuals.setProperty("videoParams_scope", value);
            return this;
        }

        public SetProperty whenToTakePageSourceSnapshot(String value) {
            Visuals.setProperty("whenToTakePageSourceSnapshot", value);
            return this;
        }
    }
}

