/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.properties.internal;

import com.shaft.properties.internal.EngineProperties;
import com.shaft.properties.internal.Properties;
import com.shaft.tools.io.ReportManager;
import java.util.Map;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigFactory;

@Config.Sources(value={"system:properties", "file:src/main/resources/properties/WebCapabilities.properties", "file:src/main/resources/properties/default/WebCapabilities.properties", "classpath:WebCapabilities.properties"})
public interface Web
extends EngineProperties {
    private static void setProperty(String key, String value) {
        java.util.Properties updatedProps = new java.util.Properties();
        updatedProps.setProperty(key, value);
        Properties.web = (Web)ConfigFactory.create(Web.class, (Map[])new Map[]{updatedProps});
        System.setProperty(key, value);
        ReportManager.logDiscrete("Setting \"" + key + "\" property with \"" + value + "\".");
    }

    @Config.Key(value="targetBrowserName")
    @Config.DefaultValue(value="chrome")
    public String targetBrowserName();

    @Config.Key(value="headlessExecution")
    @Config.DefaultValue(value="false")
    public boolean headlessExecution();

    @Config.Key(value="isMobileEmulation")
    @Config.DefaultValue(value="false")
    public boolean isMobileEmulation();

    @Config.Key(value="mobileEmulation.isCustomDevice")
    @Config.DefaultValue(value="false")
    public boolean mobileEmulationIsCustomDevice();

    @Config.Key(value="mobileEmulation.deviceName")
    @Config.DefaultValue(value="")
    public String mobileEmulationDeviceName();

    @Config.Key(value="mobileEmulation.width")
    @Config.DefaultValue(value="")
    public int mobileEmulationWidth();

    @Config.Key(value="mobileEmulation.height")
    @Config.DefaultValue(value="")
    public int mobileEmulationHeight();

    @Config.Key(value="mobileEmulation.pixelRatio")
    @Config.DefaultValue(value="1.0")
    public double mobileEmulationPixelRatio();

    @Config.Key(value="mobileEmulation.userAgent")
    @Config.DefaultValue(value="")
    public String mobileEmulationUserAgent();

    @Config.Key(value="baseURL")
    @Config.DefaultValue(value="")
    public String baseURL();

    @Config.Key(value="browserWindowWidth")
    @Config.DefaultValue(value="1920")
    public int browserWindowWidth();

    @Config.Key(value="browserWindowHeight")
    @Config.DefaultValue(value="1080")
    public int browserWindowHeight();

    @Override
    default public SetProperty set() {
        return new SetProperty();
    }

    public static class SetProperty
    implements EngineProperties.SetProperty {
        public SetProperty baseURL(String value) {
            Web.setProperty("baseURL", value);
            return this;
        }

        public SetProperty targetBrowserName(String value) {
            Web.setProperty("targetBrowserName", value);
            return this;
        }

        public SetProperty headlessExecution(boolean value) {
            Web.setProperty("headlessExecution", String.valueOf(value));
            return this;
        }

        public SetProperty isMobileEmulation(boolean value) {
            Web.setProperty("isMobileEmulation", String.valueOf(value));
            return this;
        }

        public SetProperty mobileEmulationIsCustomDevice(boolean value) {
            Web.setProperty("mobileEmulation.isCustomDevice", String.valueOf(value));
            return this;
        }

        public SetProperty mobileEmulationDeviceName(String value) {
            Web.setProperty("mobileEmulation.deviceName", value);
            return this;
        }

        public SetProperty mobileEmulationWidth(int value) {
            Web.setProperty("mobileEmulation.width", String.valueOf(value));
            return this;
        }

        public SetProperty mobileEmulationHeight(int value) {
            Web.setProperty("mobileEmulation.height", String.valueOf(value));
            return this;
        }

        public SetProperty mobileEmulationPixelRatio(double value) {
            Web.setProperty("mobileEmulation.pixelRatio", String.valueOf(value));
            return this;
        }

        public SetProperty mobileEmulationUserAgent(String value) {
            Web.setProperty("mobileEmulation.userAgent", value);
            return this;
        }

        public SetProperty browserWindowWidth(int value) {
            Web.setProperty("browserWindowWidth", String.valueOf(value));
            return this;
        }

        public SetProperty browserWindowHeight(int value) {
            Web.setProperty("browserWindowHeight", String.valueOf(value));
            return this;
        }
    }
}

