/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.tools.internal.support;

import com.shaft.cli.FileActions;
import com.shaft.driver.SHAFT;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.ReportManagerHelper;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testng.Assert;

public class JavaHelper {
    private JavaHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static String replaceRegex(String[] specialCharactersArray, String text) {
        for (int i = 0; i < specialCharactersArray.length; ++i) {
            String oldChar = specialCharactersArray[i];
            specialCharactersArray[i] = "\\" + specialCharactersArray[i];
            text = text.replace(oldChar, specialCharactersArray[i]);
        }
        return text;
    }

    public static String removeSpecialCharacters(String text) {
        StringBuilder cleanString = new StringBuilder();
        if (text != null) {
            for (int i = 0; i < text.toCharArray().length; ++i) {
                String character = String.valueOf(text.toCharArray()[i]);
                if (Pattern.compile("[^a-z0-9]", 2).matcher(character).find()) {
                    cleanString.append("_");
                    continue;
                }
                cleanString.append(character);
            }
        }
        return cleanString.toString();
    }

    public static String replaceRegex(String text) {
        String[] specialCharactersArray = new String[]{"[", "]", "^", "$", ".", "|", "?", "*", "+", "(", ")", "{", "}"};
        return JavaHelper.replaceRegex(specialCharactersArray, text);
    }

    public static String convertBase64(String text) {
        return Base64.getEncoder().encodeToString(text.getBytes());
    }

    public static int compareTwoObjects(Object expectedValue, Object actualValue, int comparisonType, Boolean validationType) {
        ReportManager.logDiscrete("Expected \"" + String.valueOf(expectedValue) + "\", and actual \"" + String.valueOf(actualValue) + "\"");
        if ("null".equals(expectedValue)) {
            expectedValue = null;
        }
        if ("null".equals(actualValue)) {
            actualValue = null;
        }
        if (Boolean.TRUE.equals(validationType)) {
            try {
                return JavaHelper.compareTwoObjectsPositively(expectedValue, actualValue, comparisonType);
            }
            catch (AssertionError e) {
                return 0;
            }
            catch (Exception e) {
                ReportManagerHelper.logDiscrete(e);
                return -2;
            }
        }
        try {
            return JavaHelper.compareTwoObjectsNegatively(expectedValue, actualValue, comparisonType);
        }
        catch (AssertionError e) {
            return 0;
        }
        catch (Exception e) {
            ReportManagerHelper.logDiscrete(e);
            return -2;
        }
    }

    private static int compareTwoObjectsPositively(Object expectedValue, Object actualValue, int comparisonType) {
        block0 : switch (comparisonType) {
            case 1: {
                Object object = expectedValue;
                int n = 0;
                block11: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Number.class}, (Object)object, n)) {
                        case -1: {
                            Assert.assertNull((Object)actualValue);
                            break block0;
                        }
                        case 0: {
                            String expectedString = (String)object;
                            if (!(actualValue instanceof String)) {
                                n = 1;
                                continue block11;
                            }
                            String actualString = (String)actualValue;
                            Assert.assertEquals((String)actualString, (String)expectedString);
                            break block0;
                        }
                        case 1: {
                            Number expectedNumber = (Number)object;
                            if (!(actualValue instanceof Number)) {
                                n = 2;
                                continue block11;
                            }
                            Number actualNumber = (Number)actualValue;
                            Assert.assertEquals((Object)actualNumber, (Object)expectedNumber);
                            break block0;
                        }
                    }
                    break;
                }
                Assert.assertEquals((Object)actualValue, (Object)expectedValue);
                break;
            }
            case 2: {
                Assert.assertTrue((boolean)String.valueOf(actualValue).matches(String.valueOf(expectedValue)));
                break;
            }
            case 3: {
                Assert.assertTrue((boolean)String.valueOf(actualValue).contains(String.valueOf(expectedValue)));
                break;
            }
            case 4: {
                Assert.assertTrue((boolean)String.valueOf(actualValue).equalsIgnoreCase(String.valueOf(expectedValue)));
                break;
            }
            default: {
                return -1;
            }
        }
        return 1;
    }

    private static int compareTwoObjectsNegatively(Object expectedValue, Object actualValue, int comparisonType) {
        block0 : switch (comparisonType) {
            case 1: {
                Object object = expectedValue;
                int n = 0;
                block11: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Number.class}, (Object)object, n)) {
                        case -1: {
                            Assert.assertNotNull((Object)actualValue);
                            break block0;
                        }
                        case 0: {
                            String expectedString = (String)object;
                            if (!(actualValue instanceof String)) {
                                n = 1;
                                continue block11;
                            }
                            String actualString = (String)actualValue;
                            Assert.assertNotEquals((Object)actualString, (Object)expectedString);
                            break block0;
                        }
                        case 1: {
                            Number expectedNumber = (Number)object;
                            if (!(actualValue instanceof Number)) {
                                n = 2;
                                continue block11;
                            }
                            Number actualNumber = (Number)actualValue;
                            Assert.assertNotEquals((Object)actualNumber, (Object)expectedNumber);
                            break block0;
                        }
                    }
                    break;
                }
                Assert.assertNotEquals((Object)actualValue, (Object)expectedValue);
                break;
            }
            case 2: {
                Assert.assertFalse((boolean)String.valueOf(actualValue).matches(String.valueOf(expectedValue)));
                break;
            }
            case 3: {
                Assert.assertFalse((boolean)String.valueOf(actualValue).contains(String.valueOf(expectedValue)));
                break;
            }
            case 4: {
                Assert.assertFalse((boolean)String.valueOf(actualValue).equalsIgnoreCase(String.valueOf(expectedValue)));
                break;
            }
            default: {
                return -1;
            }
        }
        return 1;
    }

    public static String convertToSentenceCase(String text) {
        Pattern WORD_FINDER = Pattern.compile("(([A-Z]*[a-z]*)|([A-Z]))");
        Matcher matcher = WORD_FINDER.matcher(text);
        ArrayList<String> words = new ArrayList<String>();
        while (matcher.find()) {
            words.add(matcher.group(0));
        }
        ArrayList<String> capitalized = new ArrayList<String>();
        for (int i = 0; i < words.size(); ++i) {
            String currentWord = (String)words.get(i);
            if (i == 0) {
                capitalized.add(JavaHelper.capitalizeFirst(currentWord));
                continue;
            }
            capitalized.add(currentWord.toLowerCase());
        }
        return String.join((CharSequence)" ", capitalized).trim();
    }

    private static String capitalizeFirst(String word) {
        return word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase();
    }

    public static String appendTestDataToRelativePath(String relativePath) {
        String testDataFolderPath;
        if (FileActions.getInstance(true).doesFileExist(relativePath)) {
            return relativePath;
        }
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if (relativePath.contains(testDataFolderPath = SHAFT.Properties.paths.testData())) {
            return relativePath;
        }
        return testDataFolderPath + relativePath;
    }
}

