/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.tools.internal.tms;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.shaft.cli.FileActions;
import com.shaft.driver.SHAFT;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.ReportManagerHelper;
import io.restassured.RestAssured;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.config.SSLConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Calendar;
import java.util.List;

public class XrayIntegrationHelper {
    private static final String authType = SHAFT.Properties.jira.authType() + " ";
    private static final String _ProjectKey = SHAFT.Properties.jira.projectKey();
    private static String _JiraAuthorization = SHAFT.Properties.jira.authorization();
    private static String _TestExecutionID = null;

    private static void setup() {
        RestAssured.baseURI = SHAFT.Properties.jira.url();
        if (authType.equals("Basic ")) {
            _JiraAuthorization = Base64.getEncoder().encodeToString(_JiraAuthorization.getBytes());
        }
        RestAssured.given().config(RestAssuredConfig.config().sslConfig(SSLConfig.sslConfig().allowAllHostnames())).relaxedHTTPSValidation();
    }

    public static void importCucumberResults(String filepath) throws Exception {
        XrayIntegrationHelper.setup();
        String reportPath = FileActions.getInstance(true).getAbsolutePath(filepath);
        ReportManager.logDiscrete("uploading file: " + reportPath);
        ReportManager.logDiscrete("Length: " + new File(reportPath).length());
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonElement je = JsonParser.parseString((String)new String(Files.readAllBytes(Paths.get(reportPath, new String[0]))));
        String prettyJsonString = gson.toJson(je);
        try {
            Response response = (Response)((ValidatableResponse)((Response)RestAssured.given().contentType("application/json").header("Authorization", (Object)(authType + _JiraAuthorization), new Object[0]).body(prettyJsonString).expect().statusCode(200).when().post("/rest/raven/1.0/import/execution/cucumber", new Object[0])).then()).extract().response();
            _TestExecutionID = response.jsonPath().get("testExecIssue.key").toString();
            ReportManager.logDiscrete("ExecutionID: " + _TestExecutionID);
        }
        catch (Exception e) {
            ReportManagerHelper.logDiscrete(e);
        }
    }

    public static void renameTestExecutionSuit(String executionName, String executionDescription) {
        if (_TestExecutionID == null) {
            return;
        }
        XrayIntegrationHelper.setup();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String body = "{\r\n    \"fields\" : {\r\n        \"summary\": \"Execution results " + executionName + " | " + sdf.format(Calendar.getInstance().getTime()) + "\",\r\n        \"description\": \"" + executionDescription + "\"\r\n    }\r\n}";
        try {
            ((ValidatableResponse)((Response)RestAssured.given().contentType("application/json").header("Authorization", (Object)(authType + _JiraAuthorization), new Object[0]).body(body).expect().statusCode(204).when().put("/rest/api/2/issue/" + _TestExecutionID, new Object[0])).then()).extract().response();
        }
        catch (Exception e) {
            ReportManagerHelper.logDiscrete(e);
        }
    }

    public static void importTestNGResults(String filepath) {
        XrayIntegrationHelper.setup();
        String reportPath = FileActions.getInstance(true).getAbsolutePath(filepath);
        ReportManager.logDiscrete("uploading file: " + reportPath);
        ReportManager.logDiscrete("Length: " + new File(reportPath).length());
        try {
            Response response = (Response)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().config(RestAssured.config().encoderConfig(EncoderConfig.encoderConfig().encodeContentTypeAs("multipart/form-data", ContentType.TEXT))).relaxedHTTPSValidation().contentType("multipart/form-data").header("Authorization", (Object)(authType + _JiraAuthorization), new Object[0]).multiPart(new File(reportPath)).when().post("/rest/raven/1.0/import/execution/testng?projectKey=" + _ProjectKey, new Object[0])).then()).log().all()).extract().response();
            _TestExecutionID = response.jsonPath().get("testExecIssue.key").toString();
            ReportManager.logDiscrete("ExecutionID: " + _TestExecutionID);
        }
        catch (Exception e) {
            ReportManagerHelper.logDiscrete(e);
        }
    }

    public static String createIssue(List<String> files, String testCaseName, String description) {
        XrayIntegrationHelper.setup();
        try {
            String issueRequestBody = "{\n  \"fields\":{\n    \"project\":{\n      \"key\":\"${PROJECT_KEY}\"\n    },\n    \"summary\":\"${BUG_SUMMERY}\",\n    \"description\":\"Reported By SHAFT Automation Engine|| Execution Log ${BUG_DESCRIPTION}\",\n    \"assignee\":{\n      \"name\":\"${ASSIGNEE_NAME}\"\n    },\n    \"issuetype\":{\n      \"name\":\"Bug\"\n    }\n  }\n}\n";
            Response response = (Response)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().config(RestAssured.config().encoderConfig(EncoderConfig.encoderConfig().encodeContentTypeAs("application/json", ContentType.JSON))).relaxedHTTPSValidation().contentType("application/json").header("Authorization", (Object)(authType + _JiraAuthorization), new Object[0]).when().body(issueRequestBody.replace("${PROJECT_KEY}", _ProjectKey).replace("${BUG_SUMMERY}", "Execution Bug: " + testCaseName).replace("${BUG_DESCRIPTION}", description.replaceAll("[^a-zA-Z0-9.?=*$%@#&!<>|\\{\\}\\[\\]\"' /]", "").replaceAll("\"", "'")).replace("${ASSIGNEE_NAME}", SHAFT.Properties.jira.assignee())).post("/rest/api/2/issue", new Object[0])).then()).log().all()).extract().response();
            String id = response.jsonPath().get("key").toString();
            ReportManager.logDiscrete("BugID: " + id);
            XrayIntegrationHelper.attachFilesToIssue(id, files);
            return id;
        }
        catch (Exception e) {
            ReportManagerHelper.logDiscrete(e);
            return null;
        }
    }

    public static void attachFilesToIssue(String issueID, List<String> files) {
        XrayIntegrationHelper.setup();
        try {
            RequestSpecification req = RestAssured.given().relaxedHTTPSValidation().contentType(ContentType.MULTIPART).header("Authorization", (Object)(authType + _JiraAuthorization), new Object[0]).header("X-Atlassian-Token", (Object)"nocheck", new Object[0]);
            for (String file : files) {
                req.multiPart("file", new File(file));
            }
            ReportManager.logDiscrete("BugID: " + issueID);
            ((ValidatableResponse)((ValidatableResponse)((Response)req.when().post("/rest/api/2/issue/" + issueID + "/attachments", new Object[0])).then()).log().all()).extract().response();
        }
        catch (Exception e) {
            ReportManagerHelper.logDiscrete(e);
        }
    }

    public static void link2Tickets(String ticketID, String linkedToID) {
        XrayIntegrationHelper.setup();
        try {
            String linkJIRATicketRequestBody = "{\n   \"update\":{\n     \"issuelinks\":[\n       {\n         \"add\":{\n           \"type\":{\n             \"name\":\"Relates\"\n           },\n           \"outwardIssue\":{\n             \"key\":\"${TICKET_ID}\"\n           }\n         }\n       }\n     ]\n   }\n }\n";
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().config(RestAssured.config().encoderConfig(EncoderConfig.encoderConfig().encodeContentTypeAs("application/json", ContentType.JSON))).relaxedHTTPSValidation().contentType("application/json").header("Authorization", (Object)(authType + _JiraAuthorization), new Object[0]).when().body(linkJIRATicketRequestBody.replace("${TICKET_ID}", linkedToID)).put("/rest/api/2/issue/" + ticketID, new Object[0])).then()).log().all()).extract().response();
        }
        catch (Exception e) {
            ReportManagerHelper.logDiscrete(e);
        }
    }
}

