/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.tools.io;

import com.shaft.driver.DriverFactory;
import com.shaft.driver.SHAFT;
import com.shaft.tools.internal.support.JavaHelper;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.FailureReporter;
import com.shaft.tools.io.internal.ReportManagerHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.poi.EmptyFileException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelFileManager {
    private FileInputStream fis;
    private XSSFWorkbook workbook;
    private XSSFSheet sheet;
    private XSSFRow row;
    private XSSFCell cell;
    private String excelFilePath;
    private String testDataColumnNamePrefix;

    public ExcelFileManager(String excelFilePath) {
        DriverFactory.reloadProperties();
        excelFilePath = JavaHelper.appendTestDataToRelativePath(excelFilePath);
        this.initializeVariables();
        this.excelFilePath = excelFilePath;
        try {
            this.fis = new FileInputStream(excelFilePath);
            this.workbook = new XSSFWorkbook((InputStream)this.fis);
            this.fis.close();
            ReportManager.logDiscrete("Reading test data from the following file [" + excelFilePath + "].");
        }
        catch (IOException | OutOfMemoryError e) {
            FailureReporter.fail(this.getClass(), "Couldn't find the desired file. [" + excelFilePath + "].", e);
        }
        catch (EmptyFileException e) {
            FailureReporter.fail(this.getClass(), "Please check the target file, as it may be corrupted. [" + excelFilePath + "].", e);
        }
        ArrayList<List<Object>> attachments = new ArrayList<List<Object>>();
        List<Object> testDataFileAttachment = null;
        try {
            testDataFileAttachment = Arrays.asList("Test Data", "Excel", new FileInputStream(excelFilePath));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        attachments.add(testDataFileAttachment);
        ReportManagerHelper.log("Loaded Test Data: \"" + excelFilePath + "\".", attachments);
    }

    public String getCellData(String rowName) {
        return this.getCellData(this.getDefaultSheetName(), rowName, "");
    }

    public String getCellData(String rowName, String columnName) {
        return this.getCellData(this.getDefaultSheetName(), rowName, columnName);
    }

    public String getCellData(String sheetName, String rowName, String columnName) {
        try {
            int rowNum = this.getRowNumberFromRowName(sheetName, rowName);
            int colNum = this.getColumnNumberFromColumnName(sheetName, columnName);
            this.row = this.sheet.getRow(rowNum);
            this.cell = this.row.getCell(colNum);
            return this.getCellData();
        }
        catch (Exception e) {
            FailureReporter.fail(this.getClass(), "Failed to read data from row [" + rowName + "] and column [" + columnName + "] in the Test Data Sheet [" + sheetName + "], under the following path [" + this.excelFilePath + "].", e);
            return "";
        }
    }

    public int getLastColumnNumber() {
        return this.getLastColumnNumber(this.getDefaultSheetName());
    }

    public int getLastColumnNumber(String sheetName) {
        this.sheet = this.workbook.getSheet(sheetName);
        this.row = this.sheet.getRow(0);
        int lastColumnNumber = 0;
        try {
            while (true) {
                this.cell = this.row.getCell(lastColumnNumber);
                if (this.cell.getCellType() != CellType.STRING) break;
                ++lastColumnNumber;
            }
            return lastColumnNumber - 1;
        }
        catch (NullPointerException e) {
            return lastColumnNumber - 1;
        }
    }

    public String getColumnNameUsingRowNameAndCellData(String sheetName, String rowName, String cellData) {
        for (int i = 1; i <= this.getLastColumnNumber(sheetName); ++i) {
            String columnName = this.testDataColumnNamePrefix + i;
            if (!cellData.equals(this.getCellData(rowName, columnName))) continue;
            return columnName;
        }
        FailureReporter.fail("Failed to get column name using row [" + rowName + "] and cell data [" + cellData + "] in the Test Data Sheet [" + sheetName + "], under the following path [" + this.excelFilePath + "].");
        return "";
    }

    public String getColumnNameUsingRowNameAndCellData(String rowName, String cellData) {
        return this.getColumnNameUsingRowNameAndCellData(this.getDefaultSheetName(), rowName, cellData);
    }

    private void initializeVariables() {
        this.fis = null;
        this.workbook = null;
        this.sheet = null;
        this.row = null;
        this.cell = null;
        this.excelFilePath = "";
        this.testDataColumnNamePrefix = SHAFT.Properties.pattern.testDataColumnNamePrefix();
    }

    private int getRowNumberFromRowName(String sheetName, String rowName) {
        try {
            this.sheet = this.workbook.getSheet(sheetName);
            for (int i = 0; i <= this.sheet.getLastRowNum(); ++i) {
                this.row = this.sheet.getRow(i);
                if (this.row == null || !this.row.getCell(0).getStringCellValue().equals(rowName)) continue;
                return i;
            }
            FailureReporter.fail("Failed to get the row number that corresponds to rowName [" + rowName + "] in the Test Data Sheet [" + sheetName + "], under the following path [" + this.excelFilePath + "].");
            return -1;
        }
        catch (Exception e) {
            FailureReporter.fail(this.getClass(), "Failed to get the row number that corresponds to rowName [" + rowName + "] in the Test Data Sheet [" + sheetName + "], under the following path [" + this.excelFilePath + "].", e);
            return -1;
        }
    }

    private int getColumnNumberFromColumnName(String sheetName, String columnName) {
        try {
            if (!columnName.isEmpty()) {
                this.row = this.sheet.getRow(0);
                for (int i = 0; i < this.row.getLastCellNum(); ++i) {
                    if (!this.row.getCell(i).getStringCellValue().equals(columnName)) continue;
                    return i;
                }
            } else {
                return 1;
            }
            FailureReporter.fail("Failed to get the column number that corresponds to columnName [" + columnName + "] in the Test Data Sheet [" + sheetName + "], under the following path [" + this.excelFilePath + "].");
            return -1;
        }
        catch (Exception e) {
            FailureReporter.fail(this.getClass(), "Failed to get the column number that corresponds to columnName [" + columnName + "] in the Test Data Sheet [" + sheetName + "], under the following path [" + this.excelFilePath + "].", e);
            return -1;
        }
    }

    private String getCellData() {
        try {
            if (this.cell.getCellType() == CellType.STRING) {
                return this.cell.getStringCellValue();
            }
            if (this.cell.getCellType() == CellType.NUMERIC || this.cell.getCellType() == CellType.FORMULA) {
                String cellValue = String.valueOf(this.cell.getNumericCellValue());
                if (cellValue.contains(".0")) {
                    cellValue = cellValue.split("\\.")[0];
                }
                if (DateUtil.isCellDateFormatted((Cell)this.cell)) {
                    SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy");
                    Date date = this.cell.getDateCellValue();
                    cellValue = df.format(date);
                }
                return cellValue;
            }
            if (this.cell.getCellType() == CellType.BOOLEAN) {
                return String.valueOf(this.cell.getBooleanCellValue());
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    private String getDefaultSheetName() {
        return this.workbook.getSheetName(0);
    }
}

