/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.tools.io;

import com.shaft.cli.FileActions;
import com.shaft.driver.DriverFactory;
import com.shaft.tools.internal.support.JavaHelper;
import com.shaft.tools.io.internal.FailureReporter;
import com.shaft.tools.io.internal.ReportManagerHelper;
import io.restassured.path.json.JsonPath;
import io.restassured.path.json.exception.JsonPathException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class JSONFileManager {
    private static final ThreadLocal<FileReader> reader = new ThreadLocal();
    private final String jsonFilePath;

    public JSONFileManager(String jsonFilePath) {
        DriverFactory.reloadProperties();
        this.jsonFilePath = jsonFilePath = JavaHelper.appendTestDataToRelativePath(jsonFilePath);
        this.initializeReader();
        ArrayList<List<Object>> attachments = new ArrayList<List<Object>>();
        List<Object> testDataFileAttachment = null;
        try {
            testDataFileAttachment = Arrays.asList("Test Data", "JSON", new FileInputStream(jsonFilePath));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        attachments.add(testDataFileAttachment);
        ReportManagerHelper.log("Loaded Test Data: \"" + jsonFilePath + "\".", attachments);
    }

    private String cleanJsonPath(String jsonPath) {
        if (jsonPath.startsWith("x.")) {
            return jsonPath.replace("x.", "");
        }
        return jsonPath;
    }

    public String getTestData(String jsonPath) {
        Object testData = this.getTestData(this.cleanJsonPath(jsonPath), DataType.STRING);
        if (testData != null) {
            return String.valueOf(testData);
        }
        return null;
    }

    public Object getTestDataAsJson(String jsonPath) {
        return this.getTestData(this.cleanJsonPath(jsonPath), DataType.JSON);
    }

    public List<?> getTestDataAsList(String jsonPath) {
        Object testData = this.getTestData(this.cleanJsonPath(jsonPath), DataType.LIST);
        if (testData != null) {
            return (List)testData;
        }
        return null;
    }

    public Map<?, ?> getTestDataAsMap(String jsonPath) {
        Object testData = this.getTestData(this.cleanJsonPath(jsonPath), DataType.MAP);
        if (testData != null) {
            return (Map)testData;
        }
        return null;
    }

    private Object getTestData(String jsonPath, DataType dataType) {
        Object testData = null;
        this.initializeReader();
        try {
            switch (dataType.ordinal()) {
                case 0: {
                    testData = JsonPath.from((Reader)reader.get()).getString(jsonPath);
                    break;
                }
                case 1: {
                    testData = JsonPath.from((Reader)reader.get()).getList(jsonPath);
                    break;
                }
                case 2: {
                    testData = JsonPath.from((Reader)reader.get()).getMap(jsonPath);
                    break;
                }
                case 3: {
                    testData = JsonPath.from((Reader)reader.get()).getJsonObject(jsonPath);
                }
            }
        }
        catch (ClassCastException rootCauseException) {
            FailureReporter.fail(this.getClass(), "Incorrect jsonPath. [" + jsonPath + "].", rootCauseException);
        }
        catch (JsonPathException | IllegalArgumentException rootCauseException) {
            FailureReporter.fail(this.getClass(), "Couldn't read the desired file. [" + this.jsonFilePath + "].", rootCauseException);
        }
        return testData;
    }

    private void initializeReader() {
        try {
            reader.set(new FileReader(FileActions.getInstance(true).getAbsolutePath(this.jsonFilePath), StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException rootCauseException) {
            FailureReporter.fail(this.getClass(), "Couldn't read the desired file. [" + this.jsonFilePath + "].", rootCauseException);
        }
        catch (IOException formatException) {
            FailureReporter.fail(this.getClass(), "file didn't match the specified format. [" + this.jsonFilePath + "].", formatException);
        }
    }

    public static enum DataType {
        STRING,
        LIST,
        MAP,
        JSON;

    }
}

