/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.tools.io;

import com.shaft.cli.FileActions;
import com.shaft.tools.internal.support.JavaHelper;
import com.shaft.tools.io.internal.FailureReporter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

public class PdfFileManager {
    private final File file;
    private RandomAccessReadBufferedFile stream = null;
    private PDFParser parser = null;
    private COSDocument cosDoc = null;
    private PDFTextStripper strip = null;

    public PdfFileManager(String folderName, String fileName, int numberOfRetries) {
        boolean doesFileExist = FileActions.getInstance(true).doesFileExist(folderName, fileName, numberOfRetries);
        this.file = new File(FileActions.getInstance(true).getAbsolutePath(folderName, fileName));
        if (!doesFileExist) {
            FailureReporter.fail("Couldn't find the provided file [" + String.valueOf(this.file) + "]. It might need to wait more to download or the path isn't correct");
        }
    }

    public PdfFileManager(String pdfFilePath) {
        pdfFilePath = JavaHelper.appendTestDataToRelativePath(pdfFilePath);
        boolean doesFileExist = FileActions.getInstance(true).doesFileExist(pdfFilePath);
        this.file = new File(FileActions.getInstance(true).getAbsolutePath(pdfFilePath));
        if (!doesFileExist) {
            FailureReporter.fail("Couldn't find the provided file [" + String.valueOf(this.file) + "]. It might need to wait more to download or the path isn't correct");
        }
    }

    public static String readFileContent(String relativeFilePath, boolean ... deleteFileAfterReading) {
        if (FileActions.getInstance(true).doesFileExist(relativeFilePath)) {
            String string;
            block11: {
                PDDocument pdfParser = new PDFParser((RandomAccessRead)new RandomAccessReadBufferedFile(new File(FileActions.getInstance(true).getAbsolutePath(relativeFilePath)))).parse();
                try {
                    PDFTextStripper pdfTextStripper = new PDFTextStripper();
                    pdfTextStripper.setSortByPosition(true);
                    String fileContent = pdfTextStripper.getText(new PDDocument(pdfParser.getDocument()));
                    if (deleteFileAfterReading != null && deleteFileAfterReading.length > 0 && deleteFileAfterReading[0]) {
                        FileActions.getInstance(true).deleteFile(relativeFilePath);
                    }
                    string = fileContent;
                    if (pdfParser == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (pdfParser != null) {
                            try {
                                pdfParser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException rootCauseException) {
                        FailureReporter.fail(PdfFileManager.class, "Failed to read this PDF file [" + relativeFilePath + "].", rootCauseException);
                    }
                }
                pdfParser.close();
            }
            return string;
        } else {
            FailureReporter.fail("This PDF file [" + relativeFilePath + "] doesn't exist.");
        }
        return "";
    }

    public String readFileContent() {
        return PdfFileManager.readFileContent(this.file.getPath(), new boolean[0]);
    }

    public String readPDFContentFromDownloadedPDF(int startPageNumber, int endPageNumber, DeleteFileAfterValidationStatus deleteFileAfterValidationStatus) {
        this.stream = this.readFileInputStream(this.file);
        this.parser = this.parseStreamDocument(this.stream);
        this.cosDoc = this.getParsedDocument(this.parser);
        String content = this.getPdfText(this.cosDoc, startPageNumber, endPageNumber);
        this.closeStreamAndDeleteFile(this.file, this.stream, deleteFileAfterValidationStatus);
        return content;
    }

    public String readPDFContentFromDownloadedPDF(DeleteFileAfterValidationStatus deleteFileAfterValidationStatus) {
        this.stream = this.readFileInputStream(this.file);
        this.parser = this.parseStreamDocument(this.stream);
        this.cosDoc = this.getParsedDocument(this.parser);
        String content = this.getPdfText(this.cosDoc);
        this.closeStreamAndDeleteFile(this.file, this.stream, deleteFileAfterValidationStatus);
        return content;
    }

    private RandomAccessReadBufferedFile readFileInputStream(File file) {
        try {
            this.stream = new RandomAccessReadBufferedFile(file);
        }
        catch (IOException rootCauseException) {
            FailureReporter.fail(PdfFileManager.class, "Couldn't read the data from the provided file [" + String.valueOf(file) + "].", rootCauseException);
        }
        return this.stream;
    }

    private PDFParser parseStreamDocument(RandomAccessReadBufferedFile stream) {
        try {
            this.parser = new PDFParser((RandomAccessRead)stream);
            this.parser.parse();
        }
        catch (IOException rootCauseException) {
            FailureReporter.fail(PdfFileManager.class, "Couldn't parse the stream that opened the document to be prepared to populate the COSDocument object.", rootCauseException);
        }
        return this.parser;
    }

    private COSDocument getParsedDocument(PDFParser parser) {
        try (PDDocument parsedDocument = parser.parse();){
            this.cosDoc = parsedDocument.getDocument();
        }
        catch (IOException rootCauseException) {
            FailureReporter.fail(PdfFileManager.class, "Couldn't get the document that was parsed. Check that the document parsed before get the document.", rootCauseException);
        }
        return this.cosDoc;
    }

    private String getPdfText(COSDocument cosDoc, int startPageNumber, int endPageNumber) {
        this.strip = new PDFTextStripper();
        this.strip.setSortByPosition(true);
        this.strip.setStartPage(startPageNumber);
        this.strip.setEndPage(endPageNumber);
        PDDocument pdDoc = new PDDocument(cosDoc);
        String content = null;
        try {
            content = this.strip.getText(pdDoc);
        }
        catch (IOException rootCauseException) {
            FailureReporter.fail(PdfFileManager.class, "Couldn't get document text. Document state is invalid or it is encrypted.", rootCauseException);
        }
        return content;
    }

    private String getPdfText(COSDocument cosDoc) {
        this.strip = new PDFTextStripper();
        this.strip.setSortByPosition(true);
        PDDocument pdDoc = new PDDocument(cosDoc);
        String content = null;
        try {
            content = this.strip.getText(pdDoc);
        }
        catch (IOException rootCauseException) {
            FailureReporter.fail(PdfFileManager.class, "Couldn't get document text. Document state is invalid or it is encrypted.", rootCauseException);
        }
        return content;
    }

    private void closeStreamAndDeleteFile(File file, RandomAccessReadBufferedFile stream, DeleteFileAfterValidationStatus deleteFileAfterValidation) {
        try {
            stream.close();
        }
        catch (IOException rootCauseException) {
            FailureReporter.fail(PdfFileManager.class, "Couldn't close the stream, check if it already opened.", rootCauseException);
        }
        if (deleteFileAfterValidation == DeleteFileAfterValidationStatus.TRUE) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException rootCauseException) {
                FailureReporter.fail(PdfFileManager.class, "Couldn't find the file, File directory may be null or file is not found.", rootCauseException);
            }
        }
    }

    public static enum DeleteFileAfterValidationStatus {
        TRUE,
        FALSE;

    }
}

