/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.tools.io;

import com.shaft.driver.DriverFactory;
import com.shaft.tools.internal.support.JavaHelper;
import com.shaft.tools.io.internal.FailureReporter;
import com.shaft.tools.io.internal.ReportManagerHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Yaml;

public class YAMLFileManager {
    public static final String KEY_CONTAINS_LIST_REGEX = "^[-a-zA-Z\\d_!@#$%^&*()+=|\\\\/?><\"'{}~]*(\\[\\d+])+$";
    public static final String NUMBER_IN_SQUARE_BRACKETS_REGEX = "\\[\\d+]";
    public static final String SQUARE_BRACKETS_REGEX = "[\\[\\]]";
    public static final String KEY_SEPARATOR_REGEX = "\\.";
    private final Map<String, Object> data;
    private final String filePath;
    private final Function<String, List<String>> splitKey = key -> Arrays.stream(key.split(KEY_SEPARATOR_REGEX)).toList();
    private final Predicate<String> keyHasList = key -> key.matches(KEY_CONTAINS_LIST_REGEX);

    public YAMLFileManager(String filePath) {
        DriverFactory.reloadProperties();
        this.filePath = JavaHelper.appendTestDataToRelativePath(filePath);
        this.data = this.getData();
        List<Object> testDataFileAttachment = new ArrayList();
        try {
            testDataFileAttachment = List.of("Test Data", "YAML", new FileInputStream(filePath));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        ReportManagerHelper.log("Loaded Test Data: \"" + filePath + "\".", List.of(testDataFileAttachment));
    }

    public Map<String, Object> get() {
        return this.data;
    }

    public Object get(String key) {
        Object value;
        List<String> keys;
        if (key == null || key.isEmpty()) {
            FailureReporter.fail("Key can't be null or empty");
        }
        if ((keys = this.splitKey.apply(key)).size() > 1) {
            value = this.getValueFromKeys(this.data, keys);
        } else if (this.keyHasList.test(key)) {
            value = this.getValueFromKeyList(this.data, key);
        } else if (this.data.containsKey(key)) {
            value = this.data.get(key);
        } else {
            FailureReporter.fail("This key [" + key + "] is not exist");
            throw new RuntimeException();
        }
        return value;
    }

    public String getTestData(String key) {
        Object obj = this.get(key);
        return obj == null ? null : String.valueOf(obj);
    }

    public String getString(String key) {
        return this.parseObjectTo(this.get(key), String.class);
    }

    public Integer getInteger(String key) {
        return this.parseObjectTo(this.get(key), Integer.class);
    }

    public Double getDouble(String key) {
        return this.parseObjectTo(this.get(key), Double.class);
    }

    public Long getLong(String key) {
        String value;
        try {
            value = this.getString(key);
        }
        catch (ClassCastException ignore) {
            FailureReporter.fail("To support Long values please add 'L' at the end of the number");
            throw new RuntimeException();
        }
        if (value.endsWith("L")) {
            try {
                return Long.parseLong(value.replace("L", ""));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        FailureReporter.fail("Can't parse the value of the key [" + key + "] to be long");
        throw new RuntimeException();
    }

    public Boolean getBoolean(String key) {
        return this.parseObjectTo(this.get(key), Boolean.class);
    }

    public Date getDate(String key) {
        return this.parseObjectTo(this.get(key), Date.class);
    }

    public <T> T getAs(String key, Class<T> clazz) {
        return this.parseObjectTo(this.get(key), clazz);
    }

    public <T> List<T> getListAs(String key, Class<T> clazz) {
        return this.parseObjectToList(this.get(key), clazz);
    }

    public <T> Map<String, T> getMapAs(String key, Class<T> clazz) {
        return this.parseObjectToMap(this.get(key), clazz);
    }

    private Object getValueFromKeys(Map<String, Object> map, List<String> keys) {
        Map<String, Object> value = map;
        for (int i = 0; i < keys.size(); ++i) {
            boolean isLastItem;
            boolean bl = isLastItem = i == keys.size() - 1;
            if (this.keyHasList.test(keys.get(i))) {
                value = this.getValueFromKeyList(this.parseObjectToMap(value, Object.class), keys.get(i));
                if (isLastItem) {
                    break;
                }
            } else {
                value = this.parseObjectToMap(value, Object.class).get(keys.get(i));
            }
            if (isLastItem) continue;
            value = this.parseObjectToMap(value, Object.class);
        }
        return value;
    }

    private Object getValueFromKeyList(Map<String, Object> map, String key) {
        List<Integer> indexes = this.parseKeyList(key);
        key = key.replaceAll(NUMBER_IN_SQUARE_BRACKETS_REGEX, "");
        Object value = map.get(key);
        for (int i = 0; i < indexes.size(); ++i) {
            value = this.parseObjectToList(value, Object.class).get((Integer)indexes.stream().findFirst().orElseThrow());
        }
        return value;
    }

    private Map<String, Object> getData() {
        FileInputStream file = this.getFile();
        Map loadedData = (Map)new Yaml().load((InputStream)file);
        this.closeFile(file);
        return loadedData;
    }

    private FileInputStream getFile() {
        FileInputStream in;
        try {
            in = new FileInputStream(this.filePath);
        }
        catch (FileNotFoundException rootCauseException) {
            FailureReporter.fail(this.getClass(), "Couldn't find the desired file. [" + this.filePath + "].", rootCauseException);
            throw new RuntimeException();
        }
        return in;
    }

    private void closeFile(FileInputStream file) {
        try {
            file.close();
        }
        catch (IOException rootCauseException) {
            FailureReporter.fail(this.getClass(), "Couldn't close the following file. [" + this.filePath + "]", rootCauseException);
        }
    }

    private List<Integer> parseKeyList(String key) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        Matcher matcher = Pattern.compile(NUMBER_IN_SQUARE_BRACKETS_REGEX).matcher(key);
        while (matcher.find()) {
            indexes.add(Integer.parseInt(matcher.group().replaceAll(SQUARE_BRACKETS_REGEX, "")));
        }
        return indexes;
    }

    private <T> T parseObjectTo(Object obj, Class<T> clazz) {
        T v;
        try {
            v = clazz.cast(obj);
        }
        catch (ClassCastException rootCauseException) {
            FailureReporter.fail(this.getClass(), "Can't parse the value of [" + String.valueOf(obj) + "] to be of type [" + clazz.getSimpleName() + "]", rootCauseException);
            throw new RuntimeException();
        }
        return v;
    }

    private <T> List<T> parseObjectToList(Object obj, Class<T> clazz) {
        if (obj instanceof List) {
            List list = (List)obj;
            return list.stream().map(item -> this.parseObjectTo(item, clazz)).toList();
        }
        FailureReporter.fail("Can't parse the value of [" + String.valueOf(obj) + "] to be list");
        throw new RuntimeException();
    }

    private <T> Map<String, T> parseObjectToMap(Object obj, Class<T> clazz) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            HashMap nMap = new HashMap();
            map.forEach((k, v) -> nMap.put(k.toString(), this.parseObjectTo(v, clazz)));
            return nMap;
        }
        FailureReporter.fail("Can't parse the value of [" + String.valueOf(obj) + "] to be map");
        throw new RuntimeException();
    }
}

