/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.tools.io.internal;

import com.google.common.base.Throwables;
import com.shaft.gui.element.internal.ElementActionsHelper;
import com.shaft.tools.internal.support.JavaHelper;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.ReportManagerHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;

public class FailureReporter {
    public static void fail(Class<?> failedFileManager, String message, Throwable throwable) {
        String rootCause;
        String actionName = "fail";
        try {
            rootCause = " Root cause: \"" + Throwables.getRootCause((Throwable)throwable).getClass().getName() + ": " + Throwables.getRootCause((Throwable)throwable).getLocalizedMessage().split("\n")[0] + "\"";
        }
        catch (NullPointerException e) {
            rootCause = " Root cause: \"" + Throwables.getRootCause((Throwable)throwable).getClass().getName() + ": ".split("\n")[0] + "\"";
        }
        for (StackTraceElement stackTraceElement : Arrays.stream(Thread.currentThread().getStackTrace()).toList()) {
            String methodName = stackTraceElement.getMethodName();
            if (methodName.toLowerCase().contains("fail")) continue;
            actionName = methodName;
            break;
        }
        actionName = JavaHelper.convertToSentenceCase(actionName);
        ArrayList<List<Object>> attachments = new ArrayList<List<Object>>();
        List<Object> actualValueAttachment = Arrays.asList(JavaHelper.convertToSentenceCase(failedFileManager.getSimpleName()) + " - " + JavaHelper.convertToSentenceCase(actionName), "Exception Stacktrace", ReportManagerHelper.formatStackTraceToLogEntry(throwable));
        attachments.add(actualValueAttachment);
        if (failedFileManager != ElementActionsHelper.class) {
            ReportManagerHelper.log(message + rootCause, attachments);
        }
        Assert.fail((String)(message + rootCause), (Throwable)throwable);
    }

    public static void fail(String message) {
        ReportManager.log(message);
        Assert.fail((String)message);
    }
}

