/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.tools.io.internal;

import com.shaft.tools.io.internal.ReportManagerHelper;
import com.shaft.validation.internal.ValidationsHelper;
import io.qameta.allure.util.AnnotationUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.ConstructorOrMethod;

public class IssueReporter {
    private static final List<List<String>> listOfOpenIssues = new ArrayList<List<String>>();
    private static final List<List<String>> listOfOpenIssuesForFailedTests = new ArrayList<List<String>>();
    private static final List<List<String>> listOfOpenIssuesForPassedTests = new ArrayList<List<String>>();
    private static final List<List<String>> listOfNewIssuesForFailedTests = new ArrayList<List<String>>();
    private static int openIssuesForFailedTestsCounter = 0;
    private static int openIssuesForPassedTestsCounter = 0;
    private static int newIssuesForFailedTestsCounter = 0;

    public static void updateTestStatusInCaseOfVerificationFailure(ITestResult testResult) {
        if (testResult != null && ValidationsHelper.getVerificationErrorToForceFail() != null) {
            testResult.setStatus(2);
            testResult.setThrowable((Throwable)((Object)ValidationsHelper.getVerificationErrorToForceFail()));
            ValidationsHelper.resetVerificationStateAfterFailing();
        }
    }

    public static void updateIssuesLog(ITestResult testResult) {
        if (testResult != null) {
            ITestNGMethod testMethod = testResult.getMethod();
            if (testResult.getStatus() == 1) {
                IssueReporter.reportOpenIssueStatus(testMethod, true);
            } else if (testResult.getStatus() == 2) {
                IssueReporter.reportOpenIssueStatus(testMethod, false);
            }
        }
    }

    private static void reportOpenIssueStatus(ITestNGMethod testMethod, Boolean executionStatus) {
        Optional<Method> method = Optional.ofNullable(testMethod).map(ITestNGMethod::getConstructorOrMethod).map(ConstructorOrMethod::getMethod);
        if (method.isPresent()) {
            Set links = method.map(AnnotationUtils::getLinks).orElse(null);
            int previouslyOpenedIssues = listOfOpenIssues.size();
            if (links != null) {
                links.forEach(link -> {
                    if (link.getType().equals("issue")) {
                        ArrayList<String> newIssue = new ArrayList<String>();
                        newIssue.add(link.getName());
                        newIssue.add(link.getUrl());
                        listOfOpenIssues.add(newIssue);
                    }
                });
            }
            IssueReporter.logIssue(testMethod, previouslyOpenedIssues, executionStatus);
        }
    }

    private static void logIssue(ITestNGMethod testMethod, int previouslyOpenedIssues, Boolean executionStatus) {
        String className = testMethod.getTestClass().getName();
        String methodName = testMethod.getMethodName();
        if (previouslyOpenedIssues < listOfOpenIssues.size()) {
            if (Boolean.TRUE.equals(executionStatus)) {
                ReportManagerHelper.setOpenIssuesForPassedTestsCounter(++openIssuesForPassedTestsCounter);
                IssueReporter.addNewIssue(className, methodName, listOfOpenIssuesForPassedTests);
                ReportManagerHelper.setListOfOpenIssuesForPassedTests(listOfOpenIssuesForPassedTests);
            } else {
                ReportManagerHelper.setOpenIssuesForFailedTestsCounter(++openIssuesForFailedTestsCounter);
                IssueReporter.addNewIssue(className, methodName, listOfOpenIssuesForFailedTests);
                ReportManagerHelper.setListOfOpenIssuesForFailedTests(listOfOpenIssuesForFailedTests);
            }
        } else if (Boolean.FALSE.equals(executionStatus)) {
            ReportManagerHelper.setFailedTestsWithoutOpenIssuesCounter(++newIssuesForFailedTestsCounter);
            ArrayList<String> newIssue = new ArrayList<String>();
            newIssue.add(className);
            newIssue.add(methodName);
            listOfNewIssuesForFailedTests.add(newIssue);
            ReportManagerHelper.setListOfNewIssuesForFailedTests(listOfNewIssuesForFailedTests);
        }
    }

    private static void addNewIssue(String className, String methodName, List<List<String>> listOfOpenIssuesForPassedTests) {
        ArrayList<String> newIssue = new ArrayList<String>();
        newIssue.add(className);
        newIssue.add(methodName);
        newIssue.add(listOfOpenIssues.getLast().get(0));
        newIssue.add(listOfOpenIssues.getLast().get(1));
        listOfOpenIssuesForPassedTests.add(newIssue);
    }
}

