/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.tools.io.internal;

import java.io.OutputStream;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class LogRedirector
extends OutputStream {
    private final Logger logger;
    private final Level level;
    private StringBuilder stringBuilder;

    public LogRedirector(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
        this.stringBuilder = new StringBuilder();
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        Objects.checkFromIndexSize(off, len, b.length);
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    @Override
    public void write(int b) {
        char c = (char)b;
        if (c == '\r' || c == '\n') {
            if (!this.stringBuilder.isEmpty()) {
                this.logger.log(this.level, this.stringBuilder.toString());
                this.stringBuilder = new StringBuilder();
            }
        } else {
            this.stringBuilder.append(c);
        }
    }
}

