/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.tools.io.internal;

import com.shaft.cli.FileActions;
import com.shaft.cli.TerminalActions;
import com.shaft.driver.SHAFT;
import com.shaft.listeners.CucumberFeatureListener;
import com.shaft.properties.internal.PropertyFileManager;
import com.shaft.tools.internal.support.JavaHelper;
import com.shaft.tools.io.ReportManager;
import com.shaft.tools.io.internal.CheckpointCounter;
import com.shaft.tools.io.internal.CheckpointStatus;
import com.shaft.tools.io.internal.CheckpointType;
import com.shaft.tools.io.internal.ExecutionSummaryReport;
import com.shaft.tools.io.internal.LogRedirector;
import io.qameta.allure.Allure;
import io.qameta.allure.Step;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.testng.ITestResult;
import org.testng.Reporter;

public class ReportManagerHelper {
    private static final String TIMESTAMP_FORMAT = "dd-MM-yyyy HH:mm:ss.SSSS aaa";
    private static final String REPORT_MANAGER_PREFIX = "[ReportManager] ";
    private static final String SHAFT_ENGINE_LOGS_ATTACHMENT_TYPE = "SHAFT Engine Logs";
    private static String issuesLog = "";
    private static int issueCounter = 1;
    private static boolean discreteLogging = false;
    private static int totalNumberOfTests = 0;
    private static int testCasesCounter = 0;
    private static boolean debugMode = false;
    private static int openIssuesForFailedTestsCounter = 0;
    private static int openIssuesForPassedTestsCounter = 0;
    private static int failedTestsWithoutOpenIssuesCounter = 0;
    private static List<List<String>> listOfOpenIssuesForFailedTests = new ArrayList<List<String>>();
    private static List<List<String>> listOfOpenIssuesForPassedTests = new ArrayList<List<String>>();
    private static List<List<String>> listOfNewIssuesForFailedTests = new ArrayList<List<String>>();
    private static String featureName = "";
    private static Logger logger;

    private ReportManagerHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static void setOpenIssuesForFailedTestsCounter(int openIssuesForFailedTestsCounter) {
        ReportManagerHelper.openIssuesForFailedTestsCounter = openIssuesForFailedTestsCounter;
    }

    public static void setOpenIssuesForPassedTestsCounter(int openIssuesForPassedTestsCounter) {
        ReportManagerHelper.openIssuesForPassedTestsCounter = openIssuesForPassedTestsCounter;
    }

    public static void setFailedTestsWithoutOpenIssuesCounter(int failedTestsWithoutOpenIssuesCounter) {
        ReportManagerHelper.failedTestsWithoutOpenIssuesCounter = failedTestsWithoutOpenIssuesCounter;
    }

    public static void setListOfOpenIssuesForFailedTests(List<List<String>> listOfOpenIssuesForFailedTests) {
        ReportManagerHelper.listOfOpenIssuesForFailedTests = listOfOpenIssuesForFailedTests;
    }

    public static void setListOfOpenIssuesForPassedTests(List<List<String>> listOfOpenIssuesForPassedTests) {
        ReportManagerHelper.listOfOpenIssuesForPassedTests = listOfOpenIssuesForPassedTests;
    }

    public static void setListOfNewIssuesForFailedTests(List<List<String>> listOfNewIssuesForFailedTests) {
        ReportManagerHelper.listOfNewIssuesForFailedTests = listOfNewIssuesForFailedTests;
    }

    public static int getIssueCounter() {
        return issueCounter - 1;
    }

    public static int getOpenIssuesForFailedTestsCounters() {
        return openIssuesForFailedTestsCounter;
    }

    public static void logIssue(String issue) {
        issuesLog = issuesLog.trim().isEmpty() ? issuesLog + issueCounter + ", " + issue.trim() : issuesLog + System.lineSeparator() + issueCounter + ", " + issue.trim();
        ++issueCounter;
    }

    public static String prepareIssuesLog() {
        if (!listOfNewIssuesForFailedTests.isEmpty()) {
            listOfNewIssuesForFailedTests.forEach(issue -> ReportManagerHelper.logIssue("Test Method '" + (String)issue.getFirst() + "." + (String)issue.get(1) + "' failed. Please investigate and open a new Issue if needed.\n"));
        }
        if (!listOfOpenIssuesForPassedTests.isEmpty()) {
            listOfOpenIssuesForPassedTests.forEach(issue -> {
                if (issue.get(3) != null && !((String)issue.get(3)).trim().isEmpty()) {
                    ReportManagerHelper.logIssue("Test Method '" + (String)issue.get(0) + "." + (String)issue.get(1) + "' passed. Please validate and close this open issue '" + (String)issue.get(2) + "': '" + (String)issue.get(3) + "'.\n");
                } else {
                    ReportManagerHelper.logIssue("Test Method '" + (String)issue.get(0) + "." + (String)issue.get(1) + "' passed. Please validate and close this open issue '" + (String)issue.get(2) + "'.\n");
                }
            });
        }
        if (!listOfOpenIssuesForFailedTests.isEmpty()) {
            listOfOpenIssuesForFailedTests.forEach(issue -> {
                if (issue.get(3) != null && !((String)issue.get(3)).trim().isEmpty()) {
                    ReportManagerHelper.logIssue("Test Method '" + (String)issue.get(0) + "." + (String)issue.get(1) + "' failed with open issue '" + (String)issue.get(2) + "': '" + (String)issue.get(3) + "'.\n");
                } else {
                    ReportManagerHelper.logIssue("Test Method '" + (String)issue.get(0) + "." + (String)issue.get(1) + "' failed with open issue '" + (String)issue.get(2) + "'.\n");
                }
            });
        }
        if (!issuesLog.trim().isEmpty()) {
            return "Issue Summary: Total Issues = " + (issueCounter - 1) + ", New issues for Failed Tests = " + failedTestsWithoutOpenIssuesCounter + ", Open issues for Passed Tests = " + openIssuesForPassedTestsCounter + ", Open issues for Failed Tests = " + openIssuesForFailedTestsCounter + ". Kindly check the attached Issue details.";
        }
        return "";
    }

    public static boolean getDiscreteLogging() {
        return discreteLogging;
    }

    public static void setDiscreteLogging(boolean discreteLogging) {
        if (debugMode) {
            ReportManager.logDiscrete("Setting discrete logging to: '" + discreteLogging + "'");
        }
        ReportManagerHelper.discreteLogging = discreteLogging;
    }

    public static void setTotalNumberOfTests(int totalNumberOfTests) {
        ReportManagerHelper.totalNumberOfTests = totalNumberOfTests;
    }

    public static void setDebugMode(Boolean debugMode) {
        ReportManagerHelper.debugMode = debugMode;
    }

    private static void initializeLogger() {
        FileActions.getInstance(true).deleteFile(System.getProperty("appender.file.fileName"));
        Configurator.initialize(null, (String)(PropertyFileManager.getCUSTOM_PROPERTIES_FOLDER_PATH() + "/log4j2.properties"));
        logger = LogManager.getLogger((String)ReportManager.class.getName());
    }

    public static void logEngineVersion() {
        if (logger == null) {
            ReportManagerHelper.initializeLogger();
        }
        System.setOut(new PrintStream(new LogRedirector(logger, Level.INFO)));
        System.setErr(new PrintStream(new LogRedirector(logger, Level.WARN)));
        String engineVersion = "Powered by \u001b[1mSHAFT v." + SHAFT.Properties.internal.shaftEngineVersion() + "\u001b[22m";
        ReportManagerHelper.createImportantReportEntry(engineVersion);
    }

    public static void logEngineClosure() {
        String copyrights = "This test run was powered by \u001b[1mSHAFT v." + SHAFT.Properties.internal.shaftEngineVersion() + "\u001b[22m\nSHAFT \u001b[1;4mis and will always be 100% FREE\u001b[22;24m for commercial and private use\nin compliance with the \u001b[1mMIT license\u001b[22m\nVisit SHAFT's user guide \u001b[4mhttps://shafthq.github.io/\u001b[24m to learn more";
        ReportManagerHelper.createImportantReportEntry(copyrights);
    }

    public static void logTestInformation(String className, String testMethodName, String testDescription) {
        ++testCasesCounter;
        StringBuilder reportMessage = new StringBuilder();
        if (totalNumberOfTests > 0) {
            reportMessage.append("Starting Execution: ");
            reportMessage.append("'");
            reportMessage.append(testCasesCounter);
            reportMessage.append(" out of ");
            reportMessage.append(totalNumberOfTests);
            reportMessage.append("' test cases in the current suite");
        } else {
            reportMessage.append("Starting Dynamic Test Suite Execution: ");
        }
        reportMessage.append("\nTest Method: '").append(className).append(".").append(testMethodName).append("'");
        if (!testDescription.isEmpty()) {
            reportMessage.append("\nTest Description: '").append(testDescription).append("'");
        }
        ReportManagerHelper.createImportantReportEntry(reportMessage.toString());
    }

    public static void logScenarioInformation(String keyword, String name, String steps) {
        ReportManagerHelper.createImportantReportEntry("Starting Execution: \"" + ++testCasesCounter + " out of " + totalNumberOfTests + "\" scenarios in the \"" + featureName + "\" feature" + System.lineSeparator() + keyword + " Name: \"" + name + "\"" + System.lineSeparator() + keyword + " Steps:" + System.lineSeparator() + steps);
    }

    public static void logConfigurationMethodInformation(String className, String testMethodName, String configurationMethodType) {
        ReportManagerHelper.createImportantReportEntry("Starting execution of " + JavaHelper.convertToSentenceCase(configurationMethodType).toLowerCase() + " configuration method\n'" + className + "." + testMethodName + "'");
    }

    public static void logExecutionSummary(String total, String passed, String failed, String skipped) {
        String copyrights = "Test Execution Summary Results\nTotal Cases: " + total + " --> Passed: " + passed + " | Failed: " + failed + " | Skipped: " + skipped;
        ReportManagerHelper.createImportantReportEntry(copyrights);
    }

    public static void logFinishedTestInformation(String className, String testMethodName, String testDescription, String testStatus) {
        StringBuilder reportMessage = new StringBuilder();
        reportMessage.append("\nFinished Execution of Test Method: '").append(className).append(".").append(testMethodName).append("'");
        if (!testDescription.isEmpty()) {
            reportMessage.append("\nTest Description: '").append(testDescription).append("'");
        }
        reportMessage.append("\nTest Status: '").append(testStatus).append("'");
        ReportManagerHelper.createImportantReportEntry(reportMessage.toString());
    }

    public static String formatStackTraceToLogEntry(Throwable t) {
        return ReportManagerHelper.formatStackTraceToLogEntry(t, false);
    }

    public static void attach(String attachmentType, String attachmentName, InputStream attachmentContent) {
        ReportManagerHelper.createAttachment(attachmentType, attachmentName, attachmentContent);
    }

    public static void attach(String attachmentType, String attachmentName, String attachmentContent) {
        if (!attachmentContent.trim().isEmpty()) {
            ReportManagerHelper.createAttachment(attachmentType, attachmentName, new ByteArrayInputStream(attachmentContent.getBytes()));
        }
    }

    public static void attachTestLog(String currentMethodName, String testLog) {
        if (!testLog.isBlank()) {
            ReportManagerHelper.createAttachment(SHAFT_ENGINE_LOGS_ATTACHMENT_TYPE, "Current Method log: " + currentMethodName, new ByteArrayInputStream(testLog.getBytes()));
        }
    }

    public static void attachEngineLog(String executionEndTimestamp) {
        if (!SHAFT.Properties.reporting.disableLogging()) {
            String engineLogCreated = "Successfully created attachment 'SHAFT Engine Logs - Execution log'";
            boolean initialLoggingState = ReportManagerHelper.getDiscreteLogging();
            ReportManagerHelper.setDiscreteLogging(true);
            ReportManagerHelper.createLogEntry(engineLogCreated, true);
            byte[] engineLog = new byte[]{};
            try {
                engineLog = FileActions.getInstance(true).readFileAsByteArray(System.getProperty("appender.file.fileName"));
                FileActions.getInstance(true).deleteFile(System.getProperty("appender.file.fileName"));
            }
            catch (Exception throwable) {
                ReportManagerHelper.logDiscrete(throwable);
            }
            ReportManagerHelper.setDiscreteLogging(initialLoggingState);
            ReportManagerHelper.createAttachment(SHAFT_ENGINE_LOGS_ATTACHMENT_TYPE, "Execution log: " + executionEndTimestamp, new ByteArrayInputStream(engineLog));
        }
    }

    public static void attachIssuesLog(String executionEndTimestamp) {
        String issueSummary = ReportManagerHelper.prepareIssuesLog();
        if (!issuesLog.trim().isEmpty()) {
            ReportManagerHelper.log(issueSummary, Collections.singletonList(Arrays.asList(SHAFT_ENGINE_LOGS_ATTACHMENT_TYPE, "Issues log CSV: " + executionEndTimestamp, new ByteArrayInputStream(issuesLog.trim().getBytes()))));
        }
    }

    public static String getCallingMethodFullName() {
        StackTraceElement[] callingStack = Thread.currentThread().getStackTrace();
        StringBuilder callingMethodFullName = new StringBuilder();
        for (int i = 1; i < callingStack.length; ++i) {
            if (callingStack[i].getClassName().contains("shaft")) continue;
            callingMethodFullName.append(callingStack[i].getClassName());
            if (callingStack[i].getMethodName().isEmpty()) break;
            callingMethodFullName.append(".");
            callingMethodFullName.append(callingStack[i].getMethodName());
            break;
        }
        return callingMethodFullName.toString();
    }

    public static String getTestClassName() {
        ITestResult result = Reporter.getCurrentTestResult();
        return result != null ? result.getMethod().getTestClass().getName() : "";
    }

    public static String getTestMethodName() {
        if (Reporter.getCurrentTestResult() != null) {
            return Reporter.getCurrentTestResult().getMethod().getMethodName();
        }
        return JavaHelper.removeSpecialCharacters(CucumberFeatureListener.getLastStartedScenarioName());
    }

    public static void setTestCaseName(String scenarioName) {
        Allure.getLifecycle().updateTestCase(testResult -> testResult.setName(scenarioName));
        if (!"".equals(featureName)) {
            Allure.getLifecycle().updateTestCase(testResult -> testResult.setFullName(featureName + ": " + scenarioName));
        }
    }

    public static void setTestCaseDescription(String scenarioSteps) {
        if (scenarioSteps.contains("\u0648")) {
            Allure.getLifecycle().updateTestCase(testResult -> testResult.setDescriptionHtml("<p dir='rtl'>" + scenarioSteps + "</p>"));
        } else {
            Allure.getLifecycle().updateTestCase(testResult -> testResult.setDescriptionHtml("<p dir='ltr'>" + scenarioSteps + "</p>"));
        }
    }

    public static Boolean isCurrentTestPassed() {
        if (Reporter.getCurrentTestResult() != null) {
            return Reporter.getCurrentTestResult().isSuccess();
        }
        return CucumberFeatureListener.getIsLastFinishedStepOK();
    }

    public static void setFeatureName(String featureName) {
        ReportManagerHelper.featureName = featureName;
    }

    private static String formatStackTraceToLogEntry(Throwable t, boolean isCause) {
        StringBuilder logBuilder = new StringBuilder();
        if (t != null) {
            StackTraceElement[] trace = t.getStackTrace();
            if (isCause) {
                logBuilder.append(System.lineSeparator()).append("Caused by: ");
            }
            logBuilder.append(t.getClass().getName()).append(":").append(" ").append(t.getMessage()).append(System.lineSeparator());
            for (StackTraceElement stackTraceElement : trace) {
                logBuilder.append(" ").append(stackTraceElement.toString()).append(System.lineSeparator());
            }
            logBuilder.append(ReportManagerHelper.formatStackTraceToLogEntry(t.getCause(), true));
        }
        return logBuilder.toString();
    }

    public static void createLogEntry(String logText, Level loglevel) {
        if (SHAFT.Properties.reporting != null && !SHAFT.Properties.reporting.disableLogging()) {
            String timestamp = new SimpleDateFormat(TIMESTAMP_FORMAT).format(new Date(System.currentTimeMillis()));
            if (logText == null) {
                logText = "null";
            }
            String log = REPORT_MANAGER_PREFIX + logText.trim() + " @" + timestamp;
            Reporter.log((String)log, (boolean)false);
            if (logger == null) {
                ReportManagerHelper.initializeLogger();
            }
            logger.log(loglevel, logText.trim());
        }
    }

    private static void createLogEntry(String logText, boolean addToConsoleLog) {
        if (!SHAFT.Properties.reporting.disableLogging()) {
            String timestamp = new SimpleDateFormat(TIMESTAMP_FORMAT).format(new Date(System.currentTimeMillis()));
            if (logText == null) {
                logText = "null";
            }
            String log = REPORT_MANAGER_PREFIX + logText.trim() + " @" + timestamp;
            Reporter.log((String)log, (boolean)false);
            if (addToConsoleLog) {
                if (logger == null) {
                    ReportManagerHelper.initializeLogger();
                }
                logger.log(Level.INFO, logText.trim());
            }
        }
    }

    private static String addSpacing(String log) {
        StringBuilder augmentedText = new StringBuilder();
        StringBuilder lineByLine = new StringBuilder();
        augmentedText.append(System.lineSeparator());
        Arrays.stream(log.split("\n")).toList().forEach(line -> {
            String trailingSpacing = "";
            int spaces = Math.round((float)(144 - line.trim().length()) / 2.0f);
            if (spaces > 0) {
                lineByLine.append(" ".repeat(spaces));
                trailingSpacing = lineByLine.toString();
            }
            lineByLine.append(line.trim());
            lineByLine.append(trailingSpacing);
            augmentedText.append((CharSequence)lineByLine);
            augmentedText.append(System.lineSeparator());
            lineByLine.delete(0, lineByLine.length());
        });
        return augmentedText.toString();
    }

    private static String createSeparator(char ch) {
        return String.valueOf(ch).repeat(144);
    }

    private static void createImportantReportEntry(String logText) {
        boolean initialLoggingStatus = discreteLogging;
        ReportManagerHelper.setDiscreteLogging(false);
        String log = System.lineSeparator() + "\u001b[0;7m" + ReportManagerHelper.createSeparator('-') + ReportManagerHelper.addSpacing(logText.trim()) + ReportManagerHelper.createSeparator('-') + System.lineSeparator() + "\u001b[0m";
        Reporter.log((String)log, (boolean)false);
        if (logger == null) {
            ReportManagerHelper.initializeLogger();
        }
        logger.log(Level.INFO, log);
        ReportManagerHelper.setDiscreteLogging(initialLoggingStatus);
    }

    public static void writeStepToReport(String logText) {
        if (!SHAFT.Properties.reporting.disableLogging()) {
            ReportManagerHelper.createLogEntry(logText, true);
            Allure.step((String)logText, (Status)ReportManagerHelper.getStepStatus(logText));
        }
    }

    private static Status getStepStatus(String logText) {
        if (logText != null && logText.toLowerCase().contains("failed")) {
            return Status.FAILED;
        }
        if (Reporter.getCurrentTestResult() != null) {
            int testNgStatus = Reporter.getCurrentTestResult().getStatus();
            return switch (testNgStatus) {
                case 2 -> Status.FAILED;
                case 3 -> Status.SKIPPED;
                default -> Status.PASSED;
            };
        }
        return Status.PASSED;
    }

    @Step(value="{logText}")
    static void writeStepToReport(String logText, List<List<Object>> attachments, CheckpointStatus status) {
        ReportManagerHelper.createLogEntry(logText, false);
        if (attachments != null && !attachments.isEmpty()) {
            attachments.forEach(attachment -> {
                if (attachment != null && !attachment.isEmpty() && attachment.get(2).getClass().toString().toLowerCase().contains("string") && !attachment.get(2).getClass().toString().contains("StringInputStream")) {
                    if (!attachment.get(2).toString().isEmpty()) {
                        ReportManagerHelper.attach(attachment.get(0).toString(), attachment.get(1).toString(), attachment.get(2).toString());
                    }
                } else if (attachment != null && !attachment.isEmpty()) {
                    if (attachment.get(2) instanceof byte[]) {
                        ReportManagerHelper.attach(attachment.get(0).toString(), attachment.get(1).toString(), new ByteArrayInputStream((byte[])attachment.get(2)));
                    } else {
                        ReportManagerHelper.attach(attachment.get(0).toString(), attachment.get(1).toString(), (InputStream)attachment.get(2));
                    }
                }
                if (status.equals((Object)CheckpointStatus.FAIL)) {
                    Allure.getLifecycle().updateStep(update -> {
                        update.setStatus(Status.FAILED);
                        if (attachment != null && !attachment.isEmpty() && attachment.get(2) != null) {
                            String trace = update.getStatusDetails() == null ? attachment.get(2).toString() : update.getStatusDetails().getTrace() + System.lineSeparator() + attachment.get(2).toString();
                            StatusDetails details = update.getStatusDetails() == null ? new StatusDetails() : update.getStatusDetails();
                            details.setTrace(trace.trim());
                            update.setStatusDetails(details);
                        }
                    });
                }
            });
        }
    }

    private static void createAttachment(String attachmentType, String attachmentName, InputStream attachmentContent) {
        if (attachmentContent != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                attachmentContent.transferTo(byteArrayOutputStream);
            }
            catch (IOException e) {
                String error = "Error while creating Attachment";
                if (logger == null) {
                    ReportManagerHelper.initializeLogger();
                }
                logger.info(error, (Throwable)e);
                Reporter.log((String)error, (boolean)false);
            }
            String attachmentDescription = attachmentType + " - " + attachmentName;
            ReportManagerHelper.attachBasedOnFileType(attachmentType, attachmentName, byteArrayOutputStream, attachmentDescription);
            ReportManagerHelper.logAttachmentAction(attachmentType, attachmentName, byteArrayOutputStream);
        }
    }

    private static void attachBasedOnFileType(String attachmentType, String attachmentName, ByteArrayOutputStream attachmentContent, String attachmentDescription) {
        ByteArrayInputStream content = new ByteArrayInputStream(attachmentContent.toByteArray());
        if (attachmentType.toLowerCase().contains("screenshot")) {
            Allure.addAttachment((String)attachmentDescription, (String)"image/png", (InputStream)content, (String)".png");
        } else if (attachmentType.toLowerCase().contains("recording")) {
            Allure.addAttachment((String)attachmentDescription, (String)"video/mp4", (InputStream)content, (String)".mp4");
        } else if (attachmentType.toLowerCase().contains("gif")) {
            Allure.addAttachment((String)attachmentDescription, (String)"image/gif", (InputStream)content, (String)".gif");
        } else if (attachmentType.toLowerCase().contains("csv") || attachmentName.toLowerCase().contains("csv")) {
            Allure.addAttachment((String)attachmentDescription, (String)"text/csv", (InputStream)content, (String)".csv");
        } else if (attachmentType.toLowerCase().contains("xml") || attachmentName.toLowerCase().contains("xml")) {
            Allure.addAttachment((String)attachmentDescription, (String)"text/xml", (InputStream)content, (String)".xml");
        } else if (attachmentType.toLowerCase().contains("excel") || attachmentName.toLowerCase().contains("excel")) {
            Allure.addAttachment((String)attachmentDescription, (String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (InputStream)content, (String)".xlsx");
        } else if (attachmentType.toLowerCase().contains("json") || attachmentName.toLowerCase().contains("json")) {
            Allure.addAttachment((String)attachmentDescription, (String)"text/json", (InputStream)content, (String)".json");
        } else if (attachmentType.toLowerCase().contains("properties")) {
            Allure.addAttachment((String)attachmentDescription, (String)"text/plain", (InputStream)content, (String)".properties");
        } else if (attachmentType.toLowerCase().contains("link")) {
            Allure.addAttachment((String)attachmentDescription, (String)"text/uri-list", (InputStream)content, (String)".uri");
        } else if (attachmentType.toLowerCase().contains("engine logs")) {
            Allure.addAttachment((String)attachmentDescription, (String)"text/plain", (InputStream)content, (String)".txt");
        } else if (attachmentType.toLowerCase().contains("page snapshot")) {
            Allure.addAttachment((String)attachmentDescription, (String)"multipart/related", (InputStream)content, (String)".mhtml");
        } else if (attachmentType.toLowerCase().contains("html")) {
            Allure.addAttachment((String)attachmentDescription, (String)"text/html", (InputStream)content, (String)".html");
        } else {
            Allure.addAttachment((String)attachmentDescription, (InputStream)content);
        }
    }

    private static void logAttachmentAction(String attachmentType, String attachmentName, ByteArrayOutputStream attachmentContent) {
        ReportManagerHelper.createLogEntry("Successfully created attachment '" + attachmentType + " - " + attachmentName + "'", Level.INFO);
        if (!(!debugMode || attachmentType.contains(SHAFT_ENGINE_LOGS_ATTACHMENT_TYPE) || attachmentType.equalsIgnoreCase("Selenium WebDriver Logs") || attachmentType.toLowerCase().contains("screenshot") || attachmentType.toLowerCase().contains("recording") || attachmentType.toLowerCase().contains("gif") || attachmentType.toLowerCase().contains("engine logs"))) {
            String timestamp = new SimpleDateFormat(TIMESTAMP_FORMAT).format(new Date(System.currentTimeMillis()));
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(attachmentContent.toByteArray()), StandardCharsets.UTF_8));
            String theString = br.lines().collect(Collectors.joining(System.lineSeparator()));
            if (!theString.isEmpty()) {
                String logEntry = "[ReportManager] Debugging Attachment Entry @" + timestamp + System.lineSeparator() + theString + System.lineSeparator();
                if (logger == null) {
                    ReportManagerHelper.initializeLogger();
                }
                logger.info(logEntry);
            }
        }
    }

    public static boolean isInternalStep() {
        String callingMethodName = new Throwable().getStackTrace()[2].toString();
        return callingMethodName.contains("shaft");
    }

    @Step(value="Attachment: {attachmentType} - {attachmentName}")
    public static void attachAsStep(String attachmentType, String attachmentName, InputStream attachmentContent) {
        ReportManagerHelper.createAttachment(attachmentType, attachmentName, attachmentContent);
    }

    public static void cleanExecutionSummaryReportDirectory() {
        if (SHAFT.Properties.reporting.cleanSummaryReportsDirectoryBeforeExecution()) {
            ReportManager.logDiscrete("Initializing Summary Reporting Environment...");
            String executionSummaryReportFolderPath = SHAFT.Properties.paths.executionSummaryReport();
            FileActions.getInstance(true).deleteFolder(executionSummaryReportFolderPath.substring(0, executionSummaryReportFolderPath.length() - 1));
        }
    }

    public static void openExecutionSummaryReportAfterExecution() {
        if (SHAFT.Properties.reporting.openExecutionSummaryReportAfterExecution()) {
            if (SystemUtils.IS_OS_WINDOWS) {
                TerminalActions.getInstance(false, false, true).performTerminalCommand(".\\" + SHAFT.Properties.paths.executionSummaryReport() + "ExecutionSummaryReport_*.html");
            } else {
                TerminalActions.getInstance(false, false, true).performTerminalCommand("open ./" + SHAFT.Properties.paths.executionSummaryReport() + "ExecutionSummaryReport_*.html");
            }
        }
    }

    public static void log(String logText, List<List<Object>> attachments) {
        if (!SHAFT.Properties.reporting.disableLogging()) {
            if (!logText.toLowerCase().contains("failed") && ReportManagerHelper.getDiscreteLogging() && ReportManagerHelper.isInternalStep()) {
                ReportManagerHelper.createLogEntry(logText, Level.INFO);
                if (attachments != null && !attachments.isEmpty() && (attachments.size() > 1 || attachments.getFirst() != null && !attachments.getFirst().isEmpty())) {
                    attachments.forEach(attachment -> {
                        if (attachment != null && !attachment.isEmpty()) {
                            if (attachment.get(2) instanceof String) {
                                ReportManagerHelper.attachAsStep(attachment.get(0).toString(), attachment.get(1).toString(), new ByteArrayInputStream(attachment.get(2).toString().getBytes()));
                            } else {
                                ReportManagerHelper.attachAsStep(attachment.get(0).toString(), attachment.get(1).toString(), (InputStream)attachment.get(2));
                            }
                        }
                    });
                }
            } else if (attachments != null && !attachments.isEmpty() && (attachments.size() > 1 || attachments.getFirst() != null && !attachments.getFirst().isEmpty())) {
                CheckpointStatus status = !logText.toLowerCase().contains("fail") ? CheckpointStatus.PASS : CheckpointStatus.FAIL;
                ReportManagerHelper.writeStepToReport(logText, attachments, status);
            } else {
                ReportManagerHelper.writeStepToReport(logText);
            }
        }
    }

    public static void logNestedSteps(String logText, List<String> customLogMessages, List<List<Object>> attachments) {
        CheckpointType type;
        CheckpointStatus status = logText.toLowerCase().contains("passed") ? CheckpointStatus.PASS : CheckpointStatus.FAIL;
        CheckpointType checkpointType = type = logText.toLowerCase().contains("verification") ? CheckpointType.VERIFICATION : CheckpointType.ASSERTION;
        if (type.equals((Object)CheckpointType.VERIFICATION) && status.equals((Object)CheckpointStatus.FAIL) || !SHAFT.Properties.reporting.disableLogging()) {
            if (customLogMessages != null && !customLogMessages.isEmpty() && !customLogMessages.getFirst().trim().isEmpty()) {
                Object customLogText = customLogMessages.getFirst();
                customLogText = status == CheckpointStatus.PASS ? (type == CheckpointType.VERIFICATION ? "Verification Passed: " + (String)customLogText : "Assertion Passed: " + (String)customLogText) : (type == CheckpointType.VERIFICATION ? "Verification Failed: " + (String)customLogText : "Assertion Failed: " + (String)customLogText);
                ReportManager.logDiscrete(logText);
                if (attachments != null && !attachments.isEmpty()) {
                    ReportManagerHelper.writeNestedStepsToReport((String)customLogText, attachments);
                } else {
                    ReportManagerHelper.writeNestedStepsToReport((String)customLogText);
                }
                CheckpointCounter.increment(type, customLogMessages.getFirst(), status);
                ExecutionSummaryReport.validationsIncrement(status);
            } else {
                if (attachments != null && !attachments.isEmpty() && !attachments.getFirst().isEmpty()) {
                    ReportManagerHelper.writeStepToReport(logText, attachments, status);
                } else {
                    ReportManagerHelper.writeStepToReport(logText);
                }
                CheckpointCounter.increment(type, logText, status);
                ExecutionSummaryReport.validationsIncrement(status);
            }
        }
    }

    public static void logNestedSteps(String logText, List<List<Object>> attachments) {
        ReportManagerHelper.writeNestedStepsToReport(logText, attachments);
    }

    public static void attach(List<List<Object>> attachments) {
        if (attachments != null && !attachments.isEmpty()) {
            attachments.forEach(attachment -> {
                if (attachment != null && !attachment.isEmpty() && attachment.get(2).getClass().toString().toLowerCase().contains("string") && !attachment.get(2).getClass().toString().contains("StringInputStream")) {
                    if (!attachment.get(2).toString().isEmpty()) {
                        ReportManagerHelper.attach(attachment.get(0).toString(), attachment.get(1).toString(), attachment.get(2).toString());
                    }
                } else if (attachment != null && !attachment.isEmpty()) {
                    if (attachment.get(2) instanceof byte[]) {
                        ReportManagerHelper.attach(attachment.get(0).toString(), attachment.get(1).toString(), new ByteArrayInputStream((byte[])attachment.get(2)));
                    } else {
                        ReportManagerHelper.attach(attachment.get(0).toString(), attachment.get(1).toString(), (InputStream)attachment.get(2));
                    }
                }
            });
        }
    }

    @Step(value="{customLog}")
    private static void writeNestedStepsToReport(String customLog, List<List<Object>> attachments) {
        ReportManagerHelper.createLogEntry(customLog, false);
        ReportManagerHelper.attach(attachments);
    }

    @Step(value="{customLog}")
    private static void writeNestedStepsToReport(String customLog) {
        ReportManagerHelper.createLogEntry(customLog, false);
    }

    public static void log(Throwable throwable) {
        String logText = ReportManagerHelper.formatStackTraceToLogEntry(throwable);
        if (throwable.getMessage() != null) {
            ReportManagerHelper.log("An Exception Occurred with this Message: " + throwable.getMessage().split("\n")[0].trim() + ".", Collections.singletonList(Arrays.asList("Exception Stack Trace", throwable.getClass().getName(), logText)));
        } else {
            ReportManagerHelper.log("An Exception Occurred", Collections.singletonList(Arrays.asList("Exception Stack Trace", throwable.getClass().getName(), logText)));
        }
    }

    public static void logDiscrete(Throwable t) {
        ReportManagerHelper.createLogEntry(ReportManagerHelper.formatStackTraceToLogEntry(t), Level.ERROR);
    }

    public static void logDiscrete(Throwable t, Level logLevel) {
        ReportManagerHelper.createLogEntry(ReportManagerHelper.formatStackTraceToLogEntry(t), logLevel);
    }

    public static void logDiscrete(String logText, Level logLevel) {
        ReportManagerHelper.createLogEntry(logText, logLevel);
    }

    public static String getExecutionDuration(long startTime, long endTime) {
        long durationWithMillis = TimeUnit.MILLISECONDS.toMillis(endTime - startTime);
        Object duration = "";
        if (durationWithMillis > 0L && durationWithMillis < 1000L) {
            duration = durationWithMillis + " millis";
        } else if (durationWithMillis >= 1000L && durationWithMillis < 60000L) {
            duration = String.format("%02d sec, %02d millis", TimeUnit.MILLISECONDS.toSeconds(durationWithMillis), TimeUnit.MILLISECONDS.toMillis(durationWithMillis) - TimeUnit.SECONDS.toMillis(TimeUnit.MILLISECONDS.toSeconds(durationWithMillis)));
        } else if (durationWithMillis >= 60000L && durationWithMillis < 3600000L) {
            duration = String.format("%02d min, %02d sec", TimeUnit.MILLISECONDS.toMinutes(durationWithMillis), TimeUnit.MILLISECONDS.toSeconds(durationWithMillis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(durationWithMillis)));
        } else if (durationWithMillis >= 3600000L) {
            duration = String.format("%02d hr, %02d min", TimeUnit.MILLISECONDS.toHours(durationWithMillis), TimeUnit.MILLISECONDS.toMinutes(durationWithMillis) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(durationWithMillis)));
        }
        return duration;
    }

    public static int getTotalNumberOfTests() {
        return totalNumberOfTests;
    }

    public static int getOpenIssuesForPassedTestsCounter() {
        return openIssuesForPassedTestsCounter;
    }

    public static int getFailedTestsWithoutOpenIssuesCounter() {
        return failedTestsWithoutOpenIssuesCounter;
    }
}

