/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.validation.internal;

import com.shaft.api.RestActions;
import com.shaft.cli.FileActions;
import com.shaft.tools.internal.support.JavaHelper;
import com.shaft.validation.ValidationEnums;
import com.shaft.validation.internal.JSONValidationsBuilder;
import com.shaft.validation.internal.NativeValidationsBuilder;
import com.shaft.validation.internal.NumberValidationsBuilder;
import com.shaft.validation.internal.ValidationsExecutor;

public class RestValidationsBuilder {
    protected final ValidationEnums.ValidationCategory validationCategory;
    protected final Object response;
    protected final StringBuilder reportMessageBuilder;
    protected String validationMethod;
    protected ValidationEnums.ValidationType validationType;
    protected String fileAbsolutePath;
    protected RestActions.ComparisonType restComparisonType;
    protected String jsonPath;

    public RestValidationsBuilder(ValidationEnums.ValidationCategory validationCategory, Object response, StringBuilder reportMessageBuilder) {
        this.validationCategory = validationCategory;
        this.response = response;
        this.reportMessageBuilder = reportMessageBuilder;
    }

    public ValidationsExecutor isEqualToFileContent(String fileRelativePath) {
        fileRelativePath = JavaHelper.appendTestDataToRelativePath(fileRelativePath);
        this.validationMethod = "responseEqualsFileContent";
        this.fileAbsolutePath = FileActions.getInstance(true).getAbsolutePath(fileRelativePath);
        this.restComparisonType = RestActions.ComparisonType.EQUALS;
        this.validationType = ValidationEnums.ValidationType.POSITIVE;
        this.reportMessageBuilder.append("is equal to the contents of this file \"").append(fileRelativePath).append("\".");
        ValidationsExecutor executor = new ValidationsExecutor(this);
        executor.internalPerform();
        return executor;
    }

    public ValidationsExecutor isEqualToFileContentIgnoringOrder(String fileRelativePath) {
        fileRelativePath = JavaHelper.appendTestDataToRelativePath(fileRelativePath);
        this.validationMethod = "responseEqualsFileContent";
        this.fileAbsolutePath = FileActions.getInstance(true).getAbsolutePath(fileRelativePath);
        this.restComparisonType = RestActions.ComparisonType.EQUALS_IGNORING_ORDER;
        this.validationType = ValidationEnums.ValidationType.POSITIVE;
        this.reportMessageBuilder.append("is equal to the contents of this file \"").append(fileRelativePath).append("\" (Ignoring Ordering).");
        ValidationsExecutor executor = new ValidationsExecutor(this);
        executor.internalPerform();
        return executor;
    }

    public ValidationsExecutor doesNotEqualFileContent(String fileRelativePath) {
        fileRelativePath = JavaHelper.appendTestDataToRelativePath(fileRelativePath);
        this.validationMethod = "responseEqualsFileContent";
        this.fileAbsolutePath = FileActions.getInstance(true).getAbsolutePath(fileRelativePath);
        this.restComparisonType = RestActions.ComparisonType.EQUALS;
        this.validationType = ValidationEnums.ValidationType.NEGATIVE;
        this.reportMessageBuilder.append("is not equal to the contents of this file \"").append(fileRelativePath).append("\".");
        ValidationsExecutor executor = new ValidationsExecutor(this);
        executor.internalPerform();
        return executor;
    }

    public ValidationsExecutor doesNotEqualFileContentIgnoringOrder(String fileRelativePath) {
        fileRelativePath = JavaHelper.appendTestDataToRelativePath(fileRelativePath);
        this.validationMethod = "responseEqualsFileContent";
        this.fileAbsolutePath = FileActions.getInstance(true).getAbsolutePath(fileRelativePath);
        this.restComparisonType = RestActions.ComparisonType.EQUALS_IGNORING_ORDER;
        this.validationType = ValidationEnums.ValidationType.NEGATIVE;
        this.reportMessageBuilder.append("is not equal to the contents of this file \"").append(fileRelativePath).append("\" (Ignoring Ordering).");
        ValidationsExecutor executor = new ValidationsExecutor(this);
        executor.internalPerform();
        return executor;
    }

    public ValidationsExecutor containsFileContent(String fileRelativePath) {
        fileRelativePath = JavaHelper.appendTestDataToRelativePath(fileRelativePath);
        this.validationMethod = "responseEqualsFileContent";
        this.fileAbsolutePath = FileActions.getInstance(true).getAbsolutePath(fileRelativePath);
        this.restComparisonType = RestActions.ComparisonType.CONTAINS;
        this.validationType = ValidationEnums.ValidationType.POSITIVE;
        this.reportMessageBuilder.append("contains the contents of this file \"").append(fileRelativePath).append("\".");
        ValidationsExecutor executor = new ValidationsExecutor(this);
        executor.internalPerform();
        return executor;
    }

    public ValidationsExecutor doesNotContainFileContent(String fileRelativePath) {
        fileRelativePath = JavaHelper.appendTestDataToRelativePath(fileRelativePath);
        this.validationMethod = "responseEqualsFileContent";
        this.fileAbsolutePath = FileActions.getInstance(true).getAbsolutePath(fileRelativePath);
        this.restComparisonType = RestActions.ComparisonType.CONTAINS;
        this.validationType = ValidationEnums.ValidationType.NEGATIVE;
        this.reportMessageBuilder.append("does not contain the contents of this file \"").append(fileRelativePath).append("\".");
        ValidationsExecutor executor = new ValidationsExecutor(this);
        executor.internalPerform();
        return executor;
    }

    public NativeValidationsBuilder extractedJsonValue(String jsonPath) {
        this.validationMethod = "jsonPathValueEquals";
        this.jsonPath = jsonPath;
        this.reportMessageBuilder.append("extracted value from the JSON path \"").append(jsonPath).append("\" ");
        return new NativeValidationsBuilder(this);
    }

    public NativeValidationsBuilder extractedJsonValueAsList(String jsonPath) {
        this.validationMethod = "jsonPathValueAsListEquals";
        this.jsonPath = jsonPath;
        this.reportMessageBuilder.append("extracted value from the JSON path \"").append(jsonPath).append("\" ");
        return new NativeValidationsBuilder(this);
    }

    public NativeValidationsBuilder body() {
        this.validationMethod = "responseBody";
        this.reportMessageBuilder.append("Body ");
        return new JSONValidationsBuilder(this);
    }

    public NumberValidationsBuilder time() {
        this.validationMethod = "responseTime";
        this.reportMessageBuilder.append("Time ");
        return new NumberValidationsBuilder(this);
    }

    public ValidationsExecutor matchesSchema(String fileRelativePath) {
        fileRelativePath = JavaHelper.appendTestDataToRelativePath(fileRelativePath);
        this.validationMethod = "checkResponseSchema";
        this.fileAbsolutePath = FileActions.getInstance(true).getAbsolutePath(fileRelativePath);
        this.restComparisonType = RestActions.ComparisonType.EQUALS;
        this.validationType = ValidationEnums.ValidationType.POSITIVE;
        this.reportMessageBuilder.append("schema matches that in this file \"").append(fileRelativePath).append("\".");
        ValidationsExecutor executor = new ValidationsExecutor(this);
        executor.internalPerform();
        return executor;
    }

    public ValidationsExecutor doesNotMatchSchema(String fileRelativePath) {
        fileRelativePath = JavaHelper.appendTestDataToRelativePath(fileRelativePath);
        this.validationMethod = "checkResponseSchema";
        this.fileAbsolutePath = FileActions.getInstance(true).getAbsolutePath(fileRelativePath);
        this.restComparisonType = RestActions.ComparisonType.EQUALS;
        this.validationType = ValidationEnums.ValidationType.NEGATIVE;
        this.reportMessageBuilder.append("schema does not match that in this file \"").append(fileRelativePath).append("\".");
        ValidationsExecutor executor = new ValidationsExecutor(this);
        executor.internalPerform();
        return executor;
    }
}

