/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.validation.internal;

import com.shaft.gui.element.internal.ElementActionsHelper;
import com.shaft.validation.ValidationEnums;
import com.shaft.validation.internal.FileValidationsBuilder;
import com.shaft.validation.internal.NativeValidationsBuilder;
import com.shaft.validation.internal.NumberValidationsBuilder;
import com.shaft.validation.internal.RestValidationsBuilder;
import com.shaft.validation.internal.ValidationsExecutor;
import com.shaft.validation.internal.WebDriverBrowserValidationsBuilder;
import com.shaft.validation.internal.WebDriverElementValidationsBuilder;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class ValidationsBuilder {
    protected final ValidationEnums.ValidationCategory validationCategory;
    protected final StringBuilder reportMessageBuilder = new StringBuilder();
    protected String validationMethod;
    protected ValidationEnums.ValidationType validationType;
    protected boolean condition;
    protected Object actualValue;

    public ValidationsBuilder(ValidationEnums.ValidationCategory validationCategory) {
        this.validationCategory = validationCategory;
    }

    public NativeValidationsBuilder object(Object actualValue) {
        this.validationMethod = "objectsAreEqual";
        this.actualValue = actualValue;
        this.reportMessageBuilder.append("\"").append(actualValue).append("\" ");
        return new NativeValidationsBuilder(this);
    }

    public NumberValidationsBuilder number(Number actualValue) {
        this.validationMethod = "comparativeRelationBetweenNumbers";
        this.actualValue = actualValue;
        this.reportMessageBuilder.append("\"").append(actualValue).append("\" ");
        return new NumberValidationsBuilder(this);
    }

    public WebDriverElementValidationsBuilder element(WebDriver driver, By locator) {
        this.reportMessageBuilder.append("the element located by \"").append(ElementActionsHelper.formatLocatorToString(locator)).append("\" ");
        return new WebDriverElementValidationsBuilder(this.validationCategory, driver, locator, this.reportMessageBuilder);
    }

    public WebDriverBrowserValidationsBuilder browser(WebDriver driver) {
        this.reportMessageBuilder.append("the Browser ");
        return new WebDriverBrowserValidationsBuilder(this.validationCategory, driver, this.reportMessageBuilder);
    }

    public RestValidationsBuilder response(Object response) {
        this.reportMessageBuilder.append("the API response ");
        return new RestValidationsBuilder(this.validationCategory, response, this.reportMessageBuilder);
    }

    public FileValidationsBuilder file(String folderRelativePath, String fileName) {
        this.reportMessageBuilder.append("the File \"").append(folderRelativePath).append(fileName).append("\" ");
        return new FileValidationsBuilder(this.validationCategory, folderRelativePath, fileName, this.reportMessageBuilder);
    }

    public ValidationsExecutor forceFail() {
        this.reportMessageBuilder.append("Force fail.");
        this.validationMethod = "forceFail";
        ValidationsExecutor executor = new ValidationsExecutor(this);
        executor.internalPerform();
        return executor;
    }
}

