/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.validation.internal;

import com.shaft.api.RestActions;
import com.shaft.cli.FileActions;
import com.shaft.cli.TerminalActions;
import com.shaft.gui.browser.internal.JavaScriptWaitManager;
import com.shaft.tools.internal.support.JavaHelper;
import com.shaft.tools.io.PdfFileManager;
import com.shaft.tools.io.ReportManager;
import com.shaft.validation.ValidationEnums;
import com.shaft.validation.internal.FileValidationsBuilder;
import com.shaft.validation.internal.NativeValidationsBuilder;
import com.shaft.validation.internal.NumberValidationsBuilder;
import com.shaft.validation.internal.RestValidationsBuilder;
import com.shaft.validation.internal.ValidationsBuilder;
import com.shaft.validation.internal.ValidationsHelper;
import com.shaft.validation.internal.ValidationsHelper2;
import com.shaft.validation.internal.WebDriverElementValidationsBuilder;
import io.restassured.response.Response;
import java.util.Objects;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class ValidationsExecutor {
    protected final StringBuilder reportMessageBuilder;
    private final ValidationEnums.ValidationCategory validationCategory;
    private final ValidationEnums.ValidationType validationType;
    private final String validationMethod;
    private String validationCategoryString;
    private String validationMethodString;
    private WebDriver driver;
    private By locator;
    private String customReportMessage = "";
    private ValidationEnums.VisualValidationEngine visualValidationEngine;
    private String elementAttribute;
    private String elementCssProperty;
    private String browserAttribute;
    private ValidationEnums.ValidationComparisonType validationComparisonType;
    private Object expectedValue;
    private boolean condition;
    private Object actualValue;
    private ValidationEnums.NumbersComparativeRelation numbersComparativeRelation;
    private Object response;
    private String fileAbsolutePath;
    private RestActions.ComparisonType restComparisonType;
    private String jsonPath;
    private String folderRelativePath;
    private String fileName;

    public ValidationsExecutor(WebDriverElementValidationsBuilder webDriverElementValidationsBuilder) {
        this.validationCategory = webDriverElementValidationsBuilder.validationCategory;
        this.driver = webDriverElementValidationsBuilder.driver;
        this.locator = webDriverElementValidationsBuilder.locator;
        this.validationType = webDriverElementValidationsBuilder.validationType;
        this.validationMethod = webDriverElementValidationsBuilder.validationMethod;
        this.visualValidationEngine = webDriverElementValidationsBuilder.visualValidationEngine;
        this.reportMessageBuilder = webDriverElementValidationsBuilder.reportMessageBuilder;
    }

    public ValidationsExecutor(NativeValidationsBuilder nativeValidationsBuilder) {
        this.validationCategory = nativeValidationsBuilder.validationCategory;
        this.driver = nativeValidationsBuilder.driver;
        this.locator = nativeValidationsBuilder.locator;
        this.validationType = nativeValidationsBuilder.validationType;
        this.validationMethod = nativeValidationsBuilder.validationMethod;
        this.elementAttribute = nativeValidationsBuilder.elementAttribute;
        this.validationComparisonType = nativeValidationsBuilder.validationComparisonType;
        this.expectedValue = nativeValidationsBuilder.expectedValue;
        this.actualValue = nativeValidationsBuilder.actualValue;
        this.elementCssProperty = nativeValidationsBuilder.elementCssProperty;
        this.browserAttribute = nativeValidationsBuilder.browserAttribute;
        this.response = nativeValidationsBuilder.response;
        this.jsonPath = nativeValidationsBuilder.jsonPath;
        this.folderRelativePath = nativeValidationsBuilder.folderRelativePath;
        this.fileName = nativeValidationsBuilder.fileName;
        this.reportMessageBuilder = nativeValidationsBuilder.reportMessageBuilder;
    }

    public ValidationsExecutor(ValidationsBuilder validationsBuilder) {
        this.validationCategory = validationsBuilder.validationCategory;
        this.validationType = validationsBuilder.validationType;
        this.validationMethod = validationsBuilder.validationMethod;
        this.condition = validationsBuilder.condition;
        this.actualValue = validationsBuilder.actualValue;
        this.reportMessageBuilder = validationsBuilder.reportMessageBuilder;
    }

    public ValidationsExecutor(NumberValidationsBuilder numberValidationsBuilder) {
        this.validationCategory = numberValidationsBuilder.validationCategory;
        this.validationType = numberValidationsBuilder.validationType;
        this.validationMethod = numberValidationsBuilder.validationMethod;
        this.expectedValue = numberValidationsBuilder.expectedValue;
        this.actualValue = numberValidationsBuilder.actualValue;
        this.numbersComparativeRelation = numberValidationsBuilder.numbersComparativeRelation;
        this.response = numberValidationsBuilder.response;
        this.jsonPath = numberValidationsBuilder.jsonPath;
        this.reportMessageBuilder = numberValidationsBuilder.reportMessageBuilder;
    }

    public ValidationsExecutor(RestValidationsBuilder restValidationsBuilder) {
        this.validationCategory = restValidationsBuilder.validationCategory;
        this.validationMethod = restValidationsBuilder.validationMethod;
        this.validationType = restValidationsBuilder.validationType;
        this.response = restValidationsBuilder.response;
        this.fileAbsolutePath = restValidationsBuilder.fileAbsolutePath;
        this.restComparisonType = restValidationsBuilder.restComparisonType;
        this.reportMessageBuilder = restValidationsBuilder.reportMessageBuilder;
    }

    public ValidationsExecutor(FileValidationsBuilder fileValidationsBuilder) {
        this.validationCategory = fileValidationsBuilder.validationCategory;
        this.validationMethod = fileValidationsBuilder.validationMethod;
        this.validationType = fileValidationsBuilder.validationType;
        this.folderRelativePath = fileValidationsBuilder.folderRelativePath;
        this.fileName = fileValidationsBuilder.fileName;
        this.reportMessageBuilder = fileValidationsBuilder.reportMessageBuilder;
    }

    public ValidationsExecutor withCustomReportMessage(String customReportMessage) {
        this.customReportMessage = customReportMessage;
        return this;
    }

    public void perform() {
        ReportManager.log(this.customReportMessage);
    }

    protected void internalPerform() {
        JavaScriptWaitManager.waitForLazyLoading(this.driver);
        if (this.customReportMessage.isBlank()) {
            this.customReportMessage = this.reportMessageBuilder.toString();
        }
        this.validationMethodString = JavaHelper.convertToSentenceCase(this.validationMethod).toLowerCase();
        this.validationCategoryString = this.validationCategory.equals((Object)ValidationEnums.ValidationCategory.HARD_ASSERT) ? "Assert" : "Verify";
        this.performValidation();
    }

    private void performValidation() {
        switch (this.validationMethod) {
            case "forceFail": {
                new ValidationsHelper(this.validationCategory).validateFail(this.validationCategory, this.customReportMessage);
                break;
            }
            case "objectsAreEqual": {
                new ValidationsHelper(this.validationCategory).validateEquals(this.validationCategory, this.expectedValue, this.actualValue, this.validationComparisonType, this.validationType, this.customReportMessage);
                break;
            }
            case "objectIsNull": {
                new ValidationsHelper(this.validationCategory).validateNull(this.validationCategory, this.actualValue, this.validationType, this.customReportMessage);
                break;
            }
            case "conditionIsTrue": {
                new ValidationsHelper(this.validationCategory).validateTrue(this.validationCategory, this.condition, this.validationType, this.customReportMessage);
                break;
            }
            case "elementExists": {
                new ValidationsHelper(this.validationCategory).validateElementExists(this.validationCategory, this.driver, this.locator, this.validationType, this.customReportMessage);
                break;
            }
            case "elementMatches": {
                new ValidationsHelper(this.validationCategory).validateElementMatches(this.validationCategory, this.driver, this.locator, this.visualValidationEngine, this.validationType, this.customReportMessage);
                break;
            }
            case "elementAttributeEquals": {
                new ValidationsHelper2(this.validationCategory).validateElementAttribute(this.driver, this.locator, this.elementAttribute, String.valueOf(this.expectedValue), this.validationComparisonType, this.validationType, this.customReportMessage);
                break;
            }
            case "elementCssPropertyEquals": {
                new ValidationsHelper(this.validationCategory).validateElementCSSProperty(this.driver, this.validationCategory, this.locator, this.elementCssProperty, String.valueOf(this.expectedValue), this.validationComparisonType, this.validationType, this.customReportMessage);
                break;
            }
            case "browserAttributeEquals": {
                new ValidationsHelper(this.validationCategory).validateBrowserAttribute(this.validationCategory, this.driver, this.browserAttribute, String.valueOf(this.expectedValue), this.validationComparisonType, this.validationType, this.customReportMessage);
                break;
            }
            case "comparativeRelationBetweenNumbers": {
                new ValidationsHelper(this.validationCategory).validateComparativeRelation(this.validationCategory, (Number)this.expectedValue, (Number)this.actualValue, this.numbersComparativeRelation, this.validationType, this.customReportMessage);
                break;
            }
            case "fileExists": {
                new ValidationsHelper(this.validationCategory).validateFileExists(this.validationCategory, this.folderRelativePath, this.fileName, 5, this.validationType, this.customReportMessage);
                break;
            }
            case "responseEqualsFileContent": {
                new ValidationsHelper(this.validationCategory).validateJSONFileContent(this.validationCategory, (Response)this.response, this.fileAbsolutePath, this.restComparisonType, "", this.validationType, this.customReportMessage);
                break;
            }
            case "jsonPathValueEquals": {
                new ValidationsHelper(this.validationCategory).validateEquals(this.validationCategory, this.expectedValue, RestActions.getResponseJSONValue(this.response, this.jsonPath), this.validationComparisonType, this.validationType, this.customReportMessage);
                break;
            }
            case "jsonPathValueAsListEquals": {
                for (Object value : Objects.requireNonNull(RestActions.getResponseJSONValueAsList((Response)this.response, this.jsonPath))) {
                    new ValidationsHelper(this.validationCategory).validateEquals(this.validationCategory, this.expectedValue, value.toString(), this.validationComparisonType, this.validationType, this.customReportMessage);
                }
                break;
            }
            case "responseBody": {
                new ValidationsHelper(this.validationCategory).validateEquals(this.validationCategory, this.expectedValue, RestActions.getResponseBody((Response)this.response), this.validationComparisonType, this.validationType, this.customReportMessage);
                break;
            }
            case "responseTime": {
                new ValidationsHelper(this.validationCategory).validateComparativeRelation(this.validationCategory, (Number)this.expectedValue, RestActions.getResponseTime((Response)this.response), this.numbersComparativeRelation, this.validationType, this.customReportMessage);
                break;
            }
            case "checkResponseSchema": {
                new ValidationsHelper(this.validationCategory).validateResponseFileSchema(this.validationCategory, (Response)this.response, this.fileAbsolutePath, this.restComparisonType, "", this.validationType, this.customReportMessage);
                break;
            }
            case "fileContent": {
                String fileContent = this.fileName.contains(".pdf") ? PdfFileManager.readFileContent(this.folderRelativePath + this.fileName, new boolean[0]) : FileActions.getInstance(true).readFile(this.folderRelativePath, this.fileName);
                new ValidationsHelper(this.validationCategory).validateEquals(this.validationCategory, this.expectedValue, fileContent, this.validationComparisonType, this.validationType, this.customReportMessage);
                break;
            }
            case "fileChecksum": {
                String fileChecksum = FileActions.getInstance(true).getFileChecksum(new TerminalActions(), this.folderRelativePath, this.fileName, new String[0]);
                new ValidationsHelper(this.validationCategory).validateEquals(this.validationCategory, this.expectedValue, fileChecksum, this.validationComparisonType, this.validationType, this.customReportMessage);
                break;
            }
        }
    }
}

