/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.validation.internal;

import com.shaft.api.RestActions;
import com.shaft.cli.FileActions;
import com.shaft.driver.SHAFT;
import com.shaft.enums.internal.Screenshots;
import com.shaft.gui.browser.BrowserActions;
import com.shaft.gui.browser.internal.BrowserActionsHelper;
import com.shaft.gui.element.ElementActions;
import com.shaft.gui.element.internal.ElementActionsHelper;
import com.shaft.gui.internal.image.ImageProcessingActions;
import com.shaft.gui.internal.image.ScreenshotManager;
import com.shaft.properties.internal.Properties;
import com.shaft.tools.internal.support.JavaHelper;
import com.shaft.tools.io.internal.FailureReporter;
import com.shaft.tools.io.internal.ReportManagerHelper;
import com.shaft.validation.ValidationEnums;
import io.qameta.allure.Step;
import io.restassured.module.jsv.JsonSchemaValidator;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Browser;
import org.testng.Assert;

public class ValidationsHelper {
    static final ThreadLocal<ArrayList<String>> optionalCustomLogMessage = new ThreadLocal();
    private static final Boolean discreetLoggingState = SHAFT.Properties.reporting.alwaysLogDiscreetly();
    private static final String WHEN_TO_TAKE_PAGE_SOURCE_SNAPSHOT = SHAFT.Properties.visuals.whenToTakePageSourceSnapshot().trim();
    private static By lastUsedElementLocator = null;
    protected static List<String> verificationFailuresList = new ArrayList<String>();
    protected static AssertionError verificationError = null;
    private final String validationCategoryString;

    ValidationsHelper(ValidationEnums.ValidationCategory validationCategory) {
        this.validationCategoryString = validationCategory.equals((Object)ValidationEnums.ValidationCategory.HARD_ASSERT) ? "Assert" : "Verify";
    }

    public static AssertionError getVerificationErrorToForceFail() {
        return verificationError;
    }

    public static void resetVerificationStateAfterFailing() {
        verificationFailuresList = new ArrayList<String>();
        verificationError = null;
    }

    @Step(value=" {this.validationCategoryString} that {customReportMessage}")
    protected void validateFail(ValidationEnums.ValidationCategory validationCategory, String customReportMessage) {
        ValidationsHelper.processCustomLogMessage(customReportMessage);
        ValidationsHelper.fail(null, validationCategory, null, null, null, null, null);
    }

    @Step(value=" {this.validationCategoryString} that {customReportMessage}")
    protected void validateEquals(ValidationEnums.ValidationCategory validationCategory, Object expectedValue, Object actualValue, ValidationEnums.ValidationComparisonType validationComparisonType, ValidationEnums.ValidationType validationType, String customReportMessage) {
        ValidationsHelper.processCustomLogMessage(customReportMessage);
        if (JavaHelper.compareTwoObjects(expectedValue, actualValue, validationComparisonType.getValue(), validationType.getValue()) == 1) {
            ValidationsHelper.pass(null, validationCategory, String.valueOf(expectedValue), String.valueOf(actualValue), (Object)validationComparisonType, validationType);
        } else {
            ValidationsHelper.fail(null, validationCategory, String.valueOf(expectedValue), String.valueOf(actualValue), (Object)validationComparisonType, validationType, null);
        }
    }

    @Step(value=" {this.validationCategoryString} that {customReportMessage}")
    protected void validateNull(ValidationEnums.ValidationCategory validationCategory, Object object, ValidationEnums.ValidationType validationType, String customReportMessage) {
        ValidationsHelper.processCustomLogMessage(customReportMessage);
        if (validationType.getValue()) {
            try {
                Assert.assertNull((Object)object);
                ValidationsHelper.pass(null, validationCategory, "NULL", "NULL", (Object)ValidationEnums.ValidationComparisonType.EQUALS, validationType);
            }
            catch (AssertionError | Exception failureReason) {
                ValidationsHelper.fail(null, validationCategory, "NULL", String.valueOf(object), (Object)ValidationEnums.ValidationComparisonType.EQUALS, validationType, (Throwable)failureReason);
            }
        } else {
            try {
                Assert.assertNotNull((Object)object);
                ValidationsHelper.pass(null, validationCategory, "NULL", String.valueOf(object), (Object)ValidationEnums.ValidationComparisonType.EQUALS, validationType);
            }
            catch (AssertionError | Exception failureReason) {
                ValidationsHelper.fail(null, validationCategory, "NULL", "NULL", (Object)ValidationEnums.ValidationComparisonType.EQUALS, validationType, (Throwable)failureReason);
            }
        }
    }

    @Step(value=" {this.validationCategoryString} that {customReportMessage}")
    protected void validateElementExists(ValidationEnums.ValidationCategory validationCategory, WebDriver driver, By elementLocator, ValidationEnums.ValidationType validationType, String customReportMessage) {
        ValidationsHelper.processCustomLogMessage(customReportMessage);
        String[] expectedElementStates = new String[]{"Element Should Exist", "Element Should not Exist"};
        String[] actualElementStates = new String[]{"Element Exists", "Element Doesn't Exists", "Element Exists but is not unique"};
        String locatorSeparator = ", locator '";
        lastUsedElementLocator = elementLocator;
        int elementsCount = ElementActionsHelper.getElementsCount(driver, elementLocator);
        if (validationType.getValue()) {
            String expectedValue = expectedElementStates[0] + locatorSeparator + ElementActionsHelper.formatLocatorToString(elementLocator) + "'";
            switch (elementsCount) {
                case 0: {
                    lastUsedElementLocator = null;
                    ValidationsHelper.fail(driver, validationCategory, expectedValue, actualElementStates[1], (Object)ValidationEnums.ValidationComparisonType.EQUALS, validationType, null);
                    break;
                }
                case 1: {
                    ValidationsHelper.pass(driver, validationCategory, expectedValue, actualElementStates[0], (Object)ValidationEnums.ValidationComparisonType.EQUALS, validationType);
                    break;
                }
                default: {
                    ValidationsHelper.fail(driver, validationCategory, expectedValue, actualElementStates[2], (Object)ValidationEnums.ValidationComparisonType.EQUALS, validationType, null);
                    break;
                }
            }
        } else {
            String expectedValue = expectedElementStates[1] + locatorSeparator + ElementActionsHelper.formatLocatorToString(elementLocator) + "'";
            switch (elementsCount) {
                case 0: {
                    lastUsedElementLocator = null;
                    ValidationsHelper.pass(driver, validationCategory, expectedValue, actualElementStates[1], (Object)ValidationEnums.ValidationComparisonType.EQUALS, validationType);
                    break;
                }
                case 1: {
                    ValidationsHelper.fail(driver, validationCategory, expectedValue, actualElementStates[0], (Object)ValidationEnums.ValidationComparisonType.EQUALS, validationType, null);
                    break;
                }
                default: {
                    ValidationsHelper.fail(driver, validationCategory, expectedValue, actualElementStates[2], (Object)ValidationEnums.ValidationComparisonType.EQUALS, validationType, null);
                }
            }
        }
    }

    @Step(value=" {this.validationCategoryString} that {customReportMessage}")
    protected void validateElementCSSProperty(WebDriver driver, ValidationEnums.ValidationCategory validationCategory, By elementLocator, String propertyName, String expectedValue, ValidationEnums.ValidationComparisonType validationComparisonType, ValidationEnums.ValidationType validationType, String customReportMessage) {
        String actualValue;
        ValidationsHelper.processCustomLogMessage(customReportMessage);
        String[] expectedAttributeStates = new String[]{"Value Should be", "Value Should not be"};
        String propertySeparator = "' for the '";
        String locatorSeparator = "' CSS property, element locator '";
        try {
            actualValue = new ElementActions(driver).getCSSProperty(elementLocator, propertyName);
        }
        catch (Throwable e) {
            if (validationType.getValue()) {
                ValidationsHelper.fail(driver, validationCategory, expectedAttributeStates[0] + " '" + expectedValue + propertySeparator + propertyName + locatorSeparator + ElementActionsHelper.formatLocatorToString(elementLocator) + "'", "Failed to read the desired element CSS property", (Object)validationComparisonType, validationType, e);
            } else {
                ValidationsHelper.fail(driver, validationCategory, expectedAttributeStates[1] + " '" + expectedValue + propertySeparator + propertyName + locatorSeparator + ElementActionsHelper.formatLocatorToString(elementLocator) + "'", "Failed to read the desired element CSS property", (Object)validationComparisonType, validationType, e);
            }
            return;
        }
        lastUsedElementLocator = elementLocator;
        int comparisonResult = JavaHelper.compareTwoObjects(expectedValue, actualValue, validationComparisonType.getValue(), validationType.getValue());
        ValidationsHelper.reportValidationResultOfElementAttribute(driver, new Object[]{expectedAttributeStates, propertySeparator, locatorSeparator, comparisonResult, elementLocator, propertyName, expectedValue, actualValue, validationComparisonType, validationType, validationCategory});
    }

    @Step(value=" {this.validationCategoryString} that {customReportMessage}")
    protected void validateBrowserAttribute(ValidationEnums.ValidationCategory validationCategory, WebDriver driver, String browserAttribute, String expectedValue, ValidationEnums.ValidationComparisonType validationComparisonType, ValidationEnums.ValidationType validationType, String customReportMessage) {
        String actualValue;
        ValidationsHelper.processCustomLogMessage(customReportMessage);
        String[] expectedAttributeStates = new String[]{"Value Should be", "Value Should not be"};
        String attributeSeparator = "' for the '";
        String attributeClosure = "' attribute";
        try {
            actualValue = switch (browserAttribute.toLowerCase()) {
                case "currenturl", "url" -> new BrowserActions(driver).getCurrentURL();
                case "pagesource" -> new BrowserActions(driver).getPageSource();
                case "title" -> new BrowserActions(driver).getCurrentWindowTitle();
                case "windowhandle" -> new BrowserActions(driver).getWindowHandle();
                case "windowposition" -> new BrowserActions(driver).getWindowPosition();
                case "windowsize" -> new BrowserActions(driver).getWindowSize();
                default -> "";
            };
        }
        catch (Throwable e) {
            if (validationType.getValue()) {
                ValidationsHelper.fail(driver, validationCategory, expectedAttributeStates[0] + " '" + expectedValue + attributeSeparator + browserAttribute + attributeClosure, "Failed to read the desired browser attribute", (Object)validationComparisonType, validationType, e);
            } else {
                ValidationsHelper.fail(driver, validationCategory, expectedAttributeStates[1] + " '" + expectedValue + attributeSeparator + browserAttribute + attributeClosure, "Failed to read the desired browser attribute", (Object)validationComparisonType, validationType, e);
            }
            return;
        }
        int comparisonResult = JavaHelper.compareTwoObjects(expectedValue, actualValue, validationComparisonType.getValue(), validationType.getValue());
        ValidationsHelper.reportValidationResultOfBrowserAttribute(driver, new Object[]{expectedAttributeStates, attributeSeparator, attributeClosure, comparisonResult, null, browserAttribute, expectedValue, actualValue, validationComparisonType, validationType, validationCategory});
    }

    @Step(value=" {this.validationCategoryString} that {customReportMessage}")
    protected void validateComparativeRelation(ValidationEnums.ValidationCategory validationCategory, Number expectedValue, Number actualValue, ValidationEnums.NumbersComparativeRelation numbersComparativeRelation, ValidationEnums.ValidationType validationType, String customReportMessage) {
        Boolean comparisonState;
        ValidationsHelper.processCustomLogMessage(customReportMessage);
        switch (numbersComparativeRelation.getValue()) {
            case ">": {
                Boolean bl = actualValue.floatValue() > expectedValue.floatValue();
                break;
            }
            case ">=": {
                Boolean bl = actualValue.floatValue() >= expectedValue.floatValue();
                break;
            }
            case "<": {
                Boolean bl = actualValue.floatValue() < expectedValue.floatValue();
                break;
            }
            case "<=": {
                Boolean bl = actualValue.floatValue() <= expectedValue.floatValue();
                break;
            }
            case "==": {
                Boolean bl = actualValue.floatValue() == expectedValue.floatValue();
                break;
            }
            default: {
                Boolean bl = comparisonState = Boolean.valueOf(false);
            }
        }
        if (ValidationEnums.ValidationType.POSITIVE.equals((Object)validationType) && comparisonState.equals(true) || ValidationEnums.ValidationType.NEGATIVE.equals((Object)validationType) && comparisonState.equals(false)) {
            ValidationsHelper.pass(validationCategory, expectedValue, actualValue, (Object)numbersComparativeRelation, validationType);
        } else {
            ValidationsHelper.fail(validationCategory, expectedValue, actualValue, (Object)numbersComparativeRelation, validationType);
        }
    }

    @Step(value=" {this.validationCategoryString} that {customReportMessage}")
    protected void validateTrue(ValidationEnums.ValidationCategory validationCategory, Boolean conditionalStatement, ValidationEnums.ValidationType validationType, String customReportMessage) {
        ValidationsHelper.processCustomLogMessage(customReportMessage);
        Boolean expectedValue = false;
        if (ValidationEnums.ValidationType.POSITIVE.equals((Object)validationType)) {
            expectedValue = true;
        }
        if (expectedValue.booleanValue() && conditionalStatement.booleanValue() || !expectedValue.booleanValue() && !conditionalStatement.booleanValue()) {
            ValidationsHelper.pass(null, validationCategory, String.valueOf(expectedValue).toUpperCase(), String.valueOf(conditionalStatement).toUpperCase(), null, validationType);
        } else {
            ValidationsHelper.fail(null, validationCategory, String.valueOf(expectedValue).toUpperCase(), String.valueOf(conditionalStatement).toUpperCase(), null, validationType, null);
        }
    }

    @Step(value=" {this.validationCategoryString} that {customReportMessage}")
    protected void validateFileExists(ValidationEnums.ValidationCategory validationCategory, String fileFolderName, String fileName, int numberOfRetries, ValidationEnums.ValidationType validationType, String customReportMessage) {
        ValidationsHelper.processCustomLogMessage(customReportMessage);
        boolean expectedValue = ValidationEnums.ValidationType.POSITIVE.equals((Object)validationType);
        boolean actualValue = FileActions.getInstance(true).doesFileExist(fileFolderName, fileName, numberOfRetries);
        String filePrefix = "File '";
        String[] expectedAttributeStates = new String[]{"' should exist, after up to '", "' should not exist, after up to '"};
        String numberOfRetriesPostfix = "' retries";
        String reportedExpectedValue = filePrefix + fileFolderName + fileName + expectedAttributeStates[0] + numberOfRetries + numberOfRetriesPostfix;
        if (!expectedValue) {
            reportedExpectedValue = filePrefix + fileFolderName + fileName + expectedAttributeStates[1] + numberOfRetries + numberOfRetriesPostfix;
        }
        String reportedActualValue = "File exists";
        if (!actualValue) {
            reportedActualValue = "File does not exist";
        }
        if (expectedValue && actualValue || !expectedValue && !actualValue) {
            ValidationsHelper.pass(null, validationCategory, reportedExpectedValue, reportedActualValue, null, validationType);
        } else {
            ValidationsHelper.fail(null, validationCategory, reportedExpectedValue, reportedActualValue, null, validationType, null);
        }
    }

    @Step(value=" {this.validationCategoryString} that {customReportMessage}")
    protected void validateElementMatches(ValidationEnums.ValidationCategory validationCategory, WebDriver driver, By elementLocator, ValidationEnums.VisualValidationEngine visualValidationEngine, ValidationEnums.ValidationType validationType, String customReportMessage) {
        lastUsedElementLocator = elementLocator;
        if (Properties.web.targetBrowserName().equalsIgnoreCase(Browser.SAFARI.browserName())) {
            visualValidationEngine = ValidationEnums.VisualValidationEngine.EXACT_OPENCV;
        }
        ValidationsHelper.processCustomLogMessage(customReportMessage);
        StringBuilder reportedExpectedResult = new StringBuilder();
        reportedExpectedResult.append("Element should ");
        Boolean expectedResult = validationType.getValue();
        if (!expectedResult.booleanValue()) {
            reportedExpectedResult.append("not ");
        }
        reportedExpectedResult.append("match the reference screenshot");
        ArrayList<List<Object>> attachments = new ArrayList<List<Object>>();
        byte[] referenceImage = ImageProcessingActions.getReferenceImage(elementLocator);
        if (!Arrays.equals(new byte[0], referenceImage)) {
            List<Object> expectedValueAttachment = Arrays.asList("Validation Test Data", "Reference Screenshot", referenceImage);
            attachments.add(expectedValueAttachment);
        }
        if (ElementActionsHelper.getElementsCount(driver, elementLocator) == 1) {
            byte[] shutterbugDifferencesImage;
            byte[] elementScreenshot = ScreenshotManager.takeScreenshot(driver, elementLocator, Screenshots.ELEMENT);
            Boolean actualResult = ImageProcessingActions.compareAgainstBaseline(driver, elementLocator, elementScreenshot, ImageProcessingActions.VisualValidationEngine.valueOf(visualValidationEngine.name()));
            List<Object> actualValueAttachment = Arrays.asList("Validation Test Data", "Actual Screenshot", elementScreenshot);
            attachments.add(actualValueAttachment);
            if (visualValidationEngine.equals((Object)ValidationEnums.VisualValidationEngine.EXACT_SHUTTERBUG) && !actualResult.booleanValue() && !Arrays.equals(new byte[0], shutterbugDifferencesImage = ImageProcessingActions.getShutterbugDifferencesImage(elementLocator))) {
                List<Object> differencesAttachment = Arrays.asList("Validation Test Data", "Differences", shutterbugDifferencesImage);
                attachments.add(differencesAttachment);
            }
            if (expectedResult.equals(actualResult)) {
                ValidationsHelper.pass(driver, validationCategory, reportedExpectedResult.toString(), String.valueOf(actualResult).toUpperCase(), (Object)visualValidationEngine, validationType, attachments);
            } else {
                ValidationsHelper.fail(driver, validationCategory, reportedExpectedResult.toString(), String.valueOf(actualResult).toUpperCase(), (Object)visualValidationEngine, validationType, null, attachments);
            }
        } else {
            byte[] pageScreenshot = ScreenshotManager.takeScreenshot(driver);
            List<Object> actualValueAttachment = Arrays.asList("Validation Test Data", "Actual Screenshot", pageScreenshot);
            attachments.add(actualValueAttachment);
            ValidationsHelper.fail(driver, validationCategory, reportedExpectedResult.toString(), "Element not found".toUpperCase(), (Object)visualValidationEngine, validationType, null, attachments);
        }
    }

    private static void pass(WebDriver driver, ValidationEnums.ValidationCategory validationCategory, String expectedValue, String actualValue, Object validationComparisonType, ValidationEnums.ValidationType validationType, List<List<Object>> externalAttachments) {
        ValidationsHelper.reportValidationState(driver, validationCategory, expectedValue, actualValue, validationComparisonType, validationType, ValidationEnums.ValidationState.PASSED, null, externalAttachments);
    }

    private static void pass(WebDriver driver, ValidationEnums.ValidationCategory validationCategory, String expectedValue, String actualValue, Object validationComparisonType, ValidationEnums.ValidationType validationType) {
        ValidationsHelper.reportValidationState(driver, validationCategory, expectedValue, actualValue, validationComparisonType, validationType, ValidationEnums.ValidationState.PASSED, null, null);
    }

    private static void pass(ValidationEnums.ValidationCategory validationCategory, Number expectedValue, Number actualValue, Object comparativeRelationType, ValidationEnums.ValidationType validationType) {
        ValidationsHelper.reportValidationState(null, validationCategory, String.valueOf(expectedValue), String.valueOf(actualValue), comparativeRelationType, validationType, ValidationEnums.ValidationState.PASSED, null, null);
    }

    private static void fail(WebDriver driver, ValidationEnums.ValidationCategory validationCategory, String expectedValue, String actualValue, Object validationComparisonType, ValidationEnums.ValidationType validationType, Throwable failureReason, List<List<Object>> externalAttachments) {
        ReportManagerHelper.setDiscreteLogging(discreetLoggingState);
        ValidationsHelper.reportValidationState(driver, validationCategory, expectedValue, actualValue, validationComparisonType, validationType, ValidationEnums.ValidationState.FAILED, failureReason, externalAttachments);
    }

    private static void fail(WebDriver driver, ValidationEnums.ValidationCategory validationCategory, String expectedValue, String actualValue, Object validationComparisonType, ValidationEnums.ValidationType validationType, Throwable failureReason) {
        ReportManagerHelper.setDiscreteLogging(discreetLoggingState);
        ValidationsHelper.reportValidationState(driver, validationCategory, expectedValue, actualValue, validationComparisonType, validationType, ValidationEnums.ValidationState.FAILED, failureReason, null);
    }

    private static void fail(ValidationEnums.ValidationCategory validationCategory, Number expectedValue, Number actualValue, Object comparativeRelationType, ValidationEnums.ValidationType validationType) {
        ReportManagerHelper.setDiscreteLogging(discreetLoggingState);
        ValidationsHelper.reportValidationState(null, validationCategory, String.valueOf(expectedValue), String.valueOf(actualValue), comparativeRelationType, validationType, ValidationEnums.ValidationState.FAILED, null, null);
    }

    @Step(value=" {this.validationCategoryString} that {customReportMessage}")
    protected void validateJSONFileContent(ValidationEnums.ValidationCategory validationCategory, Response response, String referenceJsonFilePath, RestActions.ComparisonType comparisonType, String jsonPathToTargetArray, ValidationEnums.ValidationType validationType, String customReportMessage) {
        ValidationsHelper.processCustomLogMessage(customReportMessage);
        boolean expectedValue = ValidationEnums.ValidationType.POSITIVE.equals((Object)validationType);
        StringBuilder reportedExpectedValue = new StringBuilder();
        reportedExpectedValue.append("Response data should ");
        if (!expectedValue) {
            reportedExpectedValue.append("not ");
        }
        reportedExpectedValue.append("match the JSON File in this path '").append(referenceJsonFilePath).append("'");
        if (!jsonPathToTargetArray.isBlank()) {
            reportedExpectedValue.append(", with path to Target Array '").append(jsonPathToTargetArray).append("'");
        }
        Boolean comparisonResult = RestActions.compareJSON(response, referenceJsonFilePath, comparisonType, jsonPathToTargetArray);
        List<Object> expectedValueAttachment = Arrays.asList("Validation Test Data", "Expected JSON Value", RestActions.parseBodyToJson(FileActions.getInstance(true).readFile(referenceJsonFilePath)));
        List<Object> actualValueAttachment = Arrays.asList("Validation Test Data", "Actual JSON Value", RestActions.parseBodyToJson(response));
        ArrayList<List<Object>> attachments = new ArrayList<List<Object>>();
        attachments.add(expectedValueAttachment);
        attachments.add(actualValueAttachment);
        if (comparisonResult.booleanValue() && expectedValue || !comparisonResult.booleanValue() && !expectedValue) {
            ValidationsHelper.pass(null, validationCategory, reportedExpectedValue.toString(), String.valueOf(comparisonResult).toUpperCase(), (Object)comparisonType, validationType, attachments);
        } else {
            ValidationsHelper.fail(null, validationCategory, reportedExpectedValue.toString(), String.valueOf(comparisonResult).toUpperCase(), (Object)comparisonType, validationType, null, attachments);
        }
    }

    @Step(value=" {this.validationCategoryString} that {customReportMessage}")
    protected void validateResponseFileSchema(ValidationEnums.ValidationCategory validationCategory, Response response, String referenceJsonFilePath, RestActions.ComparisonType comparisonType, String jsonPathToTargetArray, ValidationEnums.ValidationType validationType, String customReportMessage) {
        ValidationsHelper.processCustomLogMessage(customReportMessage);
        boolean expectedValue = ValidationEnums.ValidationType.POSITIVE.equals((Object)validationType);
        StringBuilder reportedExpectedValue = new StringBuilder();
        reportedExpectedValue.append("Response data should ");
        if (!expectedValue) {
            reportedExpectedValue.append("not ");
        }
        reportedExpectedValue.append("match the JSON File in this path '").append(referenceJsonFilePath).append("'");
        if (!jsonPathToTargetArray.isBlank()) {
            reportedExpectedValue.append(", with path to Target Array '").append(jsonPathToTargetArray).append("'");
        }
        ValidatableResponse validatableResponse = (ValidatableResponse)((ValidatableResponse)response.then()).body((Matcher)JsonSchemaValidator.matchesJsonSchema((File)new File(referenceJsonFilePath)), new Matcher[0]);
        Response responseAfter = (Response)validatableResponse.extract().response();
        Boolean comparisonResult = response.equals((Object)responseAfter);
        List<Object> expectedValueAttachment = Arrays.asList("Validation Test Data", "Expected JSON Value", RestActions.parseBodyToJson(FileActions.getInstance(true).readFile(referenceJsonFilePath)));
        List<Object> actualValueAttachment = Arrays.asList("Validation Test Data", "Actual JSON Value", RestActions.parseBodyToJson(response));
        ArrayList<List<Object>> attachments = new ArrayList<List<Object>>();
        attachments.add(expectedValueAttachment);
        attachments.add(actualValueAttachment);
        if (comparisonResult.booleanValue() && expectedValue || !comparisonResult.booleanValue() && !expectedValue) {
            ValidationsHelper.pass(null, validationCategory, reportedExpectedValue.toString(), String.valueOf(comparisonResult).toUpperCase(), (Object)comparisonType, validationType, attachments);
        } else {
            ValidationsHelper.fail(null, validationCategory, reportedExpectedValue.toString(), String.valueOf(comparisonResult).toUpperCase(), (Object)comparisonType, validationType, null, attachments);
        }
    }

    private static void reportValidationResultOfElementAttribute(WebDriver driver, Object[] args) {
        String[] expectedAttributeStates = (String[])args[0];
        String propertySeparator = (String)args[1];
        String locatorSeparator = (String)args[2];
        int comparisonResult = (Integer)args[3];
        By elementLocator = args[4] != null ? (By)args[4] : null;
        String propertyName = (String)args[5];
        String expectedValue = (String)args[6];
        String actualValue = (String)args[7];
        ValidationEnums.ValidationComparisonType validationComparisonType = (ValidationEnums.ValidationComparisonType)((Object)args[8]);
        ValidationEnums.ValidationType validationType = (ValidationEnums.ValidationType)((Object)args[9]);
        ValidationEnums.ValidationCategory validationCategory = (ValidationEnums.ValidationCategory)((Object)args[10]);
        if (validationType.getValue()) {
            if (comparisonResult == 1) {
                ValidationsHelper.pass(driver, validationCategory, expectedAttributeStates[0] + " '" + expectedValue + propertySeparator + propertyName + locatorSeparator + ElementActionsHelper.formatLocatorToString(elementLocator) + "'", actualValue, (Object)validationComparisonType, validationType);
            } else {
                ValidationsHelper.fail(driver, validationCategory, expectedAttributeStates[0] + " '" + expectedValue + propertySeparator + propertyName + locatorSeparator + ElementActionsHelper.formatLocatorToString(elementLocator) + "'", actualValue, (Object)validationComparisonType, validationType, null);
            }
        } else if (comparisonResult == 1) {
            ValidationsHelper.pass(driver, validationCategory, expectedAttributeStates[1] + " '" + expectedValue + propertySeparator + propertyName + locatorSeparator + ElementActionsHelper.formatLocatorToString(elementLocator) + "'", actualValue, (Object)validationComparisonType, validationType);
        } else {
            ValidationsHelper.fail(driver, validationCategory, expectedAttributeStates[1] + " '" + expectedValue + propertySeparator + propertyName + locatorSeparator + ElementActionsHelper.formatLocatorToString(elementLocator) + "'", actualValue, (Object)validationComparisonType, validationType, null);
        }
    }

    private static void reportValidationResultOfBrowserAttribute(WebDriver driver, Object[] args) {
        String[] expectedAttributeStates = (String[])args[0];
        String propertySeparator = (String)args[1];
        String attributeClosure = (String)args[2];
        int comparisonResult = (Integer)args[3];
        String propertyName = (String)args[5];
        String expectedValue = (String)args[6];
        String actualValue = (String)args[7];
        ValidationEnums.ValidationComparisonType validationComparisonType = (ValidationEnums.ValidationComparisonType)((Object)args[8]);
        ValidationEnums.ValidationType validationType = (ValidationEnums.ValidationType)((Object)args[9]);
        ValidationEnums.ValidationCategory validationCategory = (ValidationEnums.ValidationCategory)((Object)args[10]);
        if (validationType.getValue()) {
            if (comparisonResult == 1) {
                ValidationsHelper.pass(driver, validationCategory, expectedAttributeStates[0] + " '" + expectedValue + propertySeparator + propertyName + attributeClosure, actualValue, (Object)validationComparisonType, validationType);
            } else {
                ValidationsHelper.fail(driver, validationCategory, expectedAttributeStates[0] + " '" + expectedValue + propertySeparator + propertyName + attributeClosure, actualValue, (Object)validationComparisonType, validationType, null);
            }
        } else if (comparisonResult == 1) {
            ValidationsHelper.pass(driver, validationCategory, expectedAttributeStates[1] + " '" + expectedValue + propertySeparator + propertyName + attributeClosure, actualValue, (Object)validationComparisonType, validationType);
        } else {
            ValidationsHelper.fail(driver, validationCategory, expectedAttributeStates[1] + " '" + expectedValue + propertySeparator + propertyName + attributeClosure, actualValue, (Object)validationComparisonType, validationType, null);
        }
    }

    private static void reportValidationState(WebDriver driver, ValidationEnums.ValidationCategory validationCategory, String expectedValue, String actualValue, Object validationComparisonOrComparativeRelationType, ValidationEnums.ValidationType validationType, ValidationEnums.ValidationState validationState, Throwable failureReason, List<List<Object>> externalAttachments) {
        StackTraceElement[] stacktrace;
        Object validationMethodName;
        StringBuilder message = new StringBuilder();
        ArrayList<List<Object>> attachments = new ArrayList<List<Object>>();
        if (externalAttachments != null && !externalAttachments.isEmpty()) {
            attachments.addAll(externalAttachments);
        }
        if (((String)(validationMethodName = (stacktrace = new Throwable().getStackTrace())[2].getMethodName())).contains("reportValidationResult")) {
            validationMethodName = stacktrace[3].getMethodName();
        }
        String validationTypeString = "Assertion";
        if (validationCategory.equals((Object)ValidationEnums.ValidationCategory.SOFT_ASSERT)) {
            validationTypeString = "Verification";
        }
        validationMethodName = ((String)validationMethodName).substring(0, 1).toUpperCase() + ((String)validationMethodName).substring(1);
        message.append(validationTypeString).append(" \"").append((String)validationMethodName).append("\" ");
        if (((String)validationMethodName).equals("ValidateFail")) {
            message.append((Object)validationState).append(". ");
            message.append("Successfully force failed the test.");
        } else {
            message.append((Object)validationState).append(". ");
            boolean isExpectedOrActualValueLong = ValidationsHelper.isExpectedOrActualValueLong(expectedValue, actualValue);
            if (Boolean.TRUE.equals(isExpectedOrActualValueLong)) {
                List<Object> expectedValueAttachment = Arrays.asList("Validation Test Data", "Expected Value", expectedValue);
                List<Object> actualValueAttachment = Arrays.asList("Validation Test Data", "Actual Value", actualValue);
                attachments.add(expectedValueAttachment);
                attachments.add(actualValueAttachment);
                message.append("Expected and Actual values are attached.");
            } else {
                message.append("Expected \"").append(expectedValue).append("\" and Actual \"").append(actualValue).append("\".");
            }
            if (validationComparisonOrComparativeRelationType != null) {
                message.append(" Comparison Type \"").append(validationComparisonOrComparativeRelationType).append("\".");
            }
            if (validationType != null) {
                message.append(" Validation Type \"").append((Object)validationType).append("\".");
            }
        }
        if (driver != null) {
            attachments.add(ScreenshotManager.takeScreenshot(driver, lastUsedElementLocator, (String)validationMethodName, validationState.getValue()));
            lastUsedElementLocator = null;
        }
        if (driver != null && !WHEN_TO_TAKE_PAGE_SOURCE_SNAPSHOT.equalsIgnoreCase("Never") && (WHEN_TO_TAKE_PAGE_SOURCE_SNAPSHOT.equalsIgnoreCase("Always") || WHEN_TO_TAKE_PAGE_SOURCE_SNAPSHOT.equalsIgnoreCase("ValidationPointsOnly") || Boolean.FALSE.equals(validationState.getValue()) && WHEN_TO_TAKE_PAGE_SOURCE_SNAPSHOT.equalsIgnoreCase("FailuresOnly"))) {
            String logMessage = "";
            String pageSnapshot = BrowserActionsHelper.capturePageSnapshot(driver);
            if (pageSnapshot.startsWith("From: <Saved by Blink>")) {
                logMessage = "page snapshot";
            } else if (pageSnapshot.startsWith("<html")) {
                logMessage = "page HTML";
            }
            List<Object> sourceAttachment = Arrays.asList(validationMethodName, logMessage, pageSnapshot);
            attachments.add(sourceAttachment);
        }
        if (failureReason != null) {
            List<Object> failureReasonAttachment = Arrays.asList("Validation Test Data", "Failure Reason", ReportManagerHelper.formatStackTraceToLogEntry(failureReason));
            attachments.add(failureReasonAttachment);
        } else if (Boolean.FALSE.equals(validationState.getValue())) {
            List<Object> failureReasonAttachment = Arrays.asList("Validation Test Data", "Failure Reason", ReportManagerHelper.formatStackTraceToLogEntry((Throwable)((Object)new AssertionError(message))));
            attachments.add(failureReasonAttachment);
        }
        if (!attachments.isEmpty()) {
            ReportManagerHelper.logNestedSteps(message.toString(), (List<String>)optionalCustomLogMessage.get(), attachments);
        } else {
            ReportManagerHelper.logNestedSteps(message.toString(), (List<String>)optionalCustomLogMessage.get(), null);
        }
        switch (validationCategory) {
            case HARD_ASSERT: {
                if (validationState.getValue()) break;
                if (failureReason != null) {
                    FailureReporter.fail(ValidationsHelper.class, message.toString(), failureReason);
                    break;
                }
                FailureReporter.fail(message.toString());
                break;
            }
            case SOFT_ASSERT: {
                if (validationState.getValue()) break;
                verificationFailuresList.add(message.toString());
                verificationError = new AssertionError((Object)String.join((CharSequence)"\nAND ", verificationFailuresList));
                break;
            }
        }
    }

    private static boolean isExpectedOrActualValueLong(String expectedValue, String actualValue) {
        boolean isExpectedOrActualValueLong = false;
        if (actualValue == null && expectedValue != null) {
            isExpectedOrActualValueLong = expectedValue.length() >= 500;
        } else if (actualValue != null && expectedValue == null) {
            isExpectedOrActualValueLong = actualValue.length() >= 500;
        } else if (actualValue != null) {
            isExpectedOrActualValueLong = expectedValue.length() >= 500 || actualValue.length() >= 500;
        }
        return isExpectedOrActualValueLong;
    }

    private static void processCustomLogMessage(String ... optionalCustomLogMessage) {
        ValidationsHelper.optionalCustomLogMessage.set(new ArrayList());
        for (String customMessage : optionalCustomLogMessage) {
            if (customMessage == null || customMessage.isBlank()) continue;
            ValidationsHelper.optionalCustomLogMessage.get().add(customMessage);
        }
    }
}

