/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.validation.internal;

import com.shaft.driver.SHAFT;
import com.shaft.gui.browser.internal.BrowserActionsHelper;
import com.shaft.gui.element.ElementActions;
import com.shaft.gui.element.internal.ElementActionsHelper;
import com.shaft.gui.internal.image.ScreenshotManager;
import com.shaft.tools.internal.support.JavaHelper;
import com.shaft.tools.io.internal.FailureReporter;
import com.shaft.tools.io.internal.ReportManagerHelper;
import com.shaft.validation.ValidationEnums;
import com.shaft.validation.internal.ValidationsHelper;
import io.qameta.allure.Step;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ValidationsHelper2 {
    private final ValidationEnums.ValidationCategory validationCategory;
    private final String validationCategoryString;

    ValidationsHelper2(ValidationEnums.ValidationCategory validationCategory) {
        this.validationCategory = validationCategory;
        this.validationCategoryString = validationCategory.equals((Object)ValidationEnums.ValidationCategory.HARD_ASSERT) ? "Assert" : "Verify";
    }

    @Step(value=" {this.validationCategoryString} that {customReportMessage}")
    protected void validateElementAttribute(WebDriver driver, By elementLocator, String elementAttribute, String expectedValue, ValidationEnums.ValidationComparisonType validationComparisonType, ValidationEnums.ValidationType validationType, String customReportMessage) {
        String actualValue = switch (elementAttribute.toLowerCase()) {
            case "text" -> new ElementActions(driver).getText(elementLocator);
            case "texttrimmed" -> new ElementActions(driver).getText(elementLocator).trim();
            case "tagname" -> ((WebElement)ElementActionsHelper.identifyUniqueElementIgnoringVisibility(driver, elementLocator).get(1)).getTagName();
            case "size" -> ((WebElement)ElementActionsHelper.identifyUniqueElementIgnoringVisibility(driver, elementLocator).get(1)).getSize().toString();
            case "selectedtext" -> new ElementActions(driver).getSelectedText(elementLocator);
            default -> new ElementActions(driver).getAttribute(elementLocator, elementAttribute);
        };
        int comparisonResult = JavaHelper.compareTwoObjects(expectedValue, actualValue, validationComparisonType.getValue(), validationType.getValue());
        String validationMethodName = new Throwable().getStackTrace()[0].getMethodName().replace("validate", this.validationCategoryString);
        boolean validationState = comparisonResult == 1 ? ValidationEnums.ValidationState.PASSED.getValue() : ValidationEnums.ValidationState.FAILED.getValue();
        ArrayList<List<Object>> attachments = new ArrayList<List<Object>>();
        attachments.add(ScreenshotManager.takeScreenshot(driver, elementLocator, validationMethodName, validationState));
        String whenToTakePageSourceSnapshot = SHAFT.Properties.visuals.whenToTakePageSourceSnapshot().toLowerCase();
        if (Boolean.FALSE.equals(validationState) || Arrays.asList("always", "validationpointsonly").contains(whenToTakePageSourceSnapshot)) {
            String logMessage = "";
            String pageSnapshot = BrowserActionsHelper.capturePageSnapshot(driver);
            if (pageSnapshot.startsWith("From: <Saved by Blink>")) {
                logMessage = "page snapshot";
            } else if (pageSnapshot.startsWith("<html")) {
                logMessage = "page HTML";
            }
            List<Object> pageSourceAttachment = Arrays.asList(validationMethodName, logMessage, pageSnapshot);
            attachments.add(pageSourceAttachment);
        }
        ReportManagerHelper.attach(attachments);
        if (!validationState) {
            String failureMessage = "Failed to " + this.validationCategoryString.toLowerCase() + " that " + customReportMessage + " Actual value is \"" + actualValue + "\".";
            if (this.validationCategory.equals((Object)ValidationEnums.ValidationCategory.HARD_ASSERT)) {
                FailureReporter.fail(failureMessage);
            } else {
                ValidationsHelper.verificationFailuresList.add(failureMessage);
                ValidationsHelper.verificationError = new AssertionError((Object)String.join((CharSequence)"\nAND ", ValidationsHelper.verificationFailuresList));
            }
        }
    }
}

