/*
 * Decompiled with CFR 0.152.
 */
package com.shaft.validation.internal;

import com.shaft.validation.ValidationEnums;
import com.shaft.validation.internal.NativeValidationsBuilder;
import com.shaft.validation.internal.ValidationsExecutor;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class WebDriverElementValidationsBuilder {
    protected final ValidationEnums.ValidationCategory validationCategory;
    protected final WebDriver driver;
    protected final By locator;
    protected final StringBuilder reportMessageBuilder;
    protected ValidationEnums.ValidationType validationType;
    protected String validationMethod;
    protected ValidationEnums.VisualValidationEngine visualValidationEngine;
    protected String elementAttribute;
    protected String elementCssProperty;

    public WebDriverElementValidationsBuilder(ValidationEnums.ValidationCategory validationCategory, WebDriver driver, By locator, StringBuilder reportMessageBuilder) {
        this.validationCategory = validationCategory;
        this.driver = driver;
        this.locator = locator;
        this.reportMessageBuilder = reportMessageBuilder;
    }

    public ValidationsExecutor exists() {
        this.validationType = ValidationEnums.ValidationType.POSITIVE;
        this.validationMethod = "elementExists";
        this.reportMessageBuilder.append("exists.");
        ValidationsExecutor executor = new ValidationsExecutor(this);
        executor.internalPerform();
        return executor;
    }

    public ValidationsExecutor doesNotExist() {
        this.validationType = ValidationEnums.ValidationType.NEGATIVE;
        this.validationMethod = "elementExists";
        this.reportMessageBuilder.append("does not exist.");
        ValidationsExecutor executor = new ValidationsExecutor(this);
        executor.internalPerform();
        return executor;
    }

    public ValidationsExecutor matchesReferenceImage() {
        this.validationType = ValidationEnums.ValidationType.POSITIVE;
        this.validationMethod = "elementMatches";
        this.visualValidationEngine = ValidationEnums.VisualValidationEngine.EXACT_SHUTTERBUG;
        this.reportMessageBuilder.append("matches the reference image \"").append((Object)ValidationEnums.VisualValidationEngine.EXACT_SHUTTERBUG).append("\".");
        ValidationsExecutor executor = new ValidationsExecutor(this);
        executor.internalPerform();
        return executor;
    }

    public ValidationsExecutor matchesReferenceImage(ValidationEnums.VisualValidationEngine visualValidationEngine) {
        this.validationType = ValidationEnums.ValidationType.POSITIVE;
        this.validationMethod = "elementMatches";
        this.visualValidationEngine = visualValidationEngine;
        this.reportMessageBuilder.append("matches the reference image \"").append((Object)visualValidationEngine).append("\".");
        ValidationsExecutor executor = new ValidationsExecutor(this);
        executor.internalPerform();
        return executor;
    }

    public ValidationsExecutor doesNotMatchReferenceImage() {
        this.validationType = ValidationEnums.ValidationType.NEGATIVE;
        this.validationMethod = "elementMatches";
        this.visualValidationEngine = ValidationEnums.VisualValidationEngine.EXACT_OPENCV;
        this.reportMessageBuilder.append("does not match the reference image \"").append((Object)ValidationEnums.VisualValidationEngine.EXACT_OPENCV).append("\".");
        ValidationsExecutor executor = new ValidationsExecutor(this);
        executor.internalPerform();
        return executor;
    }

    public ValidationsExecutor doesNotMatchReferenceImage(ValidationEnums.VisualValidationEngine visualValidationEngine) {
        this.validationType = ValidationEnums.ValidationType.NEGATIVE;
        this.validationMethod = "elementMatches";
        this.visualValidationEngine = visualValidationEngine;
        this.reportMessageBuilder.append("does not match the reference image \"").append((Object)visualValidationEngine).append("\".");
        ValidationsExecutor executor = new ValidationsExecutor(this);
        executor.internalPerform();
        return executor;
    }

    public NativeValidationsBuilder attribute(String elementAttribute) {
        this.validationMethod = "elementAttributeEquals";
        this.elementAttribute = elementAttribute;
        this.reportMessageBuilder.append("attribute \"").append(elementAttribute).append("\" ");
        return new NativeValidationsBuilder(this);
    }

    public ValidationsExecutor isSelected() {
        this.validationMethod = "elementAttributeEquals";
        this.elementAttribute = "selected";
        this.reportMessageBuilder.append("is selected; selected attribute ");
        return new NativeValidationsBuilder(this).isTrue();
    }

    public ValidationsExecutor isChecked() {
        this.validationMethod = "elementAttributeEquals";
        this.elementAttribute = "checked";
        this.reportMessageBuilder.append("is checked; checked attribute ");
        return new NativeValidationsBuilder(this).isTrue();
    }

    public ValidationsExecutor isVisible() {
        this.validationMethod = "elementAttributeEquals";
        this.elementAttribute = "hidden";
        this.reportMessageBuilder.append("is visible; hidden attribute ");
        return new NativeValidationsBuilder(this).isEqualTo("null");
    }

    public ValidationsExecutor isEnabled() {
        this.validationMethod = "elementAttributeEquals";
        this.elementAttribute = "disabled";
        this.reportMessageBuilder.append("is enabled; disabled attribute ");
        return new NativeValidationsBuilder(this).isEqualTo("null");
    }

    public ValidationsExecutor isNotSelected() {
        this.validationMethod = "elementAttributeEquals";
        this.elementAttribute = "selected";
        this.reportMessageBuilder.append("is not selected; selected attribute ");
        return new NativeValidationsBuilder(this).isEqualTo("null");
    }

    public ValidationsExecutor isNotChecked() {
        this.validationMethod = "elementAttributeEquals";
        this.elementAttribute = "checked";
        this.reportMessageBuilder.append("is not checked; checked attribute ");
        return new NativeValidationsBuilder(this).isEqualTo("null");
    }

    public ValidationsExecutor isHidden() {
        this.validationMethod = "elementAttributeEquals";
        this.elementAttribute = "hidden";
        this.reportMessageBuilder.append("is hidden; hidden attribute ");
        return new NativeValidationsBuilder(this).isTrue();
    }

    public ValidationsExecutor isDisabled() {
        this.validationMethod = "elementAttributeEquals";
        this.elementAttribute = "disabled";
        this.reportMessageBuilder.append("is disabled; disabled attribute ");
        return new NativeValidationsBuilder(this).isTrue();
    }

    public NativeValidationsBuilder text() {
        this.validationMethod = "elementAttributeEquals";
        this.elementAttribute = "text";
        this.reportMessageBuilder.append("text ");
        return new NativeValidationsBuilder(this);
    }

    public NativeValidationsBuilder textTrimmed() {
        this.validationMethod = "elementAttributeEquals";
        this.elementAttribute = "textTrimmed";
        this.reportMessageBuilder.append("text trimmed ");
        return new NativeValidationsBuilder(this);
    }

    public NativeValidationsBuilder cssProperty(String elementCssProperty) {
        this.validationMethod = "elementCssPropertyEquals";
        this.elementCssProperty = elementCssProperty;
        this.reportMessageBuilder.append("CSS property \"").append(elementCssProperty).append("\" ");
        return new NativeValidationsBuilder(this);
    }
}

