/*
 * Decompiled with CFR 0.152.
 */
package io.github.shangor.llm;

import io.github.shangor.llm.pojo.OpenAiLlmResult;
import io.github.shangor.llm.pojo.OpenAiLlmStreamResult;
import io.micrometer.common.util.StringUtils;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.http.codec.ServerSentEvent;
import reactor.core.publisher.Flux;

public abstract class LlmCompletionFunc {
    protected String model;
    protected URI url;
    protected Options options = new Options();

    public OpenAiLlmResult complete(List<CompletionMessage> messages) {
        return this.complete(messages, this.options);
    }

    public static String getModel(Options options, String model) {
        if (StringUtils.isBlank((String)options.getModel())) {
            return model;
        }
        return options.getModel();
    }

    public abstract OpenAiLlmResult complete(List<CompletionMessage> var1, Options var2);

    public OpenAiLlmResult complete(String prompt, List<CompletionMessage> historyMessages, Options options) {
        LinkedList<CompletionMessage> messages = new LinkedList<CompletionMessage>(historyMessages);
        messages.add(CompletionMessage.builder().role("user").content(prompt).build());
        return this.complete(messages, options);
    }

    public OpenAiLlmResult complete(String prompt, List<CompletionMessage> historyMessages) {
        return this.complete(prompt, historyMessages, this.options);
    }

    public abstract Flux<ServerSentEvent<OpenAiLlmStreamResult>> completeStream(List<CompletionMessage> var1, Options var2);

    public Flux<ServerSentEvent<OpenAiLlmStreamResult>> completeStream(String prompt) {
        return this.completeStream(prompt, Collections.emptyList(), this.options);
    }

    public Flux<ServerSentEvent<OpenAiLlmStreamResult>> completeStream(String prompt, List<CompletionMessage> historyMessages) {
        return this.completeStream(prompt, historyMessages, this.options);
    }

    public Flux<ServerSentEvent<OpenAiLlmStreamResult>> completeStream(String prompt, List<CompletionMessage> historyMessages, Options options) {
        LinkedList<CompletionMessage> messages = new LinkedList<CompletionMessage>(historyMessages);
        messages.add(CompletionMessage.builder().role("user").content(prompt).build());
        return this.completeStream(messages, options);
    }

    public OpenAiLlmResult complete(String prompt) {
        return this.complete(prompt, Collections.emptyList(), this.options);
    }

    public String getModel() {
        return this.model;
    }

    public URI getUrl() {
        return this.url;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LlmCompletionFunc)) {
            return false;
        }
        LlmCompletionFunc other = (LlmCompletionFunc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        URI this$url = this.getUrl();
        URI other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        Options this$options = this.getOptions();
        Options other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LlmCompletionFunc;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        URI $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        Options $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    public String toString() {
        return "LlmCompletionFunc(model=" + this.getModel() + ", url=" + String.valueOf(this.getUrl()) + ", options=" + String.valueOf(this.getOptions()) + ")";
    }

    public static class Options {
        protected Double temperature = 1.0;
        protected boolean stream = false;
        protected String model;

        public Double getTemperature() {
            return this.temperature;
        }

        public boolean isStream() {
            return this.stream;
        }

        public String getModel() {
            return this.model;
        }

        public void setTemperature(Double temperature) {
            this.temperature = temperature;
        }

        public void setStream(boolean stream) {
            this.stream = stream;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options other = (Options)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isStream() != other.isStream()) {
                return false;
            }
            Double this$temperature = this.getTemperature();
            Double other$temperature = other.getTemperature();
            if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
                return false;
            }
            String this$model = this.getModel();
            String other$model = other.getModel();
            return !(this$model == null ? other$model != null : !this$model.equals(other$model));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Options;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isStream() ? 79 : 97);
            Double $temperature = this.getTemperature();
            result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
            String $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            return result;
        }

        public String toString() {
            return "LlmCompletionFunc.Options(temperature=" + this.getTemperature() + ", stream=" + this.isStream() + ", model=" + this.getModel() + ")";
        }
    }

    public static class CompletionMessage {
        private String role;
        private String content;
        private List<String> images;

        public static CompletionMessageBuilder builder() {
            return new CompletionMessageBuilder();
        }

        public String getRole() {
            return this.role;
        }

        public String getContent() {
            return this.content;
        }

        public List<String> getImages() {
            return this.images;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setImages(List<String> images) {
            this.images = images;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompletionMessage)) {
                return false;
            }
            CompletionMessage other = (CompletionMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            List<String> this$images = this.getImages();
            List<String> other$images = other.getImages();
            return !(this$images == null ? other$images != null : !((Object)this$images).equals(other$images));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CompletionMessage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            List<String> $images = this.getImages();
            result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
            return result;
        }

        public String toString() {
            return "LlmCompletionFunc.CompletionMessage(role=" + this.getRole() + ", content=" + this.getContent() + ", images=" + String.valueOf(this.getImages()) + ")";
        }

        public CompletionMessage() {
        }

        public CompletionMessage(String role, String content, List<String> images) {
            this.role = role;
            this.content = content;
            this.images = images;
        }

        public static class CompletionMessageBuilder {
            private String role;
            private String content;
            private List<String> images;

            CompletionMessageBuilder() {
            }

            public CompletionMessageBuilder role(String role) {
                this.role = role;
                return this;
            }

            public CompletionMessageBuilder content(String content) {
                this.content = content;
                return this;
            }

            public CompletionMessageBuilder images(List<String> images) {
                this.images = images;
                return this;
            }

            public CompletionMessage build() {
                return new CompletionMessage(this.role, this.content, this.images);
            }

            public String toString() {
                return "LlmCompletionFunc.CompletionMessage.CompletionMessageBuilder(role=" + this.role + ", content=" + this.content + ", images=" + String.valueOf(this.images) + ")";
            }
        }
    }
}

