/*
 * Decompiled with CFR 0.152.
 */
package io.github.shangor.llm.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.shangor.llm.LlmCompletionFunc;
import io.github.shangor.llm.pojo.OpenAiCompletionRequest;
import io.github.shangor.llm.pojo.OpenAiLlmResult;
import io.github.shangor.llm.pojo.OpenAiLlmStreamResult;
import io.github.shangor.llm.service.HttpService;
import io.github.shangor.util.DateTimeUtils;
import io.github.shangor.util.GenUtils;
import io.micrometer.common.util.StringUtils;
import jakarta.annotation.Resource;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

@Service
@ConditionalOnProperty(value={"llm.completion.provider"}, havingValue="ollama")
public class OllamaCompletionFunc
extends LlmCompletionFunc {
    private static final Logger log = LoggerFactory.getLogger(OllamaCompletionFunc.class);
    @Value(value="${llm.completion.model}")
    private String model;
    @Value(value="${llm.embedding.url:http://localhost:11434/api/chat}")
    private URI url;
    private Map<String, String> headers = Map.of("Content-Type", "application/json;charset=utf-8");
    @Resource
    private ObjectMapper objectMapper;
    @Resource
    HttpService httpService;

    @Override
    public OpenAiLlmResult complete(List<LlmCompletionFunc.CompletionMessage> messages, LlmCompletionFunc.Options options) {
        OllamaResult ollamaResult = this.httpService.post(this.url, this.headers, Map.of("model", LlmCompletionFunc.getModel(options, this.model), "messages", messages, "stream", options.isStream(), "options", options), OllamaResult.class);
        OpenAiLlmResult result = new OpenAiLlmResult();
        OpenAiLlmResult.Usage usage = new OpenAiLlmResult.Usage();
        usage.setTotal_tokens(ollamaResult.getEvalCount() + ollamaResult.getPromptEvalCount());
        usage.setPrompt_tokens(ollamaResult.getPromptEvalCount());
        usage.setCompletion_tokens(ollamaResult.getEvalCount());
        result.setUsage(usage);
        OpenAiLlmResult.Choice choice = new OpenAiLlmResult.Choice();
        choice.setIndex(0);
        choice.setMessage(ollamaResult.getMessage());
        choice.setFinish_reason(ollamaResult.getDoneReason());
        result.setModel(this.model);
        result.setCreated(DateTimeUtils.parseOllamaDateTime(ollamaResult.getCreatedAt()));
        return result;
    }

    @Override
    public Flux<ServerSentEvent<OpenAiLlmStreamResult>> completeStream(List<LlmCompletionFunc.CompletionMessage> messages, LlmCompletionFunc.Options options) {
        options.setStream(true);
        String requestId = UUID.randomUUID().toString();
        return this.httpService.postSeverSentEvent(this.url, null, Map.of("model", LlmCompletionFunc.getModel(options, this.model), "messages", messages, "stream", true, "options", options), true).mapNotNull(sse -> {
            String data = (String)sse.data();
            if (StringUtils.isBlank((String)data)) {
                return null;
            }
            OllamaStreamResult obj = GenUtils.jsonToObject(data, OllamaStreamResult.class);
            OpenAiLlmStreamResult res = new OpenAiLlmStreamResult();
            res.setId(requestId);
            res.setModel(obj.getModel());
            res.setCreated(DateTimeUtils.parseOllamaDateTime(obj.getCreatedAt()));
            if (obj.isDone()) {
                OpenAiLlmStreamResult.Usage usage = new OpenAiLlmStreamResult.Usage();
                usage.setTotal_tokens(obj.getEvalCount() + obj.getPromptEvalCount());
                usage.setPrompt_tokens(obj.getPromptEvalCount().intValue());
                usage.setCompletion_tokens(obj.getEvalCount().intValue());
                res.setUsage(usage);
            }
            OpenAiLlmStreamResult.Choice choice = new OpenAiLlmStreamResult.Choice();
            choice.setIndex(0);
            choice.setDelta(obj.getMessage());
            choice.setFinish_reason(obj.getDoneReason());
            res.setChoices(List.of(choice));
            return res;
        }).map(s -> ServerSentEvent.builder((Object)s).id(requestId).event("llm").build());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OllamaCompletionFunc)) {
            return false;
        }
        OllamaCompletionFunc other = (OllamaCompletionFunc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        URI this$url = this.getUrl();
        URI other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        if (this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper)) {
            return false;
        }
        HttpService this$httpService = this.getHttpService();
        HttpService other$httpService = other.getHttpService();
        return !(this$httpService == null ? other$httpService != null : !this$httpService.equals(other$httpService));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OllamaCompletionFunc;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        URI $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        HttpService $httpService = this.getHttpService();
        result = result * 59 + ($httpService == null ? 43 : $httpService.hashCode());
        return result;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public URI getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public HttpService getHttpService() {
        return this.httpService;
    }

    @Override
    public void setModel(String model) {
        this.model = model;
    }

    @Override
    public void setUrl(URI url) {
        this.url = url;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    @Override
    public String toString() {
        return "OllamaCompletionFunc(model=" + this.getModel() + ", url=" + String.valueOf(this.getUrl()) + ", headers=" + String.valueOf(this.getHeaders()) + ", objectMapper=" + String.valueOf(this.getObjectMapper()) + ", httpService=" + String.valueOf(this.getHttpService()) + ")";
    }

    public static class OllamaResult {
        private String model;
        private LlmCompletionFunc.CompletionMessage message;
        private boolean done;
        @JsonProperty(value="created_at")
        protected String createdAt;
        @JsonProperty(value="done_reason")
        protected String doneReason;
        @JsonProperty(value="total_duration")
        protected long totalDuration;
        @JsonProperty(value="load_duration")
        protected long loadDuration;
        @JsonProperty(value="prompt_eval_count")
        protected long promptEvalCount;
        @JsonProperty(value="prompt_eval_duration")
        protected long promptEvalDuration;
        @JsonProperty(value="eval_count")
        protected long evalCount;
        @JsonProperty(value="eval_duration")
        protected long evalDuration;

        public String getModel() {
            return this.model;
        }

        public LlmCompletionFunc.CompletionMessage getMessage() {
            return this.message;
        }

        public boolean isDone() {
            return this.done;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public String getDoneReason() {
            return this.doneReason;
        }

        public long getTotalDuration() {
            return this.totalDuration;
        }

        public long getLoadDuration() {
            return this.loadDuration;
        }

        public long getPromptEvalCount() {
            return this.promptEvalCount;
        }

        public long getPromptEvalDuration() {
            return this.promptEvalDuration;
        }

        public long getEvalCount() {
            return this.evalCount;
        }

        public long getEvalDuration() {
            return this.evalDuration;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public void setMessage(LlmCompletionFunc.CompletionMessage message) {
            this.message = message;
        }

        public void setDone(boolean done) {
            this.done = done;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="done_reason")
        public void setDoneReason(String doneReason) {
            this.doneReason = doneReason;
        }

        @JsonProperty(value="total_duration")
        public void setTotalDuration(long totalDuration) {
            this.totalDuration = totalDuration;
        }

        @JsonProperty(value="load_duration")
        public void setLoadDuration(long loadDuration) {
            this.loadDuration = loadDuration;
        }

        @JsonProperty(value="prompt_eval_count")
        public void setPromptEvalCount(long promptEvalCount) {
            this.promptEvalCount = promptEvalCount;
        }

        @JsonProperty(value="prompt_eval_duration")
        public void setPromptEvalDuration(long promptEvalDuration) {
            this.promptEvalDuration = promptEvalDuration;
        }

        @JsonProperty(value="eval_count")
        public void setEvalCount(long evalCount) {
            this.evalCount = evalCount;
        }

        @JsonProperty(value="eval_duration")
        public void setEvalDuration(long evalDuration) {
            this.evalDuration = evalDuration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OllamaResult)) {
                return false;
            }
            OllamaResult other = (OllamaResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isDone() != other.isDone()) {
                return false;
            }
            if (this.getTotalDuration() != other.getTotalDuration()) {
                return false;
            }
            if (this.getLoadDuration() != other.getLoadDuration()) {
                return false;
            }
            if (this.getPromptEvalCount() != other.getPromptEvalCount()) {
                return false;
            }
            if (this.getPromptEvalDuration() != other.getPromptEvalDuration()) {
                return false;
            }
            if (this.getEvalCount() != other.getEvalCount()) {
                return false;
            }
            if (this.getEvalDuration() != other.getEvalDuration()) {
                return false;
            }
            String this$model = this.getModel();
            String other$model = other.getModel();
            if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
                return false;
            }
            LlmCompletionFunc.CompletionMessage this$message = this.getMessage();
            LlmCompletionFunc.CompletionMessage other$message = other.getMessage();
            if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
                return false;
            }
            String this$createdAt = this.getCreatedAt();
            String other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) {
                return false;
            }
            String this$doneReason = this.getDoneReason();
            String other$doneReason = other.getDoneReason();
            return !(this$doneReason == null ? other$doneReason != null : !this$doneReason.equals(other$doneReason));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OllamaResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDone() ? 79 : 97);
            long $totalDuration = this.getTotalDuration();
            result = result * 59 + (int)($totalDuration >>> 32 ^ $totalDuration);
            long $loadDuration = this.getLoadDuration();
            result = result * 59 + (int)($loadDuration >>> 32 ^ $loadDuration);
            long $promptEvalCount = this.getPromptEvalCount();
            result = result * 59 + (int)($promptEvalCount >>> 32 ^ $promptEvalCount);
            long $promptEvalDuration = this.getPromptEvalDuration();
            result = result * 59 + (int)($promptEvalDuration >>> 32 ^ $promptEvalDuration);
            long $evalCount = this.getEvalCount();
            result = result * 59 + (int)($evalCount >>> 32 ^ $evalCount);
            long $evalDuration = this.getEvalDuration();
            result = result * 59 + (int)($evalDuration >>> 32 ^ $evalDuration);
            String $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            LlmCompletionFunc.CompletionMessage $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            String $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : $createdAt.hashCode());
            String $doneReason = this.getDoneReason();
            result = result * 59 + ($doneReason == null ? 43 : $doneReason.hashCode());
            return result;
        }

        public String toString() {
            return "OllamaCompletionFunc.OllamaResult(model=" + this.getModel() + ", message=" + String.valueOf(this.getMessage()) + ", done=" + this.isDone() + ", createdAt=" + this.getCreatedAt() + ", doneReason=" + this.getDoneReason() + ", totalDuration=" + this.getTotalDuration() + ", loadDuration=" + this.getLoadDuration() + ", promptEvalCount=" + this.getPromptEvalCount() + ", promptEvalDuration=" + this.getPromptEvalDuration() + ", evalCount=" + this.getEvalCount() + ", evalDuration=" + this.getEvalDuration() + ")";
        }
    }

    public static class OllamaStreamResult {
        protected String model;
        @JsonProperty(value="created_at")
        protected String createdAt;
        protected LlmCompletionFunc.CompletionMessage message;
        protected boolean done;
        @JsonProperty(value="done_reason")
        protected String doneReason;
        @JsonProperty(value="total_duration")
        protected Long totalDuration;
        @JsonProperty(value="load_duration")
        protected Long loadDuration;
        @JsonProperty(value="prompt_eval_count")
        protected Long promptEvalCount;
        @JsonProperty(value="prompt_eval_duration")
        protected Long promptEvalDuration;
        @JsonProperty(value="eval_count")
        protected Long evalCount;
        @JsonProperty(value="eval_duration")
        protected Long evalDuration;

        public String getModel() {
            return this.model;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public LlmCompletionFunc.CompletionMessage getMessage() {
            return this.message;
        }

        public boolean isDone() {
            return this.done;
        }

        public String getDoneReason() {
            return this.doneReason;
        }

        public Long getTotalDuration() {
            return this.totalDuration;
        }

        public Long getLoadDuration() {
            return this.loadDuration;
        }

        public Long getPromptEvalCount() {
            return this.promptEvalCount;
        }

        public Long getPromptEvalDuration() {
            return this.promptEvalDuration;
        }

        public Long getEvalCount() {
            return this.evalCount;
        }

        public Long getEvalDuration() {
            return this.evalDuration;
        }

        public void setModel(String model) {
            this.model = model;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public void setMessage(LlmCompletionFunc.CompletionMessage message) {
            this.message = message;
        }

        public void setDone(boolean done) {
            this.done = done;
        }

        @JsonProperty(value="done_reason")
        public void setDoneReason(String doneReason) {
            this.doneReason = doneReason;
        }

        @JsonProperty(value="total_duration")
        public void setTotalDuration(Long totalDuration) {
            this.totalDuration = totalDuration;
        }

        @JsonProperty(value="load_duration")
        public void setLoadDuration(Long loadDuration) {
            this.loadDuration = loadDuration;
        }

        @JsonProperty(value="prompt_eval_count")
        public void setPromptEvalCount(Long promptEvalCount) {
            this.promptEvalCount = promptEvalCount;
        }

        @JsonProperty(value="prompt_eval_duration")
        public void setPromptEvalDuration(Long promptEvalDuration) {
            this.promptEvalDuration = promptEvalDuration;
        }

        @JsonProperty(value="eval_count")
        public void setEvalCount(Long evalCount) {
            this.evalCount = evalCount;
        }

        @JsonProperty(value="eval_duration")
        public void setEvalDuration(Long evalDuration) {
            this.evalDuration = evalDuration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OllamaStreamResult)) {
                return false;
            }
            OllamaStreamResult other = (OllamaStreamResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isDone() != other.isDone()) {
                return false;
            }
            Long this$totalDuration = this.getTotalDuration();
            Long other$totalDuration = other.getTotalDuration();
            if (this$totalDuration == null ? other$totalDuration != null : !((Object)this$totalDuration).equals(other$totalDuration)) {
                return false;
            }
            Long this$loadDuration = this.getLoadDuration();
            Long other$loadDuration = other.getLoadDuration();
            if (this$loadDuration == null ? other$loadDuration != null : !((Object)this$loadDuration).equals(other$loadDuration)) {
                return false;
            }
            Long this$promptEvalCount = this.getPromptEvalCount();
            Long other$promptEvalCount = other.getPromptEvalCount();
            if (this$promptEvalCount == null ? other$promptEvalCount != null : !((Object)this$promptEvalCount).equals(other$promptEvalCount)) {
                return false;
            }
            Long this$promptEvalDuration = this.getPromptEvalDuration();
            Long other$promptEvalDuration = other.getPromptEvalDuration();
            if (this$promptEvalDuration == null ? other$promptEvalDuration != null : !((Object)this$promptEvalDuration).equals(other$promptEvalDuration)) {
                return false;
            }
            Long this$evalCount = this.getEvalCount();
            Long other$evalCount = other.getEvalCount();
            if (this$evalCount == null ? other$evalCount != null : !((Object)this$evalCount).equals(other$evalCount)) {
                return false;
            }
            Long this$evalDuration = this.getEvalDuration();
            Long other$evalDuration = other.getEvalDuration();
            if (this$evalDuration == null ? other$evalDuration != null : !((Object)this$evalDuration).equals(other$evalDuration)) {
                return false;
            }
            String this$model = this.getModel();
            String other$model = other.getModel();
            if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
                return false;
            }
            String this$createdAt = this.getCreatedAt();
            String other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) {
                return false;
            }
            LlmCompletionFunc.CompletionMessage this$message = this.getMessage();
            LlmCompletionFunc.CompletionMessage other$message = other.getMessage();
            if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
                return false;
            }
            String this$doneReason = this.getDoneReason();
            String other$doneReason = other.getDoneReason();
            return !(this$doneReason == null ? other$doneReason != null : !this$doneReason.equals(other$doneReason));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OllamaStreamResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDone() ? 79 : 97);
            Long $totalDuration = this.getTotalDuration();
            result = result * 59 + ($totalDuration == null ? 43 : ((Object)$totalDuration).hashCode());
            Long $loadDuration = this.getLoadDuration();
            result = result * 59 + ($loadDuration == null ? 43 : ((Object)$loadDuration).hashCode());
            Long $promptEvalCount = this.getPromptEvalCount();
            result = result * 59 + ($promptEvalCount == null ? 43 : ((Object)$promptEvalCount).hashCode());
            Long $promptEvalDuration = this.getPromptEvalDuration();
            result = result * 59 + ($promptEvalDuration == null ? 43 : ((Object)$promptEvalDuration).hashCode());
            Long $evalCount = this.getEvalCount();
            result = result * 59 + ($evalCount == null ? 43 : ((Object)$evalCount).hashCode());
            Long $evalDuration = this.getEvalDuration();
            result = result * 59 + ($evalDuration == null ? 43 : ((Object)$evalDuration).hashCode());
            String $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            String $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : $createdAt.hashCode());
            LlmCompletionFunc.CompletionMessage $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            String $doneReason = this.getDoneReason();
            result = result * 59 + ($doneReason == null ? 43 : $doneReason.hashCode());
            return result;
        }

        public String toString() {
            return "OllamaCompletionFunc.OllamaStreamResult(model=" + this.getModel() + ", createdAt=" + this.getCreatedAt() + ", message=" + String.valueOf(this.getMessage()) + ", done=" + this.isDone() + ", doneReason=" + this.getDoneReason() + ", totalDuration=" + this.getTotalDuration() + ", loadDuration=" + this.getLoadDuration() + ", promptEvalCount=" + this.getPromptEvalCount() + ", promptEvalDuration=" + this.getPromptEvalDuration() + ", evalCount=" + this.getEvalCount() + ", evalDuration=" + this.getEvalDuration() + ")";
        }
    }

    public static class OllamaRequest {
        private String model;
        private List<LlmCompletionFunc.CompletionMessage> messages;
        private String format = "text";
        private boolean stream;
        private LlmCompletionFunc.Options options;

        public static OllamaRequest fromOpenAiRequest(OpenAiCompletionRequest request) {
            OllamaRequest ollamaRequest = new OllamaRequest();
            OllamaOptions options = new OllamaOptions();
            ollamaRequest.setOptions(options);
            if (request.getTemperature() != null) {
                options.setTemperature(request.getTemperature());
            }
            if (request.getMax_completion_tokens() != null) {
                options.setNum_predict(request.getMax_completion_tokens());
            }
            ollamaRequest.setModel(request.getModel());
            ollamaRequest.setFormat(request.getFormat());
            if (null == request.getStream()) {
                ollamaRequest.setStream(false);
            } else {
                ollamaRequest.setStream(request.getStream());
            }
            ArrayList<LlmCompletionFunc.CompletionMessage> messages = new ArrayList<LlmCompletionFunc.CompletionMessage>();
            ollamaRequest.setMessages(messages);
            for (Map<String, Object> messageReq : request.getMessages()) {
                LlmCompletionFunc.CompletionMessage message = new LlmCompletionFunc.CompletionMessage();
                message.setRole((String)messageReq.get("role"));
                Object content = messageReq.get("content");
                LinkedList<String> imageList = new LinkedList<String>();
                if (content instanceof String) {
                    String messageText = (String)content;
                    message.setContent(messageText);
                } else if (content instanceof List) {
                    List contents = (List)content;
                    for (Object item : contents) {
                        Object list;
                        if (!(item instanceof Map)) continue;
                        Map contentItem = (Map)item;
                        String contentType = (String)contentItem.get("type");
                        if ("text".equals(contentType)) {
                            message.setContent((String)contentItem.get("text"));
                            continue;
                        }
                        if (!"image_url".equals(contentType) || (list = contentItem.get("image_url")) == null || !(list instanceof Map)) continue;
                        Map imageUrl = (Map)list;
                        String url = (String)imageUrl.get("url");
                        if (url.startsWith("data:")) {
                            imageList.add(url.split(",")[1]);
                            continue;
                        }
                        imageList.add(url);
                    }
                }
                if (!imageList.isEmpty()) {
                    message.setImages(imageList);
                }
                messages.add(message);
            }
            return ollamaRequest;
        }

        public String getModel() {
            return this.model;
        }

        public List<LlmCompletionFunc.CompletionMessage> getMessages() {
            return this.messages;
        }

        public String getFormat() {
            return this.format;
        }

        public boolean isStream() {
            return this.stream;
        }

        public LlmCompletionFunc.Options getOptions() {
            return this.options;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public void setMessages(List<LlmCompletionFunc.CompletionMessage> messages) {
            this.messages = messages;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public void setStream(boolean stream) {
            this.stream = stream;
        }

        public void setOptions(LlmCompletionFunc.Options options) {
            this.options = options;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OllamaRequest)) {
                return false;
            }
            OllamaRequest other = (OllamaRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isStream() != other.isStream()) {
                return false;
            }
            String this$model = this.getModel();
            String other$model = other.getModel();
            if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
                return false;
            }
            List<LlmCompletionFunc.CompletionMessage> this$messages = this.getMessages();
            List<LlmCompletionFunc.CompletionMessage> other$messages = other.getMessages();
            if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
                return false;
            }
            String this$format = this.getFormat();
            String other$format = other.getFormat();
            if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
                return false;
            }
            LlmCompletionFunc.Options this$options = this.getOptions();
            LlmCompletionFunc.Options other$options = other.getOptions();
            return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OllamaRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isStream() ? 79 : 97);
            String $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            List<LlmCompletionFunc.CompletionMessage> $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            String $format = this.getFormat();
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            LlmCompletionFunc.Options $options = this.getOptions();
            result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
            return result;
        }

        public String toString() {
            return "OllamaCompletionFunc.OllamaRequest(model=" + this.getModel() + ", messages=" + String.valueOf(this.getMessages()) + ", format=" + this.getFormat() + ", stream=" + this.isStream() + ", options=" + String.valueOf(this.getOptions()) + ")";
        }
    }

    public static class OllamaOptions
    extends LlmCompletionFunc.Options {
        private Integer num_predict;

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OllamaOptions)) {
                return false;
            }
            OllamaOptions other = (OllamaOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$num_predict = this.getNum_predict();
            Integer other$num_predict = other.getNum_predict();
            return !(this$num_predict == null ? other$num_predict != null : !((Object)this$num_predict).equals(other$num_predict));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof OllamaOptions;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $num_predict = this.getNum_predict();
            result = result * 59 + ($num_predict == null ? 43 : ((Object)$num_predict).hashCode());
            return result;
        }

        public Integer getNum_predict() {
            return this.num_predict;
        }

        public void setNum_predict(Integer num_predict) {
            this.num_predict = num_predict;
        }

        @Override
        public String toString() {
            return "OllamaCompletionFunc.OllamaOptions(num_predict=" + this.getNum_predict() + ")";
        }
    }
}

