/*
 * Decompiled with CFR 0.152.
 */
package io.github.shangor.llm.impl;

import io.github.shangor.llm.EmbeddingFunc;
import io.github.shangor.llm.service.HttpService;
import io.github.shangor.util.TimeKeeper;
import jakarta.annotation.Resource;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"llm.embedding.provider"}, havingValue="ollama")
public class OllamaEmbeddingFunc
implements EmbeddingFunc {
    private static final Logger log = LoggerFactory.getLogger(OllamaEmbeddingFunc.class);
    @Value(value="${llm.embedding.model}")
    private String model;
    @Value(value="${llm.embedding.url:http://localhost:11434/api/embed}")
    private URI url;
    @Resource
    private HttpService httpService;
    private Map<String, String> headers = Map.of("Content-Type", "application/json");
    @Value(value="${llm.embedding.dimension}")
    private int dimension;
    @Value(value="${llm.embedding.max-token-size}")
    private int maxTokenSize;
    @Value(value="${llm.embedding.concurrent-limit:16}")
    private int concurrentLimit;

    @Override
    public float[] convert(String input) {
        return this.convert(input, this.model);
    }

    @Override
    public float[] convert(String input, String model) {
        Map<String, Object> body = Map.of("model", model, "input", input);
        log.info("ollama embedding request: {} - {}", (Object)this.url, body);
        TimeKeeper tk = TimeKeeper.start();
        OllamaEmbeddingResult resp = this.httpService.post(this.url, this.headers, body, OllamaEmbeddingResult.class);
        log.info("ollama embedding completed in {} seconds", (Object)tk.elapsedSeconds());
        return resp.getEmbeddings()[0];
    }

    public String getModel() {
        return this.model;
    }

    public URI getUrl() {
        return this.url;
    }

    public HttpService getHttpService() {
        return this.httpService;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public int getMaxTokenSize() {
        return this.maxTokenSize;
    }

    @Override
    public int getConcurrentLimit() {
        return this.concurrentLimit;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void setMaxTokenSize(int maxTokenSize) {
        this.maxTokenSize = maxTokenSize;
    }

    public void setConcurrentLimit(int concurrentLimit) {
        this.concurrentLimit = concurrentLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OllamaEmbeddingFunc)) {
            return false;
        }
        OllamaEmbeddingFunc other = (OllamaEmbeddingFunc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDimension() != other.getDimension()) {
            return false;
        }
        if (this.getMaxTokenSize() != other.getMaxTokenSize()) {
            return false;
        }
        if (this.getConcurrentLimit() != other.getConcurrentLimit()) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        URI this$url = this.getUrl();
        URI other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        HttpService this$httpService = this.getHttpService();
        HttpService other$httpService = other.getHttpService();
        if (this$httpService == null ? other$httpService != null : !this$httpService.equals(other$httpService)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OllamaEmbeddingFunc;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDimension();
        result = result * 59 + this.getMaxTokenSize();
        result = result * 59 + this.getConcurrentLimit();
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        URI $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        HttpService $httpService = this.getHttpService();
        result = result * 59 + ($httpService == null ? 43 : $httpService.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    public String toString() {
        return "OllamaEmbeddingFunc(model=" + this.getModel() + ", url=" + String.valueOf(this.getUrl()) + ", httpService=" + String.valueOf(this.getHttpService()) + ", headers=" + String.valueOf(this.getHeaders()) + ", dimension=" + this.getDimension() + ", maxTokenSize=" + this.getMaxTokenSize() + ", concurrentLimit=" + this.getConcurrentLimit() + ")";
    }

    public static class OllamaEmbeddingResult {
        private String model;
        private float[][] embeddings;
        private long total_duration;
        private long load_duration;
        private long prompt_eval_count;

        public String getModel() {
            return this.model;
        }

        public float[][] getEmbeddings() {
            return this.embeddings;
        }

        public long getTotal_duration() {
            return this.total_duration;
        }

        public long getLoad_duration() {
            return this.load_duration;
        }

        public long getPrompt_eval_count() {
            return this.prompt_eval_count;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public void setEmbeddings(float[][] embeddings) {
            this.embeddings = embeddings;
        }

        public void setTotal_duration(long total_duration) {
            this.total_duration = total_duration;
        }

        public void setLoad_duration(long load_duration) {
            this.load_duration = load_duration;
        }

        public void setPrompt_eval_count(long prompt_eval_count) {
            this.prompt_eval_count = prompt_eval_count;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OllamaEmbeddingResult)) {
                return false;
            }
            OllamaEmbeddingResult other = (OllamaEmbeddingResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTotal_duration() != other.getTotal_duration()) {
                return false;
            }
            if (this.getLoad_duration() != other.getLoad_duration()) {
                return false;
            }
            if (this.getPrompt_eval_count() != other.getPrompt_eval_count()) {
                return false;
            }
            String this$model = this.getModel();
            String other$model = other.getModel();
            if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
                return false;
            }
            return Arrays.deepEquals((Object[])this.getEmbeddings(), (Object[])other.getEmbeddings());
        }

        protected boolean canEqual(Object other) {
            return other instanceof OllamaEmbeddingResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $total_duration = this.getTotal_duration();
            result = result * 59 + (int)($total_duration >>> 32 ^ $total_duration);
            long $load_duration = this.getLoad_duration();
            result = result * 59 + (int)($load_duration >>> 32 ^ $load_duration);
            long $prompt_eval_count = this.getPrompt_eval_count();
            result = result * 59 + (int)($prompt_eval_count >>> 32 ^ $prompt_eval_count);
            String $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            result = result * 59 + Arrays.deepHashCode((Object[])this.getEmbeddings());
            return result;
        }

        public String toString() {
            return "OllamaEmbeddingFunc.OllamaEmbeddingResult(model=" + this.getModel() + ", embeddings=" + Arrays.deepToString((Object[])this.getEmbeddings()) + ", total_duration=" + this.getTotal_duration() + ", load_duration=" + this.getLoad_duration() + ", prompt_eval_count=" + this.getPrompt_eval_count() + ")";
        }
    }
}

