/*
 * Decompiled with CFR 0.152.
 */
package io.github.shangor.llm.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.shangor.llm.LlmCompletionFunc;
import io.github.shangor.llm.pojo.OpenAiLlmResult;
import io.github.shangor.llm.pojo.OpenAiLlmStreamResult;
import io.github.shangor.llm.service.HttpService;
import io.github.shangor.util.DateTimeUtils;
import io.github.shangor.util.GenUtils;
import io.github.shangor.util.TimeKeeper;
import jakarta.annotation.Resource;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

@Service
@ConditionalOnProperty(value={"rag.llm.completion.provider"}, havingValue="zhipu")
public class ZhipuCompletionFunc
extends LlmCompletionFunc {
    private static final Logger log = LoggerFactory.getLogger(ZhipuCompletionFunc.class);
    @Value(value="${rag.llm.completion.model}")
    private String model;
    @Value(value="${rag.llm.completion.url:https://open.bigmodel.cn/api/paas/v4/chat/completions}")
    private URI url;
    private final Map<String, String> headers;
    @Resource
    private ObjectMapper objectMapper;
    @Resource
    HttpService httpService;
    public static Pattern KW_JSON_PATTERN = Pattern.compile("\\{[\\s\\S]*}");

    public ZhipuCompletionFunc(@Value(value="${rag.llm.completion.api-key}") String apiKey) {
        this.headers = Map.of("Authorization", "Bearer " + apiKey, "Content-Type", "application/json");
    }

    @Override
    public OpenAiLlmResult complete(List<LlmCompletionFunc.CompletionMessage> messages, LlmCompletionFunc.Options options) {
        log.info("Zhipu request with messages list {}", (Object)messages.size());
        TimeKeeper tk = TimeKeeper.start();
        OpenAiLlmResult result = this.httpService.post(this.url, this.headers, Map.of("model", LlmCompletionFunc.getModel(options, this.model), "messages", messages, "temperature", options.getTemperature(), "stream", options.isStream()), OpenAiLlmResult.class);
        log.info("Zhipu response from {} in {} seconds", (Object)this.url, (Object)tk.elapsedSeconds());
        return result;
    }

    @Override
    public Flux<ServerSentEvent<OpenAiLlmStreamResult>> completeStream(List<LlmCompletionFunc.CompletionMessage> messages, LlmCompletionFunc.Options options) {
        log.info("Zhipu request with messages list {}", (Object)messages.size());
        AtomicReference<String> requestId = new AtomicReference<String>("");
        AtomicReference<Object> usage = new AtomicReference<Object>(null);
        return this.httpService.postSeverSentEvent(this.url, this.headers, Map.of("model", LlmCompletionFunc.getModel(options, this.model), "messages", messages, "temperature", options.getTemperature(), "stream", true), false).mapNotNull(sse -> {
            String data = (String)sse.data();
            if ("[DONE]".equals(data)) {
                return null;
            }
            return GenUtils.jsonToObject(data, OpenAiLlmStreamResult.class);
        }).map(s -> ServerSentEvent.builder((Object)s).id((String)requestId.get()).event("llm").build());
    }

    public static String convertCreated(long epochTimeAtSeconds) {
        LocalDateTime time = LocalDateTime.ofEpochSecond(epochTimeAtSeconds, 0, ZoneOffset.UTC);
        return DateTimeUtils.STD_GMT_FMT.format(time);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZhipuCompletionFunc)) {
            return false;
        }
        ZhipuCompletionFunc other = (ZhipuCompletionFunc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        URI this$url = this.getUrl();
        URI other$url = other.getUrl();
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        if (this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper)) {
            return false;
        }
        HttpService this$httpService = this.getHttpService();
        HttpService other$httpService = other.getHttpService();
        return !(this$httpService == null ? other$httpService != null : !this$httpService.equals(other$httpService));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ZhipuCompletionFunc;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        URI $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        HttpService $httpService = this.getHttpService();
        result = result * 59 + ($httpService == null ? 43 : $httpService.hashCode());
        return result;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public URI getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public HttpService getHttpService() {
        return this.httpService;
    }

    @Override
    public void setModel(String model) {
        this.model = model;
    }

    @Override
    public void setUrl(URI url) {
        this.url = url;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    @Override
    public String toString() {
        return "ZhipuCompletionFunc(model=" + this.getModel() + ", url=" + String.valueOf(this.getUrl()) + ", headers=" + String.valueOf(this.getHeaders()) + ", objectMapper=" + String.valueOf(this.getObjectMapper()) + ", httpService=" + String.valueOf(this.getHttpService()) + ")";
    }
}

