/*
 * Decompiled with CFR 0.152.
 */
package io.github.shangor.llm.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.shangor.llm.service.HttpService;
import io.github.shangor.util.GenUtils;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultHttpServiceImpl
implements HttpService {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpServiceImpl.class);
    private final ObjectMapper objectMapper;
    private final HttpClient client = HttpClient.newHttpClient();
    private final WebClient asyncClient = WebClient.builder().build();
    private static final ParameterizedTypeReference<ServerSentEvent<String>> SSE_TYPE = new ParameterizedTypeReference<ServerSentEvent<String>>(){};

    @Override
    public <T> T post(URI url, Map<String, String> headers, Map<String, Object> requestBody, Class<T> clazz) {
        try {
            HttpRequest post;
            HttpResponse<String> response;
            String body = this.objectMapper.writeValueAsString(requestBody);
            HttpRequest.Builder postBuilder = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(body, StandardCharsets.UTF_8)).uri(url);
            if (!GenUtils.isEmptyCollection(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    postBuilder.header(entry.getKey(), entry.getValue());
                }
            }
            if ((response = this.client.send(post = postBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode() >= 200 && response.statusCode() < 300) {
                return (T)this.objectMapper.readValue(response.body(), clazz);
            }
            throw new RuntimeException("Failed to complete the %s: %d - %s!".formatted(clazz.getName(), response.statusCode(), response.body()));
        }
        catch (IOException | InterruptedException e) {
            log.error("Failed to complete the {}: {}", (Object)clazz.getName(), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> Mono<T> postAsync(URI url, Map<String, String> headers, Object requestBody, Class<T> clazz) {
        WebClient.RequestBodySpec builder = (WebClient.RequestBodySpec)this.asyncClient.post().uri(url);
        if (!GenUtils.isEmptyCollection(headers)) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.header(entry.getKey(), new String[]{entry.getValue()});
            }
        }
        return builder.bodyValue(requestBody).retrieve().bodyToMono(clazz);
    }

    @Override
    public Flux<ServerSentEvent<String>> postSeverSentEvent(URI url, Map<String, String> headers, Object requestBody, boolean raw) {
        WebClient.RequestBodySpec builder = (WebClient.RequestBodySpec)this.asyncClient.post().uri(url);
        if (!GenUtils.isEmptyCollection(headers)) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.header(entry.getKey(), new String[]{entry.getValue()});
            }
            builder.header("Accept", new String[]{"text/event-stream"});
            builder.header("Cache-Control", new String[]{"no-cache"});
            builder.header("Connection", new String[]{"keep-alive"});
            builder.header("Content-Type", new String[]{"text/stream-event;charset=utf-8"});
        }
        if (raw) {
            return builder.bodyValue(requestBody).retrieve().bodyToFlux(String.class).map(s -> ServerSentEvent.builder((Object)s).build());
        }
        return builder.bodyValue(requestBody).retrieve().bodyToFlux(SSE_TYPE);
    }

    public DefaultHttpServiceImpl(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

