package shz;

import java.io.File;
import java.net.URL;
import java.util.*;
import java.util.concurrent.ForkJoinPool;

public final class DllHelp {
    private DllHelp() {
        throw new IllegalStateException();
    }

    public static void load(String path, boolean tryFind, long timeout) {
        Optional.ofNullable(FileHelp.findFile(path, tryFind, null, null,
                timeout <= 0L ? null : ForkJoinPool.commonPool(), timeout))
                .ifPresent(f -> load0(f.getAbsolutePath()));
    }

    private static boolean load0(String path) {
        boolean flag = true;
        try {
            System.load(path);
        } catch (Throwable t) {
            flag = false;
        }
        return flag;
    }

    public static void load(String path) {
        load(path, true, 0L);
    }

    public static void load(Set<String> paths, boolean tryFind, long timeout) {
        Optional.ofNullable(FileHelp.findFiles(paths, tryFind, false, null, null,
                timeout <= 0L ? null : ForkJoinPool.commonPool(), timeout))
                .ifPresent(fs -> load0(ToSet.collect(fs.stream().map(File::getAbsolutePath))));
    }

    private static void load0(Collection<String> paths) {
        List<String> errors = ToList.collect(paths.stream().filter(s -> !load0(s)));
        if (!errors.isEmpty() && errors.size() != paths.size()) load0(errors);
    }

    public static void load(Set<String> paths) {
        load(paths, true, 0L);
    }

    public static void loadFromFolder(String path, boolean tryFind, boolean iteration, long timeout) {
        File findFile = FileHelp.findFile(path, tryFind, null, null, timeout <= 0L ? null : ForkJoinPool.commonPool(), timeout);
        if (findFile != null && findFile.isDirectory()) {
            if (iteration) load0(getFromFolder(findFile, new LinkedList<>()));
            else
                Optional.ofNullable(findFile.listFiles(File::isFile)).ifPresent(
                        fs -> load0(ToSet.collect(Arrays.stream(fs).parallel().filter(f -> f.getName().toLowerCase().endsWith(".dll")).map(File::getAbsolutePath)))
                );
        }
    }

    private static List<String> getFromFolder(File folder, List<String> list) {
        Optional.ofNullable(folder.listFiles()).ifPresent(fs -> Arrays.stream(fs).forEach(f -> {
            if (f.isDirectory()) getFromFolder(f, list);
            else if (f.getName().toLowerCase().endsWith(".dll")) list.add(f.getAbsolutePath());
        }));
        return list;
    }

    public static void loadFromFolder(String path) {
        loadFromFolder(path, true, true, 0L);
    }

    public static void loadFromURL(URL url, boolean tryFind, boolean regex, Set<String> paths, long timeout) {
        Optional.ofNullable(FileHelp.findFilesFromURL(url, tryFind, regex, paths, timeout)).ifPresent(
                fs -> load0(ToSet.collect(fs.stream().map(File::getAbsolutePath)))
        );
    }

    public static void loadFromURL(Set<String> paths) {
        loadFromURL(null, true, false, paths, 0L);
    }
}