package shz;

import shz.msg.ServerFailure;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Function;

@SuppressWarnings("unchecked")
public final class InterfaceProxy implements InvocationHandler {
    public static final class InterfaceProxyInvokeParam {
        private final Object proxy;
        private final Method method;
        private final Object[] args;

        public Object getProxy() {
            return proxy;
        }

        public Method getMethod() {
            return method;
        }

        public Object[] getArgs() {
            return args;
        }

        InterfaceProxyInvokeParam(Object proxy, Method method, Object[] args) {
            this.proxy = proxy;
            this.method = method;
            this.args = args;
        }
    }

    private final Function<InterfaceProxyInvokeParam, ?> executor;

    private InterfaceProxy(Function<InterfaceProxyInvokeParam, ?> executor) {
        this.executor = executor;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (method.getDeclaringClass() == Object.class) {
            switch (method.getName()) {
                case "hashCode":
                    return 0;
                case "toString":
                    return "";
                case "equals":
                    return false;
                case "getClass":
                case "notify":
                case "notifyAll":
                case "wait":
                case "clone":
                case "finalize":
                    return null;
            }
        }
        Object invoke = executor.apply(new InterfaceProxyInvokeParam(proxy, method, args));
        if (method.getReturnType() == void.class || method.getReturnType() == Void.class) return null;
        ServerFailure.NoSuchMethodException.requireNon(invoke == null && method.getReturnType().isPrimitive());
        if (invoke == null) return null;
        ServerFailure.NoSuchMethodException.requireNon(!AccessibleHelp.canCast(invoke.getClass(), method.getReturnType()));
        return invoke;
    }

    public static <T> T getProxy(Class<T> cls, Function<InterfaceProxyInvokeParam, ?> executor, boolean save) {
        Class<?>[] interfaces;
        Validator.requireNon(Validator.isEmpty(interfaces = cls.getInterfaces()) && !cls.isInterface());
        if (save) System.getProperties().setProperty("sun.misc.ProxyGenerator.saveGeneratedFiles", "true");
        return (T) Proxy.newProxyInstance(
                Thread.currentThread().getContextClassLoader(),
                cls.isInterface() ? new Class[]{cls} : interfaces,
                new InterfaceProxy(executor)
        );
    }

    public static <T> T getProxy(Class<T> cls, Function<InterfaceProxyInvokeParam, ?> executor) {
        return getProxy(cls, executor, false);
    }
}