package shz;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.text.Collator;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@SuppressWarnings("unchecked")
public final class PropHelp {
    private PropHelp() {
        throw new IllegalStateException();
    }

    public static Properties getProp(InputStream is) {
        Properties prop = new Properties();
        try {
            prop.load(is);
        } catch (IOException e) {
            throw PRException.of(e);
        } finally {
            IOHelp.close(is);
        }
        Properties result = new Properties();
        Enumeration<?> en = prop.propertyNames();
        String key;
        while (en.hasMoreElements()) {
            key = (String) en.nextElement();
            String val = prop.getProperty(key);
            if (Validator.nonBlank(val)) result.setProperty(key, val);
        }
        return result;
    }

    static final class PropSetFieldStrategy extends ToObject.SetFieldStrategy {
        @Override
        public Function<Field, BiFunction<Function<Field, String>, Class<?>, Collection<?>>> supCollection() {
            return t -> (u, r) -> {
                String m = u.apply(t);
                if (Validator.isBlank(m)) return Collections.emptySet();
                return ToSet.collect(keys(t).stream().filter(Objects::nonNull).filter(k -> k.startsWith(m)).map(k -> executor(m, r)).filter(Objects::nonNull), true);
            };
        }

        @Override
        public Function<Field, BiFunction<Function<Field, String>, Class<?>[], Map<?, ?>>> supMap() {
            return t -> (u, r) -> {
                String m = u.apply(t);
                if (Validator.isBlank(m)) return Collections.emptyMap();
                return ToMap.collect(keys(t).stream().filter(Objects::nonNull).filter(k -> k.startsWith(m)), k -> executor(m, r[0]), k -> executor(m, r[1]), true);
            };
        }

        @Override
        public Function<Field, BiFunction<Function<Field, String>, Class<?>, Object>> supObject() {
            return t -> (u, r) -> {
                String m = u.apply(t);
                if (Validator.isBlank(m)) return null;
                return keys(t).stream().filter(Objects::nonNull).anyMatch(k -> k.startsWith(m)) ? executor(m, r) : null;
            };
        }

        Map<String, String> map;

        @Override
        protected Collection<String> keys(Field field) {
            return map.keySet();
        }

        @Override
        protected Object executor(String key, Class<?> cls) {
            return ToObject.fromMap(cls, map, f -> key + "." + f.getName(), Function.identity(), this);
        }

        <T> T fromMap(Class<? extends T> cls, Map<String, String> map) {
            this.map = map;
            return ToObject.fromMap(cls, map, Field::getName, Function.identity(), this);
        }

        <T> T fromMap(T t, Map<String, String> map) {
            this.map = map;
            return ToObject.fromMap(t, map, Field::getName, Function.identity(), this);
        }
    }

    private static final PropSetFieldStrategy STRATEGY = new PropSetFieldStrategy();

    public static <T> T toObject(Class<? extends T> cls, Map<String, String> map) {
        return ((PropSetFieldStrategy) STRATEGY.clone()).fromMap(cls, map);
    }

    public static <T> T toObject(T t, Map<String, String> map) {
        return ((PropSetFieldStrategy) STRATEGY.clone()).fromMap(t, map);
    }

    public static <T> T toObject(Class<? extends T> cls, Properties prop) {
        return toObject(cls, propToMap(prop));
    }

    private static Map<String, String> propToMap(Properties prop) {
        if (prop == null) return Collections.emptyMap();
        Enumeration<?> en = prop.propertyNames();
        String key;
        Map<String, String> map = new HashMap<>();
        while (en.hasMoreElements()) {
            key = (String) en.nextElement();
            map.put(key, prop.getProperty(key));
        }
        return map;
    }

    public static <T> T toObject(T t, Properties prop) {
        return toObject(t, propToMap(prop));
    }

    public static <T> List<T> toObjects(Class<? extends T> cls, List<Map<String, String>> maps) {
        if (Validator.isEmpty(maps)) return Collections.emptyList();
        PropSetFieldStrategy strategy = (PropSetFieldStrategy) STRATEGY.clone();
        return ToList.explicitCollect(maps.stream().map(map -> strategy.fromMap(cls, map)), maps.size());
    }

    private static final Map<Class<?>, Map<String, Class<?>>> FIELD_CLASS_MAP_CACHE = new ConcurrentHashMap<>(128);

    public static Map<String, Class<?>> fieldClassMap(Class<?> cls) {
        return FIELD_CLASS_MAP_CACHE.computeIfAbsent(cls, k -> {
            Map<String, Class<?>> result = new HashMap<>();
            fieldClassMap0(result, cls, "");
            return result.isEmpty() ? Collections.emptyMap() : ToMap.get(result.size()).put(result).build();
        });
    }

    private static void fieldClassMap0(Map<String, Class<?>> map, Class<?> cls, String mapField) {
        AccessibleHelp.fields(cls).forEach(f -> {
            if (AccessibleHelp.isCommon(f.getType())) map.put(mapField + f.getName(), cls);
            else fieldClassMap0(map, f.getType(), mapField + f.getName() + ".");
        });
    }

    public static Map<String, String> fieldValueMap(Object obj, Predicate<Field> predicate, String mapField) {
        if (obj == null) return Collections.emptyMap();
        Map<String, String> map;
        if (Validator.isEmpty(mapField)) {
            Class<?> cls = obj.getClass();
            if (AccessibleHelp.isCommon(cls) || obj instanceof Collection || obj instanceof Object[])
                return Collections.emptyMap();

            map = new HashMap<>();
            if (obj instanceof Map)
                ((Map<String, ?>) obj).forEach((k, v) -> fieldValueMap0(map, v, predicate, k));
            else AccessibleHelp.fields(cls).forEach(f -> {
                if (predicate != null && !predicate.test(f)) return;
                fieldValueMap0(map, AccessibleHelp.getField(f, obj), predicate, f.getName());
            });
        } else {
            map = new HashMap<>();
            fieldValueMap0(map, obj, predicate, mapField);
        }
        return map.isEmpty() ? Collections.emptyMap() : ToMap.get(map.size()).put(map).build();
    }

    private static void fieldValueMap0(Map<String, String> map, Object obj, Predicate<Field> predicate, String mapField) {
        if (obj == null) return;
        Class<?> cls = obj.getClass();
        if (AccessibleHelp.isCommon(cls)) map.put(mapField, obj.toString());
        else if (obj instanceof Map)
            ((Map<String, ?>) obj).forEach((k, v) -> fieldValueMap0(map, v, predicate, mapField + "." + k));
        else if (obj instanceof Collection) {
            Collection<?> collection = (Collection<?>) obj;
            map.put(mapField, joining(ToList.explicitCollect(collection.stream().map(e -> trans(e, predicate)), collection.size())));
        } else if (obj instanceof Object[]) {
            Object[] array = (Object[]) obj;
            map.put(mapField, joining(ToList.explicitCollect(Arrays.stream(array).map(e -> trans(e, predicate)), array.length)));
        } else AccessibleHelp.fields(cls).forEach(f -> {
            if (predicate != null && !predicate.test(f)) return;
            fieldValueMap0(map, AccessibleHelp.getField(f, obj), predicate, mapField + "." + f.getName());
        });
    }

    private static String trans(Object val, Predicate<Field> predicate) {
        if (val == null) return "";
        Class<?> cls = val.getClass();
        if (AccessibleHelp.isCommon(cls)) return val.toString();
        if (val instanceof Map) {
            Map<String, String> map = new HashMap<>();
            ((Map<String, ?>) val).forEach((k, v) -> fieldValueMap0(map, v, predicate, k));
            return joining(map);
        }
        if (val instanceof Collection) {
            Collection<?> collection = (Collection<?>) val;
            return joining(ToList.explicitCollect(collection.stream().map(e -> trans(e, predicate)), collection.size()));
        }
        if (val instanceof Object[]) {
            Object[] array = (Object[]) val;
            return joining(ToList.explicitCollect(Arrays.stream(array).map(e -> trans(e, predicate)), array.length));
        }
        Map<String, String> map = new HashMap<>();
        AccessibleHelp.fields(cls).forEach(f -> {
            if (predicate != null && !predicate.test(f)) return;
            fieldValueMap0(map, AccessibleHelp.getField(f, val), predicate, f.getName());
        });
        return joining(map);
    }

    private static String joining(Map<String, String> map) {
        if (map.isEmpty()) return "";
        List<String> list = new ArrayList<>(map.keySet());
        list.sort(Collator.getInstance(Locale.CHINA));
        StringBuilder sb = new StringBuilder();
        String key = list.get(0);
        sb.append("[").append(key).append(":").append(map.get(key));
        for (int i = 1; i < list.size(); ++i) {
            key = list.get(i);
            sb.append(",").append(key).append(":").append(map.get(key));
        }
        sb.append("]");
        return sb.toString();
    }

    private static String joining(List<String> list) {
        if (list.isEmpty()) return "";
        list.sort(Collator.getInstance(Locale.CHINA));
        return list.stream().collect(Collectors.joining(",", "[", "]"));
    }

    public static Map<String, String> fieldValueMap(Object obj, Predicate<Field> predicate) {
        return fieldValueMap(obj, predicate, "");
    }

    public static Map<String, String> fieldValueMap(Object obj) {
        return fieldValueMap(obj, null, "");
    }
}