package shz;

import shz.constant.NullConstant;
import shz.enums.IEnum;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

@SuppressWarnings({"restriction", "unchecked"})
public final class ToObject {
    private ToObject() {
        throw new IllegalStateException();
    }

    public static abstract class SetFieldStrategy implements Cloneable {
        public abstract Function<Field, BiFunction<Function<Field, String>, Class<?>, Collection<?>>> supCollection();

        public abstract Function<Field, BiFunction<Function<Field, String>, Class<?>[], Map<?, ?>>> supMap();

        public abstract Function<Field, BiFunction<Function<Field, String>, Class<?>, Object>> supObject();

        protected abstract Collection<String> keys(Field field);

        protected abstract Object executor(String key, Class<?> cls);

        @Override
        public Object clone() {
            try {
                return super.clone();
            } catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    public static <T> T fromMap(T t, Map<String, ?> map, Function<Field, String> keyTrans, Function<Object, Object> valueTrans, SetFieldStrategy strategy) {
        if (t == null || Validator.isEmpty(map)) return null;
        AccessibleHelp.fields(t.getClass()).parallelStream().forEach(f -> setField(f, t, map.get(keyTrans.apply(f)), keyTrans, valueTrans, strategy));
        return t;
    }

    public static <T> void setField(Field field, T t, Object value, Function<Field, String> keyTrans, Function<Object, Object> valueTrans, SetFieldStrategy strategy) {
        value = valueTrans.apply(value);

        if (value != null && field.getType().isAssignableFrom(value.getClass())) {
            AccessibleHelp.setField(field, t, value);
            return;
        }
        Object obj;
        if ((obj = parse(value, field.getType())) == null && strategy == null) return;
        if (obj != null && obj != NullConstant.OBJECT) {
            AccessibleHelp.setField(field, t, obj);
            return;
        }
        if (strategy == null) return;
        if (Collection.class.isAssignableFrom(field.getType())) {
            Type[] types;
            if ((types = AccessibleHelp.getTypes(field)) == null || types.length != 1) return;
            Class<?> cls;
            if ((cls = AccessibleHelp.typeToClass(types[0])) == null) return;
            Function<Field, BiFunction<Function<Field, String>, Class<?>, Collection<?>>> supCollection;
            BiFunction<Function<Field, String>, Class<?>, Collection<?>> supApply;
            if ((supCollection = strategy.supCollection()) == null || (supApply = supCollection.apply(field)) == null)
                return;
            Collection<?> collection;
            if (Validator.nonEmpty(collection = supApply.apply(keyTrans, cls)))
                AccessibleHelp.setField(field, t, collection);
            return;
        }
        if (Map.class.isAssignableFrom(field.getType())) {
            Type[] types;
            if ((types = AccessibleHelp.getTypes(field)) == null || types.length != 2) return;
            Class<?>[] classes;
            if ((classes = AccessibleHelp.typeToClass(types))[0] == null || classes[1] == null) return;
            Function<Field, BiFunction<Function<Field, String>, Class<?>[], Map<?, ?>>> supMap;
            BiFunction<Function<Field, String>, Class<?>[], Map<?, ?>> supApply;
            if ((supMap = strategy.supMap()) == null || (supApply = supMap.apply(field)) == null) return;
            Map<?, ?> map;
            if (Validator.nonEmpty(map = supApply.apply(keyTrans, classes))) AccessibleHelp.setField(field, t, map);
            return;
        }
        Function<Field, BiFunction<Function<Field, String>, Class<?>, Object>> supObject;
        BiFunction<Function<Field, String>, Class<?>, Object> supApply;
        if ((supObject = strategy.supObject()) == null || (supApply = supObject.apply(field)) == null)
            return;
        if ((obj = supApply.apply(keyTrans, field.getType())) != null) AccessibleHelp.setField(field, t, obj);
    }

    public static Object parse(Object value, Class<?> cls) {
        if (value == null || cls == null) return null;
        String s = value.toString();
        if (Enum.class.isAssignableFrom(cls)) {
            List<?> enums;
            if ((enums = AccessibleHelp.enumSet(cls)).isEmpty()) return null;
            if (IEnum.class.isAssignableFrom(cls)) {
                IEnum<?, ?> c = null, v = null;
                for (Object obj : enums) {
                    IEnum<?, ?> e = (IEnum<?, ?>) obj;
                    if (s.equalsIgnoreCase(e.name())) return e;
                    if (c == null) if (s.equals(e.getCode())) c = e;
                    if (v == null) if (s.equals(e.getValue())) v = e;
                }
                return c == null ? v : c;
            }
            return enums.stream().map(e -> (Enum<?>) e).filter(e -> e.name().equalsIgnoreCase(s)).findFirst().orElse(null);
        }
        String typeName = cls.getTypeName();
        try {
            switch (typeName) {
                case "java.lang.String":
                    return s;
                case "java.lang.Boolean":
                    if (s.equals("0")) return Boolean.FALSE;
                    if (s.equals("1")) return Boolean.TRUE;
                    return Boolean.valueOf(s);
                case "boolean":
                    if (s.equals("0")) return false;
                    if (s.equals("1")) return true;
                    return Boolean.parseBoolean(s);
                case "java.lang.Byte":
                    return Byte.valueOf(s);
                case "byte":
                    return Byte.parseByte(s);
                case "java.lang.Character":
                case "char":
                    return s.length() > 0 ? s.charAt(0) : '\0';
                case "java.lang.Short":
                    return Short.valueOf(s);
                case "short":
                    return Short.parseShort(s);
                case "java.lang.Integer":
                    return Integer.valueOf(s);
                case "int":
                    return Integer.parseInt(s);
                case "java.lang.Long":
                    return Long.valueOf(s);
                case "long":
                    return Long.parseLong(s);
                case "java.lang.Double":
                case "double":
                    return Double.parseDouble(s);
                case "java.lang.Float":
                case "float":
                    return Float.parseFloat(s);
                case "java.math.BigInteger":
                    return new BigInteger(s);
                case "java.math.BigDecimal":
                    return new BigDecimal(s);
                case "java.time.Instant":
                    return TimeHelp.toInstant(value);
                case "java.time.LocalDateTime":
                    return TimeHelp.toLdt(value);
                case "java.time.ZonedDateTime":
                    return TimeHelp.toZdt(value);
                case "java.util.Date":
                    return TimeHelp.toDate(value);
                case "java.time.LocalDate":
                    LocalDateTime ldt = TimeHelp.toLdt(value);
                    return ldt == null ? null : ldt.toLocalDate();
                case "java.time.LocalTime":
                    return TimeHelp.toLt(value);
                default:
                    return NullConstant.OBJECT;
            }
        } catch (Throwable ignored) {
            return null;
        }
    }

    public static <T> T cast(Object value, Class<? extends T> cls) {
        if (cls == null) return null;
        if (cls.isInstance(value)) return (T) value;
        Object parse = parse(value, cls);
        if (parse == null || parse == NullConstant.OBJECT) return null;
        return (T) parse;
    }

    public static <T> T fromMap(T t, Map<String, ?> map) {
        return fromMap(t, map, Field::getName, Function.identity(), null);
    }

    public static <T> T fromMap(Class<? extends T> cls, Map<String, ?> map, Function<Field, String> keyTrans, Function<Object, Object> valueTrans, SetFieldStrategy strategy) {
        if (cls == null || Validator.isEmpty(map)) return null;
        if (AccessibleHelp.isCommon(cls)) return (T) parse(map.values().iterator().next(), cls);
        if (keyTrans == null || valueTrans == null) return null;
        T t = AccessibleHelp.newObject(cls);
        if (t == null) return null;
        AccessibleHelp.fields(cls).parallelStream().forEach(f -> setField(f, t, map.get(keyTrans.apply(f)), keyTrans, valueTrans, strategy));
        return t;
    }

    public static <T> T fromMap(Class<? extends T> cls, Map<String, ?> map) {
        return fromMap(cls, map, Field::getName, Function.identity(), null);
    }

    public static <T> List<T> fromMaps(Class<? extends T> cls, List<Map<String, ?>> maps, Function<Field, String> keyTrans, Function<Object, Object> valueTrans, SetFieldStrategy strategy) {
        if (Validator.isAnyNull(cls, keyTrans, valueTrans) || Validator.isEmpty(maps)) return Collections.emptyList();
        return ToList.explicitCollect(maps.stream().map(map -> fromMap(cls, map, keyTrans, valueTrans, strategy)), maps.size());
    }

    public static <T> List<T> fromMaps(Class<? extends T> cls, List<Map<String, ?>> maps) {
        return fromMaps(cls, maps, Field::getName, Function.identity(), null);
    }

    public static <T> T copyProperty(Object src, T des, Predicate<String> predicate) {
        if (des == null) return null;
        if (src == null) return des;
        Map<String, ?> srcMap;
        if (src instanceof Map) {
            Map<String, ?> map0 = (Map<String, ?>) src;
            srcMap = predicate == null ? map0 : ToMap.explicitCollect(map0.keySet().stream().filter(predicate), Function.identity(), map0::get, map0.size());
        } else {
            List<Field> fields = AccessibleHelp.fields(src.getClass(), predicate == null ? f -> true : f -> predicate.test(f.getName()));
            if (fields.isEmpty()) srcMap = Collections.emptyMap();
            else
                srcMap = ToMap.explicitCollect(fields.stream(), Field::getName, f -> AccessibleHelp.getField(f, src), fields.size());
        }

        if (!srcMap.isEmpty())
            fieldMap(des.getClass(), srcMap::containsKey).forEach((k, v) -> setField(v, des, srcMap.get(k), null, Function.identity(), null));

        return des;
    }

    private static final Map<Class<?>, Map<String, Field>> FIELD_MAP_CACHE = new ConcurrentHashMap<>(128);

    public static Map<String, Field> fieldMap(Class<?> cls, Predicate<String> predicate) {
        if (cls == null) return Collections.emptyMap();
        Map<String, Field> fieldMap = FIELD_MAP_CACHE.computeIfAbsent(cls, k -> {
            List<Field> fields = AccessibleHelp.fields(cls);
            if (fields.isEmpty()) return Collections.emptyMap();
            return ToMap.explicitCollect(fields.stream(), Field::getName, Function.identity(), fields.size());
        });
        if (fieldMap.isEmpty()) return Collections.emptyMap();
        Stream<String> stream = fieldMap.keySet().stream();
        if (predicate != null) stream = stream.filter(predicate);
        return ToMap.explicitCollect(stream, Function.identity(), fieldMap::get, fieldMap.size());
    }

    public static Map<String, Field> fieldMap(Class<?> cls) {
        return fieldMap(cls, null);
    }

    public static <T> T copyProperty(Object src, Class<? extends T> des, Predicate<String> predicate) {
        return copyProperty(src, AccessibleHelp.newObject(des), predicate);
    }

    public static <T> T copyProperty(Object src, T des) {
        return copyProperty(src, des, null);
    }

    public static <T> T copyProperty(Object src, Class<? extends T> des) {
        return copyProperty(src, AccessibleHelp.newObject(des), null);
    }

    public static <T> void merge(Collection<T> collection) {
        List<T> list = new LinkedList<>(collection);
        collection.clear();
        int size = list.size();
        for (int i = 1; i < size; ++i) {
            for (int j = i - 1; j > -1; --j) {
                T t1, t2;
                if (i < size && equals(t1 = list.get(j), t2 = list.get(i))) {
                    if (t1 != null) merge0(t1, t2);
                    list.remove(i);
                    --size;
                    ++j;
                }
            }
        }
        collection.addAll(list);
        collection.parallelStream().filter(Objects::nonNull).forEach(t -> AccessibleHelp.fields(t.getClass()).stream()
                .filter(f -> Collection.class.isAssignableFrom(f.getType())).map(f -> (Collection<Object>) AccessibleHelp.getField(f, t))
                .filter(Validator::nonEmpty).forEach(ToObject::merge));
    }

    private static <T> boolean equals(T t1, T t2) {
        if (t1 == null && t2 == null) return true;
        if (t1 == null || t2 == null) return false;
        List<Field> fields = AccessibleHelp.fields(t1.getClass());
        for (Field field : fields) {
            if (Collection.class.isAssignableFrom(field.getType())) continue;
            Object obj1 = AccessibleHelp.getField(field, t1);
            Object obj2 = AccessibleHelp.getField(field, t2);
            if (obj1 == null && obj2 == null) continue;
            if (obj1 == null || obj2 == null || obj1.hashCode() != obj2.hashCode()) return false;
        }
        return true;
    }

    private static <T> void merge0(T t1, T t2) {
        List<Field> fields = AccessibleHelp.fields(t1.getClass());
        for (Field field : fields) {
            if (!Collection.class.isAssignableFrom(field.getType())) continue;
            Collection<Object> c1 = AccessibleHelp.getField(field, t1);
            Collection<Object> c2 = AccessibleHelp.getField(field, t2);
            if (c2 == null) continue;
            if (c1 == null) AccessibleHelp.setField(field, t1, c2);
            else c1.addAll(c2);
        }
    }
}