package shz;

import sun.misc.Unsafe;

import java.lang.reflect.Field;

@SuppressWarnings("restriction")
public final class UnsafeHelp {
    private UnsafeHelp() {
        throw new IllegalStateException();
    }

    private static final Unsafe unsafe;
    private static final int bbase, bscale;
    private static final int cbase, cscale;
    private static final int dbase, dscale;
    private static final int fbase, fscale;
    private static final int ibase, iscale;
    private static final int jbase, jscale;
    private static final int sbase, sscale;
    private static final int zbase, zscale;
    private static final int lbase, lscale;

    static {
        Field unsafeField = Unsafe.class.getDeclaredFields()[0];
        unsafeField.setAccessible(true);
        try {
            unsafe = (Unsafe) unsafeField.get(null);
        } catch (IllegalArgumentException | IllegalAccessException e) {
            throw new Error(e);
        }
        bbase = unsafe.arrayBaseOffset(byte[].class);
        bscale = checkIs2Power(unsafe.arrayIndexScale(int[].class));

        cbase = unsafe.arrayBaseOffset(char[].class);
        cscale = checkIs2Power(unsafe.arrayIndexScale(int[].class));

        dbase = unsafe.arrayBaseOffset(double[].class);
        dscale = checkIs2Power(unsafe.arrayIndexScale(int[].class));

        fbase = unsafe.arrayBaseOffset(float[].class);
        fscale = checkIs2Power(unsafe.arrayIndexScale(int[].class));

        ibase = unsafe.arrayBaseOffset(int[].class);
        iscale = checkIs2Power(unsafe.arrayIndexScale(int[].class));

        jbase = unsafe.arrayBaseOffset(long[].class);
        jscale = checkIs2Power(unsafe.arrayIndexScale(int[].class));

        sbase = unsafe.arrayBaseOffset(short[].class);
        sscale = checkIs2Power(unsafe.arrayIndexScale(int[].class));

        zbase = unsafe.arrayBaseOffset(boolean[].class);
        zscale = checkIs2Power(unsafe.arrayIndexScale(int[].class));

        lbase = unsafe.arrayBaseOffset(Object[].class);
        lscale = checkIs2Power(unsafe.arrayIndexScale(int[].class));
    }

    private static int checkIs2Power(int scale) {
        if ((scale & (scale - 1)) != 0) throw new Error("data type scale not a power of two");
        return scale;
    }

    public static Unsafe getUnsafe() {
        return unsafe;
    }

    public static long byteOffset(int i, int base, int scale) {
        return ((long) i << (31 - Integer.numberOfLeadingZeros(scale))) + base;
    }

    public static long byteOffset(int i, Class<?> cls) {
        if (cls == Object[].class) return byteOffset(i, lbase, lscale);
        if (cls == byte[].class) return byteOffset(i, bbase, bscale);
        if (cls == char[].class) return byteOffset(i, cbase, cscale);
        if (cls == int[].class) return byteOffset(i, ibase, iscale);
        if (cls == long[].class) return byteOffset(i, jbase, jscale);
        if (cls == boolean[].class) return byteOffset(i, zbase, zscale);
        if (cls == short[].class) return byteOffset(i, sbase, sscale);
        if (cls == double[].class) return byteOffset(i, dbase, dscale);
        if (cls == float[].class) return byteOffset(i, fbase, fscale);
        return byteOffset(i, unsafe.arrayBaseOffset(cls), checkIs2Power(unsafe.arrayIndexScale(cls)));
    }
}