package shz.accept;

import shz.Validator;

import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class MemoryAcceptExecutor<D> extends AcceptExecutor<Void> {
    protected final Queue<D> queue = new ConcurrentLinkedQueue<>();

    protected MemoryAcceptExecutor(String threadName) {
        super(threadName);
    }

    protected MemoryAcceptExecutor() {
        super();
    }

    @Override
    protected boolean acceptable(Void unused) {
        return !queue.isEmpty();
    }

    @Override
    protected void consumer(Void unused) {
        D data = queue.poll();
        if (data != null) consumer0(data);
    }

    public void push(D data) {
        if (Validator.isBlank(data)) return;
        if (queue.size() >= queueSize()) overStrategy(data);
        else {
            queue.offer(data);
            awaken(null);
        }
    }

    protected int queueSize() {
        return 1 << 27;
    }

    protected void overStrategy(D data) {
        //超过限制大小默认丢弃较早数据
        queue.poll();
        queue.offer(data);
        awaken(null);
    }

    public void push(Collection<D> dataset) {
        if (Validator.isEmpty(dataset)) return;
        queue.addAll(dataset);
        awaken(null);
    }

    protected abstract void consumer0(D data);
}
