package shz.compute;

import shz.ToMap;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("unchecked")
public abstract class ComputeDetail<T, D extends ComputeDetail<T, D>> {
    final int capacity;
    Map<ComputeEnum<T, D>, T> data;

    protected ComputeDetail(int capacity) {
        this.capacity = capacity;
    }

    protected ComputeDetail() {
        capacity = 0;
    }

    public final T get(ComputeEnum<T, D> e) {
        if (data == null) {
            if (capacity == 0) data = new HashMap<>();
            else data = ToMap.get(capacity).build();
        }
        T t = data.get(e);
        if (t != null || data.containsKey(e)) return t;
        t = e.compute((D) this);
        data.put(e, t);
        return t;
    }

    public final void clear() {
        if (data != null) data.clear();
    }
}
