package shz.constant;

import shz.PRException;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class NullConstant {
    private NullConstant() {
        throw new IllegalStateException();
    }

    public static final Object OBJECT;
    public static final String STRING;
    public static final Class<?> CLASS;
    public static final Constructor<?> CONSTRUCTOR;
    public static final Method METHOD;
    public static final Field FIELD;

    static {
        try {
            OBJECT = new Object();
            STRING = new String("");
            CLASS = NullConstant.class;
            CONSTRUCTOR = CLASS.getDeclaredConstructor();
            METHOD = CLASS.getDeclaredMethod("nullMethod");
            FIELD = CLASS.getDeclaredField("FIELD");
        } catch (Throwable t) {
            throw PRException.of(t);
        }
    }

    private void nullMethod() {
    }
}
