package shz.encrypt;

import shz.PRException;
import shz.msg.ServerFailureMsg;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.io.Serializable;
import java.security.Key;
import java.security.SecureRandom;

public final class Encipher implements Serializable {
    private static final long serialVersionUID = 2572501969031261484L;
    private EncryptParam encryptParam;
    private Key key;
    private Cipher cipher;

    public Encipher(EncryptParam encryptParam) {
        initKey(encryptParam);
    }

    public void initKey(EncryptParam encryptParam) {
        ServerFailureMsg.requireNon(encryptParam.size != 128 && encryptParam.size != 192 && encryptParam.size != 256, "不支持的密钥大小");
        String[] split = encryptParam.cipherModel.split("/");
        ServerFailureMsg.requireNon(split.length != 3, "不支持的加密模式");
        this.encryptParam = encryptParam;
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(split[0]);
            SecureRandom random = SecureRandom.getInstance(encryptParam.rngAlgorithm, encryptParam.provider);
            random.setSeed(encryptParam.seed.getBytes());
            keyGen.init(encryptParam.size, random);
            this.key = new SecretKeySpec(keyGen.generateKey().getEncoded(), split[0]);
            this.cipher = Cipher.getInstance(encryptParam.cipherModel);
        } catch (Throwable t) {
            throw PRException.of(t);
        }
    }

    public byte[] encrypt(byte[] plaintext) {
        try {
            if (encryptParam.iv == null || encryptParam.iv.length == 0) cipher.init(Cipher.ENCRYPT_MODE, key);
            else cipher.init(Cipher.ENCRYPT_MODE, key, new IvParameterSpec(encryptParam.iv));
            return cipher.doFinal(plaintext);
        } catch (Throwable t) {
            throw PRException.of(t);
        }
    }

    public byte[] decrypt(byte[] ciphertext) {
        try {
            if (encryptParam.iv == null || encryptParam.iv.length == 0) cipher.init(Cipher.DECRYPT_MODE, key);
            else cipher.init(Cipher.DECRYPT_MODE, key, new IvParameterSpec(encryptParam.iv));
            return cipher.doFinal(ciphertext);
        } catch (Throwable t) {
            throw PRException.of(t);
        }
    }
}