package shz.encrypt;

import shz.Serializer;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

public interface EncryptManager {
    EncryptParam getEncryptParam(String id);

    String sign(EncryptParam encryptParam, Object data);

    default String sign(String id, Object data) {
        return sign(getEncryptParam(id), data);
    }

    void checkSign(EncryptParam encryptParam, String signature, Object data);

    default void checkSign(String id, String signature, Object data) {
        checkSign(getEncryptParam(id), signature, data);
    }

    default Encipher getEncipher(EncryptParam encryptParam) {
        return new Encipher(encryptParam);
    }

    default byte[] serialize(Object obj) {
        return Serializer.serialize(obj);
    }

    default <T> T deserialize(byte[] bytes) {
        return Serializer.deserialize(bytes);
    }

    default String encodeBytes(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    default byte[] decodeString(String str) {
        return Base64.getDecoder().decode(str);
    }

    default byte[] stringToBytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    default String bytesToString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    default String encrypt(EncryptParam encryptParam, Object data) {
        return encodeBytes(getEncipher(encryptParam).encrypt(serialize(data)));
    }

    default String encrypt(String id, Object data) {
        return encrypt(getEncryptParam(id), data);
    }

    default <T> T decrypt(EncryptParam encryptParam, String signature, String ciphertext) {
        Encipher encipher = getEncipher(encryptParam);
        T data = deserialize(encipher.decrypt(decodeString(ciphertext)));
        checkSign(encryptParam, signature, data);
        return data;
    }

    default <T> T decrypt(String id, String signature, String ciphertext) {
        return decrypt(getEncryptParam(id), signature, ciphertext);
    }
}