package shz.encrypt;

import java.io.Serializable;
import java.util.Arrays;

public final class EncryptParam implements Serializable {
    private static final long serialVersionUID = -1781742178160108726L;
    String rngAlgorithm = "SHA1PRNG";
    String provider = "SUN";
    String seed;
    Integer size = 128;
    byte[] iv;
    String cipherModel = "AES/CBC/PKCS5Padding";
    String publicKey;
    String signKey;

    public String getRngAlgorithm() {
        return rngAlgorithm;
    }

    public void setRngAlgorithm(String rngAlgorithm) {
        this.rngAlgorithm = rngAlgorithm;
    }

    public String getProvider() {
        return provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getSeed() {
        return seed;
    }

    public void setSeed(String seed) {
        this.seed = seed;
    }

    public Integer getSize() {
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public byte[] getIv() {
        return iv;
    }

    public void setIv(byte[] iv) {
        this.iv = iv;
    }

    public String getCipherModel() {
        return cipherModel;
    }

    public void setCipherModel(String cipherModel) {
        this.cipherModel = cipherModel;
    }

    public String getPublicKey() {
        return publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getSignKey() {
        return signKey;
    }

    public void setSignKey(String signKey) {
        this.signKey = signKey;
    }

    @Override
    public String toString() {
        return "EncryptParam{" +
                "rngAlgorithm='" + rngAlgorithm + '\'' +
                ", provider='" + provider + '\'' +
                ", seed='" + seed + '\'' +
                ", size=" + size +
                ", iv=" + Arrays.toString(iv) +
                ", cipherModel='" + cipherModel + '\'' +
                ", publicKey='" + publicKey + '\'' +
                ", signKey='" + signKey + '\'' +
                '}';
    }
}
