package shz.enums;

import shz.Help;

public enum ByteUnit implements NameCodeEnum<Integer> {
    T(40), G(30), MB(20), KB(10), B(0);

    private final Integer value;

    ByteUnit(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public String toString(long size, int scale) {
        StringBuilder sb = new StringBuilder().append(size >>> value);
        if (scale > 0) {
            String s = Double.toString(Help.setScale(1.0 * (size & ~(-1L << value)) / (1L << value), scale));
            if (!s.endsWith(".0")) sb.append(s, 1, s.length());
        }
        return sb.append(name()).toString();
    }

    public String toString(long size) {
        return toString(size, 3);
    }
}
