package shz.enums;

public enum Cmp implements NameCodeEnum<String> {
    EQ("等于") {
        @Override
        public <T extends Comparable<T>> boolean cmp(T one, T other) {
            if (one == null || other == null) return false;
            return one.compareTo(other) == 0;
        }
    },
    LT("小于") {
        @Override
        public <T extends Comparable<T>> boolean cmp(T one, T other) {
            if (one == null || other == null) return false;
            return one.compareTo(other) < 0;
        }
    },
    LE("小于等于") {
        @Override
        public <T extends Comparable<T>> boolean cmp(T one, T other) {
            if (one == null || other == null) return false;
            return one.compareTo(other) <= 0;
        }
    },
    GT("大于") {
        @Override
        public <T extends Comparable<T>> boolean cmp(T one, T other) {
            if (one == null || other == null) return false;
            return one.compareTo(other) > 0;
        }
    },
    GE("大于等于") {
        @Override
        public <T extends Comparable<T>> boolean cmp(T one, T other) {
            if (one == null || other == null) return false;
            return one.compareTo(other) >= 0;
        }
    },

    ;
    private final String value;

    Cmp(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public abstract <T extends Comparable<T>> boolean cmp(T one, T other);
}
