package shz.enums;

import shz.*;
import shz.msg.ClientFailureMsg;

import java.util.*;

/**
 * 通用枚举接口
 */
@SuppressWarnings("unchecked")
public interface IEnum<C, V> {
    String name();

    int ordinal();

    C getCode();

    V getValue();

    /**
     * 枚举类型，用于查找不到报错提示
     */
    default String enumType() {
        return getClass().getSimpleName();
    }

    /**
     * 枚举通用方法，通过编码获取实例
     */
    static <C, E extends Enum<E>, T extends IEnum<C, ?>> T getByCode(boolean auto, Class<T> cls, C code) {
        if (code == null) return null;
        List<E> es = AccessibleHelp.enumSet(cls);
        if (es.isEmpty()) return null;
        String s = code.toString();
        T t = es.stream().map(e -> (T) e).filter(e -> s.equals(e.getCode().toString())).findFirst().orElse(null);
        if (auto && t == null) throw PRException.of(ClientFailureMsg.fail("%s编码:%s不存在", ((T) es.get(0)).enumType(), s));
        return t;
    }

    static <C, T extends IEnum<C, ?>> T getByCode(Class<T> cls, C code) {
        return getByCode(true, cls, code);
    }

    /**
     * 获取实例集
     */
    static <C, E extends Enum<E>, T extends IEnum<C, ?>> List<T> getByCodes(Class<T> cls, C... codes) {
        if (Validator.isEmpty(codes)) return Collections.emptyList();
        Set<String> set = ToSet.explicitCollect(Arrays.stream(codes).filter(Objects::nonNull).map(Object::toString), codes.length);
        if (set.isEmpty()) return Collections.emptyList();
        List<E> es = AccessibleHelp.enumSet(cls);
        if (es.isEmpty()) return Collections.emptyList();
        return ToList.explicitCollect(es.stream().map(e -> (T) e).filter(e -> set.contains(e.getCode().toString())), Math.min(set.size(), es.size()));
    }
}
