package shz.enums;

public enum Sex implements IEnum<Integer, String> {
    UNKNOWN(0, "未知"), MALE(1, "男"), FEMALE(2, "女");

    private final Integer code;
    private final String value;

    Sex(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    @Override
    public Integer getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
