package shz.handler;

public interface ConsistentHandler<ID> {
    /**
     * 对各个服务的资源做检测以及对资源进行锁定或者预留
     */
    boolean try0(ID id);

    /**
     * 在各个服务执行实际操作
     */
    void confirm(ID id);

    /**
     * 任何一个服务业务失败则回滚
     */
    void cancel(ID id);
}
