package shz.handler.translate;

import shz.AccessibleHelp;
import shz.ToList;
import shz.ToMap;
import shz.Validator;
import shz.enums.IEnum;
import shz.enums.SimpleEnum;
import shz.enums.TypeEnum;
import shz.model.CodeValue;

import java.util.*;

@SuppressWarnings("unchecked")
public interface TranslateEnum extends SimpleEnum {
    Class<? extends IEnum<?, String>> type();

    default String enumName() {
        return null;
    }

    default Map<String, String> codeValueMap() {
        List<?> ts = AccessibleHelp.enumSet(type());
        if (ts.isEmpty()) return Collections.emptyMap();
        List<IEnum<?, String>> enums = ToList.explicitCollect(ts.stream().map(e -> (IEnum<?, String>) e), ts.size());

        String enumName = enumName();
        if (enumName == null)
            return ToMap.explicitCollect(enums.stream(), e -> e.getCode().toString(), IEnum::getValue, enums.size(), 0, true);

        IEnum<?, String> iEnum = enums.stream().filter(e -> enumName.equals(e.name())).findFirst().orElse(null);
        if (iEnum instanceof TypeEnum) {
            List<CodeValue> values = ((TypeEnum) iEnum).codeValues();
            if (Validator.isEmpty(values)) return Collections.emptyMap();
            return ToMap.explicitCollect(values.stream(), CodeValue::getCode, CodeValue::getValue, values.size(), 0, true);
        }

        return Collections.emptyMap();
    }
}
