package shz.handler.verify;

import shz.Validator;
import shz.msg.ClientFailure;

public abstract class AbstractGenerateVerifyHandler<K, V, T extends VerifyParam<K, V>> implements GenerateVerifyHandler<T> {
    @Override
    public final void generate(T param) {
        generate0(param);
        put(param.key(), param.value(), param.expireTimestamp());
    }

    @Override
    public final void verify(T param) {
        K key = param.key();
        V value = get(key, param.expireTimestamp());
        ClientFailure.INVALID_VERIFY_CODE.requireNon(Validator.isBlank(value));
        if (!param.equals(value, param.value())) {
            ClientFailure.ERROR_VERIFY_CODE.requireNon(!delete(param));
            delete(key);
            ClientFailure.INVALID_VERIFY_CODE.requireNon(true);
        }
        delete(key);
    }

    protected abstract void generate0(T param);

    protected abstract void put(K key, V value, long expireTimestamp);

    protected abstract V get(K key, long expireTimestamp);

    protected abstract void delete(K key);

    protected boolean delete(T param) {
        return false;
    }
}
