package shz.id;

public final class IdInfo {
    /**
     * 中心节点
     */
    long datacenterId;
    /**
     * 工作节点
     */
    long workerId;
    /**
     * 时间戳
     */
    long timestamp;
    /**
     * 同一毫秒内的自增序列
     */
    long sequence;

    /**
     * 中心节点位数（0-7）
     * 1-12
     */
    long datacenterIdBits = 3L;
    /**
     * 工作节点位数（0-7）
     * 1-12
     */
    long workerIdBits = 3L;
    /**
     * 时间戳位数（在id中有效值 2^41-1）
     * 38-41
     */
    long timestampBits = 41L;
    /**
     * 序列位数（0-4095）
     * 12-23
     */
    long sequenceBits = 12L;

    public IdInfo(long datacenterId, long workerId, long datacenterIdBits, long workerIdBits) {
        this.datacenterId = datacenterId;
        this.workerId = workerId;
        this.datacenterIdBits = datacenterIdBits;
        this.workerIdBits = workerIdBits;
    }

    public IdInfo(long datacenterId, long workerId) {
        this.datacenterId = datacenterId;
        this.workerId = workerId;
    }

    public IdInfo() {
    }

    public long getDatacenterId() {
        return datacenterId;
    }

    public void setDatacenterId(long datacenterId) {
        this.datacenterId = datacenterId;
    }

    public long getWorkerId() {
        return workerId;
    }

    public void setWorkerId(long workerId) {
        this.workerId = workerId;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getSequence() {
        return sequence;
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    public long getDatacenterIdBits() {
        return datacenterIdBits;
    }

    public void setDatacenterIdBits(long datacenterIdBits) {
        this.datacenterIdBits = datacenterIdBits;
    }

    public long getWorkerIdBits() {
        return workerIdBits;
    }

    public void setWorkerIdBits(long workerIdBits) {
        this.workerIdBits = workerIdBits;
    }

    public long getTimestampBits() {
        return timestampBits;
    }

    public void setTimestampBits(long timestampBits) {
        this.timestampBits = timestampBits;
    }

    public long getSequenceBits() {
        return sequenceBits;
    }

    public void setSequenceBits(long sequenceBits) {
        this.sequenceBits = sequenceBits;
    }

    @Override
    public String toString() {
        return "IdInfo{" +
                "datacenterId=" + datacenterId +
                ", workerId=" + workerId +
                ", timestamp=" + timestamp +
                ", sequence=" + sequence +
                ", datacenterIdBits=" + datacenterIdBits +
                ", workerIdBits=" + workerIdBits +
                ", timestampBits=" + timestampBits +
                ", sequenceBits=" + sequenceBits +
                '}';
    }
}
