package shz.linked;

import shz.UnsafeHelp;

/**
 * 元素类型为double支持并发的单向链表节点
 * <p>
 * 16*n(n为元素个数)
 * <p>
 * B=16*(n+1)
 */
@SuppressWarnings("restriction")
public class ConcurrentDSNode implements SNode {
    public volatile double val;
    protected volatile ConcurrentDSNode next;

    protected ConcurrentDSNode(double val) {
        this.val = val;
    }

    public static ConcurrentDSNode of(double e) {
        return new ConcurrentDSNode(e);
    }

    public static ConcurrentDSNode of() {
        return of(0d);
    }

    private static final long valOffset;
    private static final long nextOffset;

    static {
        try {
            Class<?> k = ConcurrentDSNode.class;
            valOffset = UnsafeHelp.getUnsafe().objectFieldOffset(k.getDeclaredField("val"));
            nextOffset = UnsafeHelp.getUnsafe().objectFieldOffset(k.getDeclaredField("next"));
        } catch (Exception e) {
            throw new Error(e);
        }
    }

    public final boolean casVal(double expect, double val) {
        return UnsafeHelp.getUnsafe().compareAndSwapObject(this, valOffset, expect, val);
    }

    public final boolean casNext(ConcurrentDSNode expect, ConcurrentDSNode next) {
        return UnsafeHelp.getUnsafe().compareAndSwapObject(this, nextOffset, expect, next);
    }

    @Override
    public final ConcurrentDSNode next() {
        return next;
    }

    @Override
    public final void next(SNode node) {
        next = (ConcurrentDSNode) node;
    }

    @Override
    public final ConcurrentDSNode addNext(SNode node) {
        ConcurrentDSNode cdsNode = (ConcurrentDSNode) node;
        ConcurrentDSNode next;
        do {
            next = this.next;
            cdsNode.next = next;
        } while (!casNext(next, cdsNode));
        return cdsNode;
    }

    @Override
    public final ConcurrentDSNode addPrev(SNode node) {
        ConcurrentDSNode cdsNode = addNext(node);
        double val;
        do {
            val = this.val;
        } while (!casVal(val, cdsNode.val));
        cdsNode.val = val;
        return this;
    }

    @Override
    public final void poll() {
        if (next == null) this.val = 0d;
        else {
            ConcurrentDSNode next = this.next;
            if (casNext(next, next.next)) this.val = next.val;
        }
    }

    public final ConcurrentDSNode addNext(double e) {
        return addNext(of(e));
    }

    public final ConcurrentDSNode addNext(double... es) {
        ConcurrentDSNode next = this;
        for (double e : es) next = next.addNext(e);
        return next;
    }

    public final ConcurrentDSNode addPrev(double e) {
        return addPrev(of(e));
    }

    public final ConcurrentDSNode addPrev(double... es) {
        for (double e : es) addPrev(e);
        return this;
    }
}