package shz.linked;

/**
 * 元素类型为double的双向链表节点
 * <p>
 * 24*n(n为元素个数)
 * <p>
 * B=16+24*n
 */
public class DDNode implements DNode {
    public double val;
    protected DDNode next;
    protected DDNode prev;

    protected DDNode(double val) {
        this.val = val;
    }

    public static DDNode of(double e) {
        return new DDNode(e);
    }

    public static DDNode of() {
        return of(0d);
    }

    @Override
    public final DDNode next() {
        return next;
    }

    @Override
    public final void next(DNode node) {
        next = (DDNode) node;
    }

    @Override
    public final DDNode prev() {
        return prev;
    }

    @Override
    public final void prev(DNode node) {
        prev = (DDNode) node;
    }

    public final DDNode addNext(double e) {
        return (DDNode) addNext(of(e));
    }

    public final DDNode addNext(double... es) {
        DDNode next = this;
        for (double e : es) next = next.addNext(e);
        return next;
    }

    public final DDNode addPrev(double e) {
        return (DDNode) addPrev(of(e));
    }

    public final DDNode addPrev(double... es) {
        DDNode prev = this;
        for (double e : es) prev = prev.addPrev(e);
        return prev;
    }
}