package shz.linked;

import java.util.function.Function;
import java.util.function.Predicate;

/**
 * 双向链表节点
 */
public interface DNode {
    DNode next();

    void next(DNode node);

    DNode prev();

    void prev(DNode node);

    default DNode addNext(DNode node) {
        node.prev(this);
        node.next(next());
        next().prev(node);
        next(node);
        return node;
    }

    default DNode addPrev(DNode node) {
        node.prev(prev());
        node.next(this);
        prev().next(node);
        prev(node);
        return node;
    }

    default void poll() {
        if (prev() != null) prev().next(next());
        if (next() != null) next().prev(prev());
        prev(null);
        next(null);
    }

    default DNode findNext(Predicate<DNode> predicate) {
        if (predicate == null) throw new NullPointerException();
        for (DNode next = this; next != null; next = next.next()) if (predicate.test(next)) return next;
        return null;
    }

    default DNode findPrev(Predicate<DNode> predicate) {
        if (predicate == null) throw new NullPointerException();
        for (DNode prev = this; prev != null; prev = prev.prev()) if (predicate.test(prev)) return prev;
        return null;
    }

    default void forEachNext(Function<DNode, Boolean> func) {
        if (func == null) throw new NullPointerException();
        for (DNode next = this; next != null; next = next.next()) {
            Boolean stop = func.apply(next);
            if (stop != null && stop) break;
        }
    }

    default void forEachPrev(Function<DNode, Boolean> func) {
        if (func == null) throw new NullPointerException();
        for (DNode prev = this; prev != null; prev = prev.prev()) {
            Boolean stop = func.apply(prev);
            if (stop != null && stop) break;
        }
    }
}