package shz.linked;

/**
 * 元素类型为double的单向链表节点
 * <p>
 * 16*n(n为元素个数)
 * <p>
 * B=16*(n+1)
 */
public class DSNode implements SNode {
    public double val;
    protected DSNode next;

    protected DSNode(double val) {
        this.val = val;
    }

    public static DSNode of(double e) {
        return new DSNode(e);
    }

    public static DSNode of() {
        return of(0d);
    }

    @Override
    public final DSNode next() {
        return next;
    }

    @Override
    public final void next(SNode node) {
        next = (DSNode) node;
    }

    @Override
    public final DSNode addPrev(SNode node) {
        addNext(node);
        double val = this.val;
        DSNode dsNode = (DSNode) node;
        this.val = dsNode.val;
        dsNode.val = val;
        return this;
    }

    @Override
    public final void poll() {
        if (next != null) {
            this.val = next.val;
            next = next.next;
        } else this.val = 0L;
    }

    public final DSNode addNext(double e) {
        return (DSNode) addNext(of(e));
    }

    public final DSNode addNext(double... es) {
        DSNode next = this;
        for (double e : es) next = next.addNext(e);
        return next;
    }

    public final DSNode addPrev(double e) {
        return addPrev(of(e));
    }

    public final DSNode addPrev(double... es) {
        for (double e : es) addPrev(e);
        return this;
    }
}