package shz.linked;

/**
 * 元素类型为long的双向链表节点
 * <p>
 * 24*n(n为元素个数)
 * <p>
 * B=16+24*n
 */
public class JDNode implements DNode {
    public long val;
    protected JDNode next;
    protected JDNode prev;

    protected JDNode(long val) {
        this.val = val;
    }

    public static JDNode of(long e) {
        return new JDNode(e);
    }

    public static JDNode of() {
        return of(0L);
    }

    @Override
    public final JDNode next() {
        return next;
    }

    @Override
    public final void next(DNode node) {
        next = (JDNode) node;
    }

    @Override
    public final JDNode prev() {
        return prev;
    }

    @Override
    public final void prev(DNode node) {
        prev = (JDNode) node;
    }

    public final JDNode addNext(long e) {
        return (JDNode) addNext(of(e));
    }

    public final JDNode addNext(long... es) {
        JDNode next = this;
        for (long e : es) next = next.addNext(e);
        return next;
    }

    public final JDNode addPrev(long e) {
        return (JDNode) addPrev(of(e));
    }

    public final JDNode addPrev(long... es) {
        JDNode prev = this;
        for (long e : es) prev = prev.addPrev(e);
        return prev;
    }
}